/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java.feign;

import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.java.JavaCodeWriter;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Service;

public class ServiceWriter
extends JavaCodeWriter<JavaContext> {
    private static final String GET_MAPPING = "org.springframework.web.bind.annotation.GetMapping";
    private static final String POST_MAPPING = "org.springframework.web.bind.annotation.PostMapping";
    private static final String PUT_MAPPING = "org.springframework.web.bind.annotation.PutMapping";
    private static final String DELETE_MAPPING = "org.springframework.web.bind.annotation.DeleteMapping";
    public static final String PATCH_MAPPING = "org.springframework.web.bind.annotation.PatchMapping";
    private static final String REQUEST_PARAM = "org.springframework.web.bind.annotation.RequestParam";
    private static final String PATH_VARIABLE = "org.springframework.web.bind.annotation.PathVariable";
    private static final String REQUEST_BODY = "org.springframework.web.bind.annotation.RequestBody";
    private final Service service;

    public ServiceWriter(JavaContext ctx, Service service) {
        super(ctx, ctx.getFile(service));
        this.service = service;
    }

    @Override
    protected void write() {
        this.importType("org.springframework.cloud.openfeign.FeignClient");
        this.code('\n');
        this.document(this.service.getDocument());
        this.code("@FeignClient(name = \"").code(((JavaContext)this.ctx).getModuleFile().getName()).code("\")\n");
        this.code("public interface ").code(this.file.getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Operation operation : this.service.getOperations()) {
                this.writeOperation(operation);
            }
        });
    }

    private void writeOperation(Operation operation) {
        String annotation;
        this.code('\n');
        this.document(operation.getDocument());
        switch (operation.getHttpMethod()) {
            case POST: {
                annotation = POST_MAPPING;
                break;
            }
            case PUT: {
                annotation = PUT_MAPPING;
                break;
            }
            case DELETE: {
                annotation = DELETE_MAPPING;
                break;
            }
            case PATCH: {
                annotation = PATCH_MAPPING;
                break;
            }
            default: {
                annotation = GET_MAPPING;
            }
        }
        this.code('@');
        this.typeRef(annotation).code("(\"").code(operation.getUri()).code("\")\n");
        this.typeRef(operation.getType()).code(' ').code(((JavaContext)this.ctx).getOperationName(operation));
        this.scope(CodeWriter.ScopeType.ARGUMENTS, ", ", operation.getParameters().size() > 2, () -> {
            for (Parameter parameter : operation.getParameters()) {
                this.separator();
                if (parameter.getRequestParam() != null) {
                    this.code('@');
                    this.typeRef(REQUEST_PARAM).code("(name = \"").code(parameter.getRequestParam()).code("\"");
                    if (parameter.getType() instanceof NullableType) {
                        this.code(", required = false");
                    }
                    this.code(") ");
                } else if (parameter.getPathVariable() != null) {
                    this.code('@');
                    this.typeRef(PATH_VARIABLE).code("(\"").code(parameter.getPathVariable()).code("\") ");
                } else if (parameter.isRequestBody()) {
                    this.code('@');
                    this.typeRef(REQUEST_BODY).code(' ');
                }
                this.typeRef(parameter.getType()).code(' ').code(parameter.getName());
            }
        });
        this.code(";\n");
    }
}

