/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.FetchBy;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeResolvingException;
import org.babyfish.jimmer.client.runtime.impl.Graph;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.runtime.impl.ListTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.PropertyImpl;
import org.babyfish.jimmer.client.runtime.impl.TypeContext;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.Nullable;

public class FetchedTypeImpl
extends Graph
implements ObjectType {
    private final ImmutableType immutableType;
    private Map<String, Property> properties;
    private FetchByInfo fetchByInfo;
    private Doc doc;
    private boolean isRecursiveFetchedType;
    private boolean hasMultipleRecursiveProps;

    public FetchedTypeImpl(ImmutableType immutableType) {
        this.immutableType = immutableType;
    }

    void init(String fetchBy, TypeName fetchOwner, Doc fetcherDoc, TypeContext ctx) {
        Class<?> ownerType = ctx.javaType(fetchOwner);
        this.fetchByInfo = new FetchByInfo(fetchBy, ownerType, fetcherDoc);
        Fetcher<?> fetcher = this.staticFetcher(fetchBy, ownerType);
        if (fetcher == null && (fetcher = FetchedTypeImpl.kotlinFetcher(fetchBy, ownerType)) == null) {
            throw new IllegalApiException("Illegal annotation \"@" + FetchBy.class.getName() + "\", there is no static fetcher \"" + fetchBy + "\" declared in \"" + ownerType.getName() + "\"");
        }
        this.initProperties(fetcher, null, ctx);
    }

    private void initProperties(Fetcher<?> fetcher, Prop parentRecursiveProp, TypeContext ctx) {
        TypeDefinition definition = ctx.definition(this.immutableType.getJavaClass());
        try {
            this.doc = definition.getDoc();
            ImmutableProp idProp = this.immutableType.getIdProp();
            Prop idMetaProp = this.getProp(definition, idProp.getName(), ctx);
            LinkedHashMap<String, PropertyImpl> properties = new LinkedHashMap<String, PropertyImpl>();
            try {
                properties.put(idProp.getName(), new PropertyImpl(idProp.getName(), ctx.parseType(this.getProp(definition, idMetaProp.getName(), ctx).getType()), idMetaProp.getDoc()));
            }
            catch (Throwable ex) {
                throw new TypeResolvingException(definition.getTypeName(), '@' + idProp.getName(), ex);
            }
            int recursionCount = 0;
            for (org.babyfish.jimmer.sql.fetcher.Field field : fetcher.getFieldMap().values()) {
                try {
                    Type type;
                    if (field.isImplicit()) continue;
                    ImmutableProp prop = field.getProp();
                    Prop metaProp = this.getProp(definition, field.getProp().getName(), ctx);
                    if (prop.isAssociation(TargetLevel.ENTITY)) {
                        FetchedTypeImpl targetType = new FetchedTypeImpl(prop.getTargetType());
                        Fetcher childFetcher = field.getChildFetcher();
                        if (childFetcher != null) {
                            targetType.initProperties(childFetcher, (Prop)(field.getRecursionStrategy() != null ? metaProp : null), ctx);
                        }
                        if (field.getRecursionStrategy() != null) {
                            ++recursionCount;
                        }
                        if (prop.isReferenceList(TargetLevel.ENTITY)) {
                            type = new ListTypeImpl(targetType);
                        } else {
                            type = targetType;
                            if (metaProp.getType().isNullable()) {
                                type = NullableTypeImpl.of(type);
                            }
                        }
                    } else {
                        type = ctx.parseType(metaProp.getType());
                    }
                    properties.put(prop.getName(), new PropertyImpl(prop.getName(), type, metaProp.getDoc()));
                }
                catch (Throwable ex) {
                    throw new TypeResolvingException(definition.getTypeName(), '@' + field.getProp().getName(), ex);
                }
            }
            if (parentRecursiveProp != null) {
                properties.put(parentRecursiveProp.getName(), new PropertyImpl(parentRecursiveProp.getName(), (Type)((Object)(parentRecursiveProp.getType().getTypeName().toString().equals("java.util.List") ? new ListTypeImpl(this) : this)), parentRecursiveProp.getDoc()));
            }
            this.hasMultipleRecursiveProps = recursionCount > 1;
            this.isRecursiveFetchedType = parentRecursiveProp != null;
            this.properties = Collections.unmodifiableMap(properties);
        }
        catch (TypeResolvingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TypeResolvingException(definition.getTypeName(), ex);
        }
    }

    private Prop getProp(TypeDefinition definition, String name, TypeContext ctx) {
        Prop prop = this.getProp0(definition, name, ctx);
        if (prop == null) {
            throw new IllegalApiException("There is no property \"" + name + "\" in \"" + definition.getTypeName() + "\"");
        }
        return prop;
    }

    private Prop getProp0(TypeDefinition definition, String name, TypeContext ctx) {
        Prop prop = (Prop)definition.getPropMap().get(name);
        if (prop != null) {
            return prop;
        }
        for (TypeRef superTypeRef : definition.getSuperTypes()) {
            TypeDefinition superTypeDefinition = ctx.definition(superTypeRef.getTypeName());
            prop = this.getProp0(superTypeDefinition, name, ctx);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    @Override
    public Class<?> getJavaType() {
        return this.immutableType.getJavaClass();
    }

    @Override
    @Nullable
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public ObjectType.Kind getKind() {
        return ObjectType.Kind.FETCHED;
    }

    @Override
    public List<String> getSimpleNames() {
        return Collections.singletonList(this.getJavaType().getSimpleName());
    }

    @Override
    @Nullable
    public FetchByInfo getFetchByInfo() {
        return this.fetchByInfo;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    @Override
    @Nullable
    public TypeDefinition.Error getError() {
        return null;
    }

    @Override
    @Nullable
    public List<Type> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isRecursiveFetchedType() {
        return this.isRecursiveFetchedType;
    }

    @Override
    public boolean hasMultipleRecursiveProps() {
        return this.hasMultipleRecursiveProps;
    }

    @Override
    public ObjectType unwrap() {
        return null;
    }

    private Fetcher<?> staticFetcher(String fetchBy, Class<?> ownerType) {
        Field field;
        try {
            field = ownerType.getDeclaredField(fetchBy);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        if (!(Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && Fetcher.class.isAssignableFrom(field.getType()))) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (Fetcher)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalApiException("Cannot get `" + fetchBy + "` of \"" + ownerType.getName() + "\"");
        }
    }

    private static Fetcher<?> kotlinFetcher(String fetchBy, Class<?> ownerType) {
        Field companionField;
        try {
            companionField = ownerType.getDeclaredField("Companion");
        }
        catch (NoSuchFieldException ex) {
            companionField = null;
        }
        Object companion = null;
        Field field = null;
        if (companionField != null) {
            companionField.setAccessible(true);
            try {
                companion = companionField.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (companion != null) {
                try {
                    field = companionField.getType().getDeclaredField(fetchBy);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (field == null) {
            return null;
        }
        if (!Fetcher.class.isAssignableFrom(field.getType())) {
            throw new IllegalApiException("Illegal annotation @" + FetchBy.class.getName() + ", the field \"" + field + "\" must return fetcher");
        }
        field.setAccessible(true);
        try {
            return (Fetcher)field.get(companion);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalApiException("Cannot get `" + fetchBy + "` of \"" + ownerType.getName() + "\"");
        }
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        return this.immutableType.toString() + '{' + (this.properties != null ? this.properties.values().stream().map(it -> FetchedTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) : "") + '}';
    }
}

