/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.DocUtils;
import org.babyfish.jimmer.client.generator.ts.NullRenderMode;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.FetchedTypeImpl;

public class FetchedTypeRender
implements Render {
    private final String dtoName;
    private final String name;
    private final ObjectType objectType;
    private final String fetcherPrefix;
    private final LinkedList<String> paths = new LinkedList();
    final Map<Type, String> recursiveTypeNames;

    public FetchedTypeRender(String dtoName, String name, ObjectType objectType, Map<Type, String> recursiveTypeNames) {
        FetchByInfo fetchByInfo = objectType.getFetchByInfo();
        assert (fetchByInfo != null);
        this.dtoName = dtoName;
        this.name = name;
        this.objectType = objectType;
        this.recursiveTypeNames = recursiveTypeNames;
        this.fetcherPrefix = fetchByInfo.getOwnerType().getSimpleName() + '/' + fetchByInfo.getConstant();
        this.collectRecursiveTypeNames(objectType);
    }

    private void collectRecursiveTypeNames(ObjectType type) {
        if (type.isRecursiveFetchedType()) {
            if (this.recursiveTypeNames.containsKey(type)) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.fetcherPrefix);
            ListIterator<String> itr = this.paths.listIterator(this.paths.size());
            while (itr.hasPrevious()) {
                builder.append('@').append(itr.previous());
            }
            this.recursiveTypeNames.put(type, builder.toString());
        }
        for (Property property : type.getProperties().values()) {
            boolean isList;
            Type targetType = property.getType();
            boolean isNullable = targetType instanceof NullableType;
            if (isNullable) {
                targetType = ((NullableType)targetType).getTargetType();
            }
            if (isList = targetType instanceof ListType) {
                targetType = ((ListType)targetType).getElementType();
            }
            if (!(targetType instanceof ObjectType)) continue;
            ObjectType targetObjectType = (ObjectType)targetType;
            if (targetObjectType.isRecursiveFetchedType() && !this.objectType.hasMultipleRecursiveProps()) {
                this.collectRecursiveTypeNames((ObjectType)targetType);
                continue;
            }
            this.paths.push(property.getName());
            this.collectRecursiveTypeNames((ObjectType)targetType);
            this.paths.pop();
        }
    }

    @Override
    public void render(SourceWriter writer) {
        assert (this.objectType.getFetchByInfo() != null);
        Doc doc = this.objectType.getFetchByInfo().getDoc();
        if (doc == null) {
            doc = this.objectType.getDoc();
        }
        writer.doc(doc, new SourceWriter.DocPart[0]);
        ((SourceWriter)((SourceWriter)writer.code('\'')).code(this.name)).code("': ");
        FetchedTypeRender.render(this.dtoName, this.objectType, writer, this.recursiveTypeNames);
    }

    static void render(String dtoName, ObjectType type, SourceWriter writer, Map<Type, String> recursiveTypeNames) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : type.getProperties().values()) {
                boolean isList;
                writer.separator();
                DocUtils.doc(property, type.getDoc(), writer);
                ((SourceWriter)writer.codeIf(!ctx.isMutable(), "readonly ")).code(property.getName());
                Type targetType = property.getType();
                boolean isNullable = targetType instanceof NullableType;
                if (isNullable) {
                    targetType = ((NullableType)targetType).getTargetType();
                }
                if (isList = targetType instanceof ListType) {
                    targetType = ((ListType)targetType).getElementType();
                }
                String recursiveTypeName = (String)recursiveTypeNames.get(targetType);
                ((SourceWriter)writer.codeIf(property.getType() instanceof NullableType || recursiveTypeName != null, '?')).code(": ");
                if (targetType instanceof FetchedTypeImpl) {
                    ObjectType targetObjectType = (ObjectType)targetType;
                    FetchedTypeRender.writeResolvedType(writer, isNullable, isList, () -> {
                        if (recursiveTypeName != null) {
                            ((SourceWriter)((SourceWriter)((SourceWriter)writer.code(dtoName)).code("['")).code(recursiveTypeName)).code("']");
                        } else {
                            FetchedTypeRender.render(dtoName, targetObjectType, writer, recursiveTypeNames);
                        }
                    });
                } else {
                    writer.typeRef(property.getType());
                }
                writer.codeIf(recursiveTypeName != null && !(property.getType() instanceof NullableType), ctx.getNullRenderMode() == NullRenderMode.NULL_OR_UNDEFINED ? " | null | undefined" : " | undefined");
                writer.code(';');
            }
        });
    }

    private static void writeResolvedType(SourceWriter writer, boolean isNullable, boolean isList, Runnable block) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        if (isList) {
            writer.code(ctx.isMutable() ? "Array<" : "ReadonlyArray<");
        }
        block.run();
        if (isList) {
            writer.code('>');
        }
        if (isNullable) {
            writer.code(ctx.getNullRenderMode() == NullRenderMode.NULL_OR_UNDEFINED ? " | null | undefined" : " | undefined");
        }
    }
}

