/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.source.AbstractSource;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceFile;

public abstract class SourceManager {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("/|\\.");
    private final Context ctx;
    private final IdentityHashMap<Service, Source> serviceSourceMap = new IdentityHashMap();
    private final IdentityHashMap<Service, Source> serviceImplSourceMap = new IdentityHashMap();
    private final IdentityHashMap<Operation, Source> operationSourceMap = new IdentityHashMap();
    private final IdentityHashMap<Type, Source> typeSourceMap = new IdentityHashMap();
    private final Map<String, Source> rootSourceMap = new TreeMap<String, Source>();

    protected SourceManager(Context ctx) {
        this.ctx = ctx;
    }

    public Collection<Source> getRootSources() {
        return Collections.unmodifiableCollection(this.rootSourceMap.values());
    }

    public Source getRootSource(String name) {
        Source source = this.rootSourceMap.get(name);
        if (source == null) {
            throw new IllegalArgumentException("No source \"" + name + "\"");
        }
        return source;
    }

    public final Source getSource(Service service) {
        Source source = this.serviceSourceMap.get(service);
        if (source != null) {
            return source;
        }
        source = this.createServiceSource(service);
        if (source == null) {
            throw new IllegalStateException("The \"createServiceSource\" of \"" + this.getClass().getName() + "\" cannot return null");
        }
        this.serviceSourceMap.put(service, source);
        Source implSource = this.createServiceImplSource(service);
        if (implSource != null) {
            this.serviceImplSourceMap.put(service, implSource);
        }
        return source;
    }

    public final Source getSource(Operation operation) {
        Source source = this.operationSourceMap.get(operation);
        if (source != null) {
            return source;
        }
        source = this.createOperationSource(operation);
        if (source == null) {
            throw new IllegalStateException("The \"createOperationSource\" of \"" + this.getClass().getName() + "\" cannot return null");
        }
        this.operationSourceMap.put(operation, source);
        return source;
    }

    public final Source getSource(Type type) {
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            ObjectType unwrapped = objectType.unwrap();
            return this.objectTypeSource(unwrapped != null ? unwrapped : objectType);
        }
        if (type instanceof EnumType) {
            return this.enumTypeSource((EnumType)type);
        }
        return null;
    }

    protected final <C extends Context> C getContext() {
        return (C)this.ctx;
    }

    protected final Source createRootSource(String dir, String name, Supplier<Render> renderSupplier) {
        List<String> dirs = SourceManager.dirs(dir);
        String key = AbstractSource.toString(dirs, name);
        if (this.rootSourceMap.containsKey(key)) {
            throw new IllegalStateException("The source \"" + key + "\" already exists");
        }
        SourceFile source = new SourceFile(dirs, name, renderSupplier.get());
        this.rootSourceMap.put(key, source);
        return source;
    }

    private Source objectTypeSource(ObjectType objectType) {
        Source source = this.typeSourceMap.get(objectType);
        if (source != null) {
            return source;
        }
        if (objectType.getKind() == ObjectType.Kind.ERROR) {
            throw new IllegalApiException("The exception type \"" + objectType.getJavaType().getName() + "\" can only be referenced by `java throws keyword` or `@kotlin.Throws`");
        }
        if (objectType.getKind() == ObjectType.Kind.STATIC) {
            ObjectType unwrapped = objectType.unwrap();
            source = this.createStaticTypeSource(unwrapped != null ? unwrapped : objectType);
            if (source == null) {
                throw new IllegalStateException("The \"createStaticTypeSource\" of \"" + this.getClass().getName() + "\" cannot return null");
            }
        } else if (objectType.getKind() == ObjectType.Kind.DYNAMIC) {
            source = this.createDynamicTypeSource(objectType);
            if (source == null) {
                throw new IllegalStateException("The \"createDynamicTypeSource\" of \"" + this.getClass().getName() + "\" cannot return null");
            }
        } else if (objectType.getKind() == ObjectType.Kind.EMBEDDABLE) {
            source = this.createEmbeddableTypeSource(objectType);
            if (source == null) {
                throw new IllegalStateException("The \"createEmbeddableTypeSource\" of \"" + this.getClass().getName() + "\" cannot return null");
            }
        } else {
            source = this.createFetchedTypeSource(objectType);
            if (source == null) {
                throw new IllegalStateException("The \"createFetchedTypeSource\" of \"" + this.getClass().getName() + "\" cannot return null");
            }
        }
        this.typeSourceMap.put(objectType, source);
        return source;
    }

    private Source enumTypeSource(EnumType enumType) {
        Source source = this.typeSourceMap.get(enumType);
        if (source != null) {
            return source;
        }
        source = this.createEnumTypeSource(enumType);
        if (source == null) {
            throw new IllegalStateException("The \"createEnumTypeSource\" of \"" + this.getClass().getName() + "\" cannot return null");
        }
        this.typeSourceMap.put(enumType, source);
        return source;
    }

    protected abstract Source createServiceSource(Service var1);

    protected Source createServiceImplSource(Service service) {
        return null;
    }

    protected abstract Source createOperationSource(Operation var1);

    protected abstract Source createStaticTypeSource(ObjectType var1);

    protected abstract Source createFetchedTypeSource(ObjectType var1);

    protected abstract Source createDynamicTypeSource(ObjectType var1);

    protected abstract Source createEmbeddableTypeSource(ObjectType var1);

    protected abstract Source createEnumTypeSource(EnumType var1);

    public void createAdditionalSources() {
    }

    public static List<String> dirs(String dir) {
        if (dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.isEmpty()) {
            return Collections.emptyList();
        }
        String[] arr = SEPARATOR_PATTERN.split(dir);
        ArrayList<String> list = new ArrayList<String>(arr.length);
        list.addAll(Arrays.asList(arr));
        return Collections.unmodifiableList(list);
    }
}

