/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.Set;
import org.babyfish.jimmer.client.runtime.MapType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.Graph;

public class MapTypeImpl
extends Graph
implements MapType {
    private final Type keyType;
    private final Type valueType;

    public MapTypeImpl(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getValueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTypeImpl mapType = (MapTypeImpl)o;
        if (!this.keyType.equals(mapType.keyType)) {
            return false;
        }
        return this.valueType.equals(mapType.valueType);
    }

    public int hashCode() {
        int result = this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        return "map<" + MapTypeImpl.string(this.keyType, stack) + ", " + MapTypeImpl.string(this.valueType, stack) + ">";
    }
}

