/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.VirtualType;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;

public class OperationRender
implements Render {
    private final String name;
    private final Operation operation;

    public OperationRender(String name, Operation operation) {
        this.name = name;
        this.operation = operation;
    }

    @Override
    public void render(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)writer.doc(this.operation.getDoc(), SourceWriter.DocPart.PARAM, SourceWriter.DocPart.RETURN).code("readonly ")).code(this.name)).code(": ");
        if (!this.operation.getParameters().isEmpty()) {
            writer.scope(CodeWriter.ScopeType.ARGUMENTS, ", ", false, () -> ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("options: ")).code(writer.getSource().getRoot().getName())).code("Options['")).code(this.name)).code("']"));
        } else {
            writer.code("()");
        }
        writer.code(" => Promise");
        writer.scope(CodeWriter.ScopeType.GENERIC, ", ", true, () -> {
            if (this.operation.getReturnType() == null) {
                writer.code("void");
            } else {
                writer.typeRef(this.operation.getReturnType());
            }
        });
        writer.code(" = ");
        ((SourceWriter)((SourceWriter)writer.code("async(")).codeIf(!this.operation.getParameters().isEmpty(), "options")).code(") => ");
        writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.renderImpl(writer));
        writer.code('\n');
    }

    private void renderImpl(SourceWriter writer) {
        List list;
        Object builder;
        List<UriPart> uriParts = UriPart.parts(this.operation.getUri());
        if (uriParts.get((int)0).variable) {
            Parameter parameter = OperationRender.pathVariableParameter(this.operation, uriParts.get((int)0).text);
            ((SourceWriter)((SourceWriter)((SourceWriter)writer.code("let _uri = encodeURIComponent(options.")).code(parameter.getName())).codeIf(parameter.getType() instanceof ListType, ".join(',')")).code(");\n");
        } else {
            ((SourceWriter)((SourceWriter)writer.code("let _uri = '")).code(uriParts.get((int)0).text)).code("';\n");
        }
        for (int i = 1; i < uriParts.size(); ++i) {
            if (uriParts.get((int)i).variable) {
                Parameter parameter = OperationRender.pathVariableParameter(this.operation, uriParts.get((int)i).text);
                ((SourceWriter)((SourceWriter)((SourceWriter)writer.code("_uri += encodeURIComponent(options.")).code(parameter.getName())).codeIf(parameter.getType() instanceof ListType, ".join(',')")).code(");\n");
                continue;
            }
            ((SourceWriter)((SourceWriter)writer.code("_uri += '")).code(uriParts.get((int)i).text)).code("';\n");
        }
        LinkedHashMap<String, Object> pathBuilderMap = new LinkedHashMap<String, Object>();
        for (Parameter parameter : this.operation.getParameters()) {
            if (parameter.getPathVariable() != null || parameter.getRequestParam() != null || parameter.getRequestHeader() != null || parameter.getRequestPart() != null || parameter.isRequestBody()) continue;
            PathBuilder builder2 = new PathBuilder();
            builder2.dot().append(parameter.getName());
            Type type = parameter.getType();
            if (type instanceof NullableType) {
                builder2.nullable();
                type = ((NullableType)type).getTargetType();
            }
            if (type instanceof ListType) {
                builder2.dot().append("join(',')");
                pathBuilderMap.put(parameter.getName(), builder2);
                continue;
            }
            if (type instanceof SimpleType) {
                pathBuilderMap.put(parameter.getName(), builder2);
                continue;
            }
            if (!(type instanceof ObjectType)) continue;
            for (Property prop : ((ObjectType)type).getProperties().values()) {
                PathBuilder newBuilder = new PathBuilder(builder2);
                newBuilder.dot().append(prop.getName());
                Type newType = prop.getType();
                if (newType instanceof NullableType) {
                    newBuilder.nullable();
                    newType = ((NullableType)newType).getTargetType();
                }
                if (newType instanceof ListType) {
                    newBuilder.dot().append("join(',')");
                    pathBuilderMap.put(prop.getName(), newBuilder);
                    continue;
                }
                if (!(newType instanceof SimpleType)) continue;
                pathBuilderMap.put(prop.getName(), newBuilder);
            }
        }
        boolean hasHeader = this.operation.getParameters().stream().anyMatch(it -> it.getRequestHeader() != null);
        if (hasHeader) {
            writer.code("const _headers: {[key:string]: string} = ");
            writer.scope(CodeWriter.ScopeType.OBJECT, ", ", false, () -> {
                for (Parameter parameter : this.operation.getParameters()) {
                    String header = parameter.getRequestHeader();
                    if (header == null || parameter.getType() instanceof NullableType) continue;
                    ((SourceWriter)((SourceWriter)((SourceWriter)writer.separator()).code(header)).code(": options.")).code(parameter.getName());
                }
            });
            writer.code(";\n");
        }
        for (Parameter parameter : this.operation.getParameters()) {
            Type type;
            if (parameter.getRequestHeader() != null) {
                String header = parameter.getRequestHeader();
                type = parameter.getType();
                if (!(type instanceof NullableType)) continue;
                ((SourceWriter)((SourceWriter)writer.code("if (options.")).code(parameter.getName())).code(") ");
                ((SourceWriter)writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("_headers['")).code(header)).code("'] = options.")).code(parameter.getName())).code('\n'))).code('\n');
                continue;
            }
            if (parameter.getRequestParam() == null) continue;
            builder = new PathBuilder();
            ((PathBuilder)builder).dot().append(parameter.getName());
            type = parameter.getType();
            if (type instanceof NullableType) {
                ((PathBuilder)builder).nullable();
                type = ((NullableType)type).getTargetType();
            }
            if (type instanceof ListType) {
                ((PathBuilder)builder).dot().append("join(',')");
                pathBuilderMap.put(parameter.getRequestParam(), builder);
                continue;
            }
            if (!(type instanceof SimpleType) && !(type instanceof EnumType)) continue;
            pathBuilderMap.put(parameter.getRequestParam(), builder);
        }
        if (!pathBuilderMap.isEmpty()) {
            writer.code("let _separator = _uri.indexOf('?') === -1 ? '?' : '&';\n");
            writer.code("let _value: any = undefined;\n");
            for (Map.Entry e : pathBuilderMap.entrySet()) {
                builder = (PathBuilder)e.getValue();
                ((SourceWriter)((SourceWriter)writer.code("_value = options")).code(((PathBuilder)builder).toString())).code(";\n");
                writer.code("if (_value !== undefined && _value !== null) ");
                writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                    writer.code("_uri += _separator\n");
                    ((SourceWriter)((SourceWriter)writer.code("_uri += '")).code((String)e.getKey() + "=")).code("'\n");
                    writer.code("_uri += encodeURIComponent(_value);\n");
                    writer.code("_separator = '&';\n");
                });
                writer.code("\n");
            }
        }
        if (!(list = this.operation.getParameters().stream().filter(it -> it.getRequestPart() != null).collect(Collectors.toList())).isEmpty()) {
            writer.code("const _formData = new FormData();\n");
            writer.code("const _body = options.body;\n");
            boolean notNull = list.stream().anyMatch(p -> !(p.getType() instanceof NullableType));
            if (notNull) {
                for (Parameter parameter : list) {
                    if (parameter.getType() instanceof NullableType) {
                        ((SourceWriter)((SourceWriter)writer.code("if (_body.")).code(parameter.getName())).code(") ");
                        ((SourceWriter)writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.renderRequestPart(parameter, writer))).code('\n');
                        continue;
                    }
                    this.renderRequestPart(parameter, writer);
                }
            } else {
                ((SourceWriter)writer.code("if (_body) ")).scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                    for (Parameter parameter : requestPartParameters) {
                        if (parameter.getType() instanceof NullableType) {
                            ((SourceWriter)((SourceWriter)writer.code("if (_body.")).code(parameter.getName())).code(") ");
                            ((SourceWriter)writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.renderRequestPart(parameter, writer))).code('\n');
                            continue;
                        }
                        this.renderRequestPart(parameter, writer);
                    }
                });
            }
        }
        ((SourceWriter)((SourceWriter)writer.code("return (await this.executor({uri: _uri, method: '")).code(this.operation.getHttpMethods().get(0).name())).code("'");
        if (hasHeader) {
            writer.code(", headers: _headers");
        }
        for (Parameter parameter : this.operation.getParameters()) {
            if (!parameter.isRequestBody()) continue;
            writer.code(", body: options.body");
        }
        if (!list.isEmpty()) {
            writer.code(", body: _formData");
        }
        writer.code("})) as Promise<");
        if (this.operation.getReturnType() == null) {
            writer.code("void");
        } else {
            writer.typeRef(this.operation.getReturnType());
        }
        writer.code(">;");
    }

    private void renderRequestPart(Parameter parameter, SourceWriter writer) {
        Type type = NullableTypeImpl.unwrap(parameter.getType());
        if (type instanceof VirtualType.File) {
            ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("_formData.append(\"")).code(parameter.getRequestPart())).code("\", _body.")).code(parameter.getName())).code(");\n");
        } else if (type instanceof ListType && NullableTypeImpl.unwrap(((ListType)type).getElementType()) instanceof VirtualType.File) {
            ((SourceWriter)((SourceWriter)writer.code("for (const file of _body.")).code(parameter.getName())).code(") ");
            ((SourceWriter)writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> ((SourceWriter)((SourceWriter)writer.code("_formData.append(\"")).code(parameter.getRequestPart())).code("\", file);\n"))).code('\n');
        } else {
            ((SourceWriter)((SourceWriter)writer.code("_formData.append")).scope(CodeWriter.ScopeType.ARGUMENTS, ", ", true, () -> {
                ((SourceWriter)((SourceWriter)writer.code('\"')).code(parameter.getRequestPart())).code('\"');
                writer.separator();
                ((SourceWriter)writer.code("new Blob")).scope(CodeWriter.ScopeType.ARGUMENTS, ", ", true, () -> {
                    ((SourceWriter)((SourceWriter)writer.code("[JSON.stringify(_body.")).code(parameter.getName())).code(")]");
                    writer.separator();
                    writer.code("{type: \"application/json\"}");
                });
            })).code(";\n");
        }
    }

    private static Parameter pathVariableParameter(Operation operation, String pathVariable) {
        for (Parameter parameter : operation.getParameters()) {
            if (!pathVariable.equals(parameter.getPathVariable())) continue;
            return parameter;
        }
        throw new IllegalApiException("Illegal operation \"" + operation.getJavaMethod() + "\", the path variable {" + pathVariable + "} cannot be resolved by any parameter");
    }

    private static class UriPart {
        private static final Pattern SLASH_PATTERN = Pattern.compile("\\{(.+?)(?::(?:[^{}]+|\\{[^{}]+?})+)?}");
        final String text;
        final boolean variable;

        private UriPart(String text, boolean variable) {
            this.text = text;
            this.variable = variable;
        }

        public static List<UriPart> parts(String uri) {
            if (!uri.startsWith("/")) {
                uri = '/' + uri;
            }
            ArrayList<UriPart> uriParts = new ArrayList<UriPart>();
            Matcher matcher = SLASH_PATTERN.matcher(uri);
            int pos = 0;
            while (matcher.find()) {
                if (matcher.start() > pos) {
                    uriParts.add(new UriPart(uri.substring(pos, matcher.start()), false));
                }
                uriParts.add(new UriPart(matcher.group(1), true));
                pos = matcher.end();
            }
            if (pos < uri.length()) {
                uriParts.add(new UriPart(uri.substring(pos, uri.length()), false));
            }
            return uriParts;
        }
    }

    private static class PathBuilder {
        private final StringBuilder builder;
        private boolean nullable;

        PathBuilder() {
            this.builder = new StringBuilder();
        }

        PathBuilder(PathBuilder base) {
            this.builder = new StringBuilder(base.builder);
            this.nullable = base.nullable;
        }

        public PathBuilder nullable() {
            this.nullable = true;
            return this;
        }

        public PathBuilder dot() {
            if (this.nullable) {
                this.builder.append("?.");
            } else {
                this.builder.append('.');
            }
            return this;
        }

        public PathBuilder append(String text) {
            int size = text.length();
            for (int i = 0; i < size; ++i) {
                char c = text.charAt(i);
                if (this.nullable && c == '.') {
                    this.builder.append("?.");
                    continue;
                }
                this.builder.append(c);
            }
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

