/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeResolvingException;
import org.babyfish.jimmer.client.runtime.impl.PropertyImpl;
import org.babyfish.jimmer.client.runtime.impl.TypeContext;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.Nullable;

public class DynamicTypeImpl
implements ObjectType {
    private final ImmutableType immutableType;
    private Map<String, Property> properties;
    private Doc doc;

    public DynamicTypeImpl(ImmutableType immutableType) {
        this.immutableType = immutableType;
    }

    void init(TypeName typeName, TypeContext ctx) {
        try {
            TypeDefinition definition = ctx.definition(typeName);
            this.doc = definition.getDoc();
            LinkedHashMap<String, PropertyImpl> properties = new LinkedHashMap<String, PropertyImpl>((definition.getPropMap().size() * 4 + 2) / 3);
            for (Prop prop : definition.getPropMap().values()) {
                try {
                    PropertyImpl property = new PropertyImpl(prop.getName(), ctx.parseType(prop.getType()), prop.getDoc());
                    properties.put(property.getName(), property);
                }
                catch (Throwable ex) {
                    throw new TypeResolvingException(typeName, '@' + prop.getName(), ex);
                }
            }
            this.properties = Collections.unmodifiableMap(properties);
        }
        catch (TypeResolvingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TypeResolvingException(typeName, ex);
        }
    }

    @Override
    public Class<?> getJavaType() {
        return this.immutableType.getJavaClass();
    }

    @Override
    @Nullable
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public ObjectType.Kind getKind() {
        return ObjectType.Kind.DYNAMIC;
    }

    @Override
    public List<String> getSimpleNames() {
        return Collections.singletonList(this.getJavaType().getSimpleName());
    }

    @Override
    @Nullable
    public FetchByInfo getFetchByInfo() {
        return null;
    }

    @Override
    public List<Type> getArguments() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    @Override
    @Nullable
    public TypeDefinition.Error getError() {
        return null;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isRecursiveFetchedType() {
        return false;
    }

    @Override
    public boolean hasMultipleRecursiveProps() {
        return false;
    }

    @Override
    public ObjectType unwrap() {
        return null;
    }
}

