/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeVariable;
import org.babyfish.jimmer.client.runtime.VirtualType;
import org.babyfish.jimmer.client.runtime.impl.DynamicTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.EmbeddableTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.EnumTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.FetchedTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.GenericTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.runtime.impl.ListTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.MapTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.SimpleTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.StaticObjectTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.TypeVariableImpl;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.Embeddable;
import org.jetbrains.annotations.Nullable;

class TypeContext {
    private final Map<TypeName, TypeDefinition> definitionMap;
    private final Map<TypeName, VirtualType> virtualTypeMap;
    private final boolean isGenericSupported;
    private final Map<TypeName, Class<?>> javaTypeMap = new HashMap();
    private final Map<FetchedKey, FetchedTypeImpl> fetchedTypeMap = new LinkedHashMap<FetchedKey, FetchedTypeImpl>();
    private final Map<TypeName, DynamicTypeImpl> dynamicTypeMap = new LinkedHashMap<TypeName, DynamicTypeImpl>();
    private final Map<TypeName, EmbeddableTypeImpl> embeddableTypeMap = new LinkedHashMap<TypeName, EmbeddableTypeImpl>();
    private final Map<StaticKey, StaticObjectTypeImpl> staticTypeMap = new LinkedHashMap<StaticKey, StaticObjectTypeImpl>();
    private final Map<TypeName, EnumTypeImpl> enumTypeMap = new TreeMap<TypeName, EnumTypeImpl>();
    private final Map<TypeDefinition.Error, StaticObjectTypeImpl> errorTypeMap = new HashMap<TypeDefinition.Error, StaticObjectTypeImpl>();
    private GenericReplace genericReplace;

    public TypeContext(Map<TypeName, TypeDefinition> definitionMap, Map<TypeName, VirtualType> virtualTypeMap, boolean isGenericSupported) {
        this.definitionMap = definitionMap;
        this.virtualTypeMap = virtualTypeMap;
        this.isGenericSupported = isGenericSupported;
    }

    Collection<FetchedTypeImpl> fetchedTypes() {
        return Collections.unmodifiableCollection(this.fetchedTypeMap.values());
    }

    Collection<DynamicTypeImpl> dynamicTypes() {
        return Collections.unmodifiableCollection(this.dynamicTypeMap.values());
    }

    Collection<EmbeddableTypeImpl> embeddableTypes() {
        return Collections.unmodifiableCollection(this.embeddableTypeMap.values());
    }

    Collection<StaticObjectTypeImpl> staticTypes() {
        return Collections.unmodifiableCollection(this.staticTypeMap.values());
    }

    Collection<EnumTypeImpl> enumTypes() {
        return Collections.unmodifiableCollection(this.enumTypeMap.values());
    }

    TypeDefinition definition(Class<?> type) {
        return this.definitionMap.get(TypeName.of(type));
    }

    TypeDefinition definition(TypeName typeName) {
        TypeDefinition definition = this.definitionMap.get(typeName);
        if (definition == null) {
            throw new IllegalApiException("No type definition for \"" + typeName + "\"");
        }
        return definition;
    }

    Type parseType(TypeRef typeRef) {
        if (typeRef.isNullable()) {
            return NullableTypeImpl.of(this.parseNonNullType(typeRef));
        }
        return this.parseNonNullType(typeRef);
    }

    private Type parseNonNullType(TypeRef typeRef) {
        TypeName typeName = typeRef.getTypeName();
        VirtualType virtualType = this.virtualTypeMap.get(typeName);
        if (virtualType != null) {
            return virtualType;
        }
        if (typeName.getTypeVariable() != null) {
            if (this.genericReplace == null) {
                return new TypeVariableImpl(typeName);
            }
            return this.genericReplace.resolve(typeName);
        }
        if (!typeName.isGenerationRequired() && typeRef.getArguments().isEmpty()) {
            return SimpleTypeImpl.of(typeName);
        }
        TypeDefinition definition = this.definitionMap.get(typeName);
        if (definition != null && definition.getKind() == TypeDefinition.Kind.IMMUTABLE) {
            if (typeRef.getFetchBy() == null) {
                Class<?> javaType = this.javaType(typeName);
                return javaType.isAnnotationPresent(Embeddable.class) ? this.embeddableType(typeName) : this.dynamicType(typeName);
            }
            return this.fetchedType(new FetchedKey(typeName, typeRef.getFetchBy(), typeRef.getFetcherOwner()), typeRef.getFetcherDoc());
        }
        if (definition != null && definition.getKind() == TypeDefinition.Kind.ENUM) {
            return this.enumTypeMap.computeIfAbsent(typeName, it -> new EnumTypeImpl(this.javaType((TypeName)it), this.definition((TypeName)it)));
        }
        switch (typeName.toString()) {
            case "java.util.List": {
                return new ListTypeImpl(this.parseType((TypeRef)typeRef.getArguments().get(0)));
            }
            case "java.util.Map": {
                return new MapTypeImpl(this.parseType((TypeRef)typeRef.getArguments().get(0)), this.parseType((TypeRef)typeRef.getArguments().get(1)));
            }
        }
        List<Type> arguments = typeRef.getArguments().stream().map(this::parseType).collect(Collectors.toList());
        if (this.isGenericSupported && !arguments.isEmpty()) {
            StaticObjectTypeImpl raw = this.staticType(new StaticKey(typeName, Collections.emptyList()));
            return new GenericTypeImpl(raw, arguments);
        }
        return this.staticType(new StaticKey(typeName, arguments));
    }

    Class<?> javaType(TypeName typeName) {
        return this.javaTypeMap.computeIfAbsent(typeName, it -> {
            try {
                return Class.forName(typeName.toString(true), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generic(Class<?> rawType, List<Type> arguments, Runnable block) {
        if (arguments.isEmpty()) {
            block.run();
            return;
        }
        java.lang.reflect.TypeVariable<Class<?>>[] arr = rawType.getTypeParameters();
        GenericReplace genericReplace = new GenericReplace(this.genericReplace);
        for (int i = 0; i < arr.length; ++i) {
            TypeName typeName = TypeName.of(rawType).typeVariable(arr[i].getName());
            genericReplace.map.put(typeName, arguments.get(i));
        }
        this.genericReplace = genericReplace;
        try {
            block.run();
        }
        finally {
            this.genericReplace = genericReplace.parent;
        }
    }

    private FetchedTypeImpl fetchedType(FetchedKey key, Doc fetcherDoc) {
        FetchedTypeImpl objectType = this.fetchedTypeMap.get(key);
        if (objectType != null) {
            return objectType;
        }
        objectType = new FetchedTypeImpl(ImmutableType.get(this.javaType(key.typeName)));
        this.fetchedTypeMap.put(key, objectType);
        objectType.init(key.fetchBy, key.ownerType, fetcherDoc, this);
        return objectType;
    }

    private DynamicTypeImpl dynamicType(TypeName typeName) {
        DynamicTypeImpl objectType = this.dynamicTypeMap.get(typeName);
        if (objectType != null) {
            return objectType;
        }
        DynamicTypeImpl newObjectType = new DynamicTypeImpl(ImmutableType.get(this.javaType(typeName)));
        this.dynamicTypeMap.put(typeName, newObjectType);
        newObjectType.init(typeName, this);
        return newObjectType;
    }

    private EmbeddableTypeImpl embeddableType(TypeName typeName) {
        EmbeddableTypeImpl objectType = this.embeddableTypeMap.get(typeName);
        if (objectType != null) {
            return objectType;
        }
        EmbeddableTypeImpl newObjectType = new EmbeddableTypeImpl(ImmutableType.get(this.javaType(typeName)));
        this.embeddableTypeMap.put(typeName, newObjectType);
        newObjectType.init(typeName, this);
        return newObjectType;
    }

    private StaticObjectTypeImpl staticType(StaticKey key) {
        StaticObjectTypeImpl conflictType;
        StaticObjectTypeImpl objectType = this.staticTypeMap.get(key);
        if (objectType != null) {
            return objectType;
        }
        StaticObjectTypeImpl newObjectType = new StaticObjectTypeImpl(this.javaType(key.typeName));
        this.staticTypeMap.put(key, newObjectType);
        this.generic(this.javaType(key.typeName), key.arguments, () -> newObjectType.init(key.typeName, key.arguments, this));
        if (newObjectType.getError() != null && !newObjectType.getError().getCode().isEmpty() && (conflictType = this.errorTypeMap.put(newObjectType.getError(), newObjectType)) != null) {
            throw new IllegalApiException("Conflict exceptions, the error family \"" + newObjectType.getError().getFamily() + "\" and code \"" + newObjectType.getError().getCode() + "\" are shared by \"" + newObjectType.getJavaType().getName() + "\" and \"" + conflictType.getJavaType().getTypeName() + "\"");
        }
        return newObjectType;
    }

    private static class GenericReplace {
        final GenericReplace parent;
        final Map<TypeName, Type> map = new HashMap<TypeName, Type>();

        GenericReplace(GenericReplace parent) {
            this.parent = parent;
        }

        Type resolve(TypeName typeName) {
            Type type = this.map.get(typeName);
            if (type instanceof TypeVariable && this.parent != null) {
                this.parent.resolve(((TypeVariable)type).getTypeName());
            }
            if (type != null) {
                return type;
            }
            return new TypeVariableImpl(typeName);
        }
    }

    private static class FetchedKey {
        final TypeName typeName;
        @Nullable
        final String fetchBy;
        @Nullable
        final TypeName ownerType;

        private FetchedKey(TypeName typeName, @Nullable String fetchBy, @Nullable TypeName ownerType) {
            this.typeName = typeName;
            this.fetchBy = fetchBy;
            this.ownerType = ownerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FetchedKey that = (FetchedKey)o;
            if (!this.typeName.equals((Object)that.typeName)) {
                return false;
            }
            if (!Objects.equals(this.fetchBy, that.fetchBy)) {
                return false;
            }
            return Objects.equals(this.ownerType, that.ownerType);
        }

        public int hashCode() {
            int result = this.typeName.hashCode();
            result = 31 * result + (this.fetchBy != null ? this.fetchBy.hashCode() : 0);
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ImmutableType{typeName=" + this.typeName + ", fetchBy='" + this.fetchBy + '\'' + ", ownerType=" + this.ownerType + '}';
        }
    }

    private static class StaticKey {
        final TypeName typeName;
        final List<Type> arguments;

        private StaticKey(TypeName typeName, List<Type> arguments) {
            this.typeName = typeName;
            this.arguments = arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StaticKey key = (StaticKey)o;
            if (!this.typeName.equals((Object)key.typeName)) {
                return false;
            }
            return this.arguments.equals(key.arguments);
        }

        public int hashCode() {
            int result = this.typeName.hashCode();
            result = 31 * result + this.arguments.hashCode();
            return result;
        }

        public String toString() {
            return "Key{typeName=" + this.typeName + ", arguments=" + this.arguments + '}';
        }
    }
}

