/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.Type;

public class OperationImpl
implements Operation {
    private final Service declaringService;
    private final Method javaMethod;
    private Doc doc;
    private String uri;
    private List<Operation.HttpMethod> httpMethods;
    private List<Parameter> parameters;
    private Type returnType;
    private List<ObjectType> exceptionTypes;

    public OperationImpl(Service declaringService, Method javaMethod) {
        this.declaringService = declaringService;
        this.javaMethod = javaMethod;
    }

    @Override
    public Service getDeclaringService() {
        return this.declaringService;
    }

    @Override
    public String getName() {
        return this.javaMethod.getName();
    }

    @Override
    public Doc getDoc() {
        return this.doc;
    }

    void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public List<Operation.HttpMethod> getHttpMethods() {
        return this.httpMethods;
    }

    void setHttpMethods(Operation.HttpMethod[] httpMethods) {
        this.httpMethods = Collections.unmodifiableList(Arrays.stream(httpMethods).distinct().collect(Collectors.toList()));
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    @Override
    public List<ObjectType> getExceptionTypes() {
        return this.exceptionTypes;
    }

    void setExceptionTypes(List<ObjectType> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public String toString() {
        return "OperationImpl{javaMethod=" + this.javaMethod + ", doc=" + this.doc + ", uri='" + this.uri + '\'' + ", httpMethods=" + this.httpMethods + ", parameters=" + this.parameters + ", exceptionTypes=" + this.exceptionTypes + '}';
    }
}

