/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;

public class StaticTypeRender
implements Render {
    private final String name;
    private final ObjectType type;

    public StaticTypeRender(String name, ObjectType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        Doc doc = this.type.getDoc();
        ((SourceWriter)writer.doc(doc, new SourceWriter.DocPart[0]).code("export interface ")).code(this.name);
        if (!this.type.getArguments().isEmpty()) {
            writer.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (Type argument : this.type.getArguments()) {
                    writer.separator();
                    writer.typeRef(argument);
                }
            });
        }
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        ((SourceWriter)writer.code(' ')).scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : this.type.getProperties().values()) {
                if (property.getDoc() != null) {
                    writer.doc(property.getDoc(), new SourceWriter.DocPart[0]);
                } else if (doc != null) {
                    writer.doc((String)doc.getPropertyValueMap().get(property.getName()));
                }
                ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.codeIf(!ctx.isMutable(), "readonly ")).code(property.getName())).codeIf(property.getType() instanceof NullableType, '?')).code(": ")).typeRef(property.getType()).code(";\n");
            }
        });
        writer.code('\n');
    }
}

