/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.regex.Pattern;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.DocUtils;
import org.babyfish.jimmer.client.runtime.EnumType;

public class EnumTypeRender
implements Render {
    private static final Pattern UNDER_LINE_PATTERN = Pattern.compile("_");
    private final String name;
    private final EnumType enumType;
    private final boolean isEnumTsStyle;

    public EnumTypeRender(String name, EnumType enumType, boolean isEnumTsStyle) {
        this.name = name;
        this.enumType = enumType;
        this.isEnumTsStyle = isEnumTsStyle;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export {")).code(this.name)).code("_CONSTANTS} from './")).code(this.name)).code("';\n");
        if (this.isEnumTsStyle) {
            ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export {")).code(this.name)).code("_CONSTANT_MAP} from './")).code(this.name)).code("';\n");
        }
    }

    @Override
    public void render(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)writer.code("export const ")).code(this.name)).code("_CONSTANTS = ");
        writer.scope(CodeWriter.ScopeType.LIST, ", ", true, () -> {
            for (EnumType.Constant constant : this.enumType.getConstants()) {
                writer.separator();
                DocUtils.doc(constant.getDoc(), constant.getName(), this.enumType.getDoc(), writer);
                ((SourceWriter)((SourceWriter)writer.code('\'')).code(constant.getName())).code('\'');
            }
        });
        writer.code(" as const;\n");
        writer.doc(this.enumType.getDoc(), new SourceWriter.DocPart[0]);
        if (this.isEnumTsStyle) {
            ((SourceWriter)((SourceWriter)writer.code("export const ")).code(this.name)).code("_CONSTANT_MAP = ");
            writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                for (EnumType.Constant constant : this.enumType.getConstants()) {
                    writer.separator();
                    DocUtils.doc(constant.getDoc(), constant.getName(), this.enumType.getDoc(), writer);
                    ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code('\"')).code(EnumTypeRender.tsEnumConstant(constant.getName()))).code('\"')).code(": ")).code('\'')).code(constant.getName())).code('\'');
                }
            });
            writer.code(" as const;\n");
            ((SourceWriter)((SourceWriter)writer.code("export enum ")).code(this.name)).code(' ');
            writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                for (EnumType.Constant constant : this.enumType.getConstants()) {
                    writer.separator();
                    DocUtils.doc(constant.getDoc(), constant.getName(), this.enumType.getDoc(), writer);
                    ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code(EnumTypeRender.tsEnumConstant(constant.getName()))).code(" = ")).code('\'')).code(constant.getName())).code('\'');
                }
            });
        } else {
            ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type ")).code(this.name)).code(" = typeof ")).code(this.name)).code("_CONSTANTS[number];\n");
        }
    }

    private static String tsEnumConstant(String javaEnumConstant) {
        StringBuilder builder = new StringBuilder();
        for (String part : UNDER_LINE_PATTERN.split(javaEnumConstant)) {
            if (part.isEmpty()) continue;
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase());
        }
        return builder.toString();
    }
}

