/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.ts.TsCodeWriter;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.FetchByInfo;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Node;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;

public class Context {
    private static final Comparator<Service> SERVICE_COMPARATOR = Comparator.comparing(a -> a.getJavaType().getName());
    private static final Comparator<ImmutableObjectType> DTO_COMPARATOR = Comparator.comparing(Context::totalPropCount).thenComparing(it -> it.getJavaType().getName()).thenComparing(it -> {
        FetchByInfo info = it.getFetchByInfo();
        return info != null ? info.getOwnerType().getName() : "";
    }).thenComparing(it -> {
        FetchByInfo info = it.getFetchByInfo();
        return info != null ? info.getConstant() : "";
    });
    private final OutputStream out;
    private final File moduleFile;
    private final File moduleErrorsFile;
    private final String indent;
    private final Map<Class<?>, List<ImmutableObjectType>> dtoMap;
    private final Map<Class<?>, StaticObjectType> genericTypeMap;
    private final Map<Operation, String> operationNameMap;
    private final NavigableMap<Service, File> serviceFileMap;
    private final Map<Type, File> typeFileMap;
    private final Namespace<Class<?>> fetchByOwnerNamespace;
    private final Namespace<Class<?>> dtoPrefixNamespace;

    public Context(Metadata metadata, OutputStream out, String moduleName, int indent) {
        this.out = out;
        this.moduleFile = new File("", moduleName);
        this.moduleErrorsFile = new File("", moduleName + "Errors");
        if (indent < 2) {
            throw new IllegalArgumentException("indent cannot be less than 2");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = indent; i > 0; --i) {
            builder.append(' ');
        }
        this.indent = builder.toString();
        this.genericTypeMap = metadata.getGenericTypes();
        VisitorImpl impl = new VisitorImpl();
        for (Service service : metadata.getServices().values()) {
            service.accept(impl);
        }
        for (StaticObjectType staticObjectType : metadata.getGenericTypes().values()) {
            staticObjectType.accept(impl);
        }
        this.operationNameMap = impl.operationNamespace.getNameMap();
        HashMap<Class, List> dtoMap = new HashMap<Class, List>();
        for (ImmutableObjectType immutableObjectType : metadata.getFetchedImmutableObjectTypes().values()) {
            dtoMap.computeIfAbsent(immutableObjectType.getJavaType(), it -> new ArrayList()).add(immutableObjectType);
        }
        for (ImmutableObjectType immutableObjectType : metadata.getViewImmutableObjectTypes().values()) {
            dtoMap.computeIfAbsent(immutableObjectType.getJavaType(), it -> new ArrayList()).add(immutableObjectType);
        }
        for (Map.Entry entry : dtoMap.entrySet()) {
            List types = (List)entry.getValue();
            types.sort(DTO_COMPARATOR);
            entry.setValue(Collections.unmodifiableList(types));
        }
        this.dtoMap = Collections.unmodifiableMap(dtoMap);
        TreeMap<Service, File> treeMap = new TreeMap<Service, File>(SERVICE_COMPARATOR);
        treeMap.putAll(impl.serviceFileManager.getFileMap());
        this.serviceFileMap = Collections.unmodifiableNavigableMap(treeMap);
        this.typeFileMap = impl.typeFileManager.getFileMap();
        this.fetchByOwnerNamespace = impl.fetchByOwnerNamespace;
        this.dtoPrefixNamespace = new Namespace<Class>(clazz -> this.staticTypeName((Class<?>)clazz) + "Dto");
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public File getModuleErrorsFile() {
        return this.moduleErrorsFile;
    }

    public String getIndent() {
        return this.indent;
    }

    public File getFile(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null");
        }
        return (File)this.serviceFileMap.get(service);
    }

    public File getFile(Type type) {
        return this.typeFileMap.get(this.rawType(type));
    }

    public String getOperationName(Operation operation) {
        return this.operationNameMap.get(operation);
    }

    public Map<Service, File> getServiceFileMap() {
        return this.serviceFileMap;
    }

    public Iterable<Map.Entry<Type, File>> getTypeFilePairs() {
        return () -> this.typeFileMap.entrySet().iterator();
    }

    public Map<Class<?>, List<ImmutableObjectType>> getDtoMap() {
        return this.dtoMap;
    }

    public String getDtoPrefix(Class<?> rawType) {
        return this.dtoPrefixNamespace.get(rawType);
    }

    public String getDtoSuffix(ImmutableObjectType type) {
        FetchByInfo fetchByInfo = type.getFetchByInfo();
        if (fetchByInfo != null) {
            return this.fetchByOwnerNamespace.get(fetchByInfo.getOwnerType()) + "/" + fetchByInfo.getConstant();
        }
        if (type.getCategory() == ImmutableObjectType.Category.VIEW) {
            return "DEFAULT";
        }
        return null;
    }

    private Type rawType(Type type) {
        StaticObjectType staticObjectType;
        if (type instanceof StaticObjectType && !(staticObjectType = (StaticObjectType)type).getTypeArguments().isEmpty()) {
            return this.genericTypeMap.get(staticObjectType.getJavaType());
        }
        return type;
    }

    private static int totalPropCount(ImmutableObjectType type) {
        int count = type.getProperties().size();
        for (Property prop : type.getProperties().values()) {
            if (!(prop.getType() instanceof ImmutableObjectType)) continue;
            count += Context.totalPropCount((ImmutableObjectType)prop.getType());
        }
        return count;
    }

    protected String dynamicTypeName(ImmutableObjectType type) {
        return type.getJavaType().getSimpleName();
    }

    private String staticTypeName(Class<?> type) {
        Class<?> declaringClass = type.getDeclaringClass();
        if (declaringClass == null) {
            return type.getSimpleName();
        }
        return this.staticTypeName(declaringClass) + this.nestedTypeSeparator() + type.getSimpleName();
    }

    protected String staticDirName() {
        return "model/static";
    }

    protected String nestedTypeSeparator() {
        return ".";
    }

    private class VisitorImpl
    implements Visitor {
        private Set<StaticObjectType> visitedStaticTypes = new HashSet<StaticObjectType>();
        private String serviceName;
        final Namespace<Service> serviceNamespace = new Namespace<Service>(service -> Context.access$200(Context.this, service.getJavaType()));
        final Namespace<Operation> operationNamespace = new Namespace<Operation>(operation -> this.serviceName + "::" + operation.getName(), name -> name.substring(name.indexOf("::") + 2));
        final Namespace<Type> typeNamespace = new Namespace<Type>(type -> {
            if (type instanceof SimpleType) {
                return TsCodeWriter.SIMPLE_TYPE_NAMES.get(((SimpleType)type).getJavaType());
            }
            if (type instanceof ImmutableObjectType) {
                return Context.this.dynamicTypeName((ImmutableObjectType)type);
            }
            if (type instanceof StaticObjectType) {
                Class<?> javaType = ((StaticObjectType)type).getJavaType();
                return Context.this.staticTypeName(javaType);
            }
            if (type instanceof EnumType) {
                return Context.this.staticTypeName(((EnumType)type).getJavaType());
            }
            return null;
        });
        final FileManager<Service> serviceFileManager = new FileManager(service -> "services", this.serviceNamespace);
        final FileManager<Type> typeFileManager = new FileManager(type -> {
            if (!type.hasDefinition()) {
                return null;
            }
            if (type instanceof ImmutableObjectType) {
                return "model/entities";
            }
            if (type instanceof StaticObjectType) {
                return Context.this.staticDirName();
            }
            if (type instanceof EnumType) {
                return "model/enums";
            }
            return null;
        }, this.typeNamespace);
        final Namespace<Class<?>> fetchByOwnerNamespace = new Namespace<Class>(x$0 -> Context.access$200(Context.this, x$0));
        private final Map<Class<?>, List<ImmutableObjectType>> dtoMap = new HashMap();

        private VisitorImpl() {
        }

        @Override
        public void visitingService(Service service) {
            this.serviceName = this.serviceFileManager.add(service).getName();
            this.fetchByOwnerNamespace.get(service.getClass());
        }

        @Override
        public void visitedService(Service service) {
            this.serviceName = null;
        }

        @Override
        public void visitingOperation(Operation operation) {
            this.operationNamespace.get(operation);
        }

        @Override
        public boolean isTypeVisitable(Type type) {
            return !this.typeFileManager.getFileMap().containsKey(type);
        }

        @Override
        public void visitImmutableObjectType(ImmutableObjectType immutableObjectType) {
            if (this.typeFileManager.add(immutableObjectType) == null) {
                this.dtoMap.computeIfAbsent(immutableObjectType.getJavaType(), it -> new ArrayList()).add(immutableObjectType);
            }
        }

        @Override
        public boolean visitStaticObjectType(StaticObjectType staticObjectType) {
            if (this.visitedStaticTypes.add(staticObjectType)) {
                while (staticObjectType.getDeclaringObjectType() != null) {
                    staticObjectType = staticObjectType.getDeclaringObjectType();
                }
                this.typeFileManager.add(staticObjectType);
                return true;
            }
            return false;
        }

        @Override
        public void visitEnumType(EnumType enumType) {
            this.typeFileManager.add(enumType);
        }
    }

    private static class Namespace<T> {
        private final Map<T, String> nameMap = new IdentityHashMap<T, String>();
        private final Map<String, Integer> nameCountMap = new HashMap<String, Integer>();
        private final Function<T, String> initializer;
        private final Function<String, String> terminator;

        Namespace(Function<T, String> initializer) {
            this.initializer = initializer;
            this.terminator = null;
        }

        Namespace(Function<T, String> initializer, Function<String, String> terminator) {
            this.initializer = initializer;
            this.terminator = terminator;
        }

        public String get(T node) {
            String name = this.nameMap.get(node);
            if (name == null) {
                name = this.initializer.apply(node);
                Integer count = this.nameCountMap.get(name);
                if (count == null) {
                    this.nameCountMap.put(name, 1);
                } else {
                    Integer n = count;
                    count = count + 1;
                    this.nameCountMap.put(name, count);
                    name = name + '_' + count;
                }
                if (this.terminator != null) {
                    name = this.terminator.apply(name);
                }
                this.nameMap.put(node, name);
            }
            return name;
        }

        public Map<T, String> getNameMap() {
            return Collections.unmodifiableMap(this.nameMap);
        }
    }

    private static class FileManager<N extends Node> {
        private final Map<N, File> fileMap = new IdentityHashMap<N, File>();
        private final Function<N, String> dirSupplier;
        private final Namespace<N> namespace;

        private FileManager(Function<N, String> dirSupplier, Namespace<N> namespace) {
            this.dirSupplier = dirSupplier;
            this.namespace = namespace;
        }

        public File add(N node) {
            File file = this.fileMap.get(node);
            if (file == null && !this.fileMap.containsKey(node)) {
                String dir = this.dirSupplier.apply(node);
                if (dir == null) {
                    return null;
                }
                String name = this.namespace.get(node);
                file = new File(dir, name);
                this.fileMap.put(node, file);
            }
            return file;
        }

        public Map<N, File> getFileMap() {
            return Collections.unmodifiableMap(this.fileMap);
        }
    }
}

