/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.babyfish.jimmer.client.ExportFields;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.meta.impl.PropertyImpl;
import org.jetbrains.annotations.Nullable;

public class StaticObjectTypeImpl
implements StaticObjectType {
    private final StaticObjectTypeImpl declaringObjectType;
    private final Class<?> javaType;
    private final List<Type> typeArguments;
    private NavigableMap<String, Property> props;
    private final Document document;
    private final NavigableMap<String, StaticObjectType> usedNestedJavaTypes = new TreeMap<String, StaticObjectType>();

    StaticObjectTypeImpl(StaticObjectTypeImpl declaringObjectType, Class<?> javaType, List<Type> typeArguments) {
        this.declaringObjectType = declaringObjectType;
        this.javaType = javaType;
        this.typeArguments = typeArguments != null ? Collections.unmodifiableList(typeArguments) : Collections.emptyList();
        this.document = DocumentImpl.of(javaType);
        if (declaringObjectType != null && (typeArguments == null || typeArguments.isEmpty())) {
            declaringObjectType.usedNestedJavaTypes.put(javaType.getSimpleName(), this);
        }
    }

    @Override
    public StaticObjectTypeImpl getDeclaringObjectType() {
        return this.declaringObjectType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public List<Type> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Collection<StaticObjectType> getNestedTypes() {
        return Collections.unmodifiableCollection(this.usedNestedJavaTypes.values());
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.props;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.isTypeVisitable(this) && visitor.visitStaticObjectType(this)) {
            for (Property prop : this.props.values()) {
                prop.getType().accept(visitor);
            }
        }
    }

    public String toString() {
        if (this.typeArguments.isEmpty()) {
            return "@static:" + this.javaType.getSimpleName();
        }
        return "@static:" + this.javaType.getSimpleName() + "<...>";
    }

    static StaticObjectType create(Context ctx, Class<?> javaType, List<Type> typeArguments) {
        StaticObjectTypeImpl impl = (StaticObjectTypeImpl)ctx.getStaticObjectType(javaType, typeArguments);
        if (impl != null) {
            return impl;
        }
        StaticObjectType declaringObjectType = null;
        Class<?> declaringType = javaType.getDeclaringClass();
        if (declaringType != null) {
            if (!Modifier.isPublic(javaType.getModifiers()) || !Modifier.isStatic(javaType.getModifiers())) {
                throw new IllegalDocMetaException("Cannot parse type \"" + javaType.getName() + "\" declared in \"" + ctx.getLocation() + "\", it is nested class but is not public and static");
            }
            declaringObjectType = StaticObjectTypeImpl.create(ctx, declaringType, Collections.emptyList());
        }
        impl = new StaticObjectTypeImpl((StaticObjectTypeImpl)declaringObjectType, javaType, typeArguments);
        ctx.addStaticObjectType(impl);
        if (declaringObjectType != null && typeArguments != null && !typeArguments.isEmpty()) {
            StaticObjectTypeImpl.create(ctx, javaType, null);
        }
        TreeMap<String, Property> props = new TreeMap<String, Property>();
        StaticObjectTypeImpl.collectProps(ctx, javaType, props);
        impl.props = Collections.unmodifiableNavigableMap(props);
        return impl;
    }

    private static void collectProps(Context ctx, Class<?> javaType, Map<String, Property> props) {
        if (javaType == null || javaType == Object.class) {
            return;
        }
        if (javaType.isAnnotationPresent(ExportFields.class)) {
            for (AccessibleObject accessibleObject : javaType.getDeclaredFields()) {
                if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                Type type = ctx.parseType(((Field)accessibleObject).getAnnotatedType());
                if (ctx.getJetBrainsMetadata(javaType).isNullable((Field)accessibleObject)) {
                    type = NullableTypeImpl.of(type);
                }
                props.putIfAbsent(((Field)accessibleObject).getName(), new PropertyImpl(((Field)accessibleObject).getName(), type, DocumentImpl.of(accessibleObject)));
            }
        } else {
            for (AccessibleObject accessibleObject : javaType.getDeclaredMethods()) {
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Executable)accessibleObject).getParameters().length != 0 || ((Method)accessibleObject).getReturnType() == Void.TYPE) continue;
                String prefix = null;
                if (((Method)accessibleObject).getReturnType() == Boolean.TYPE && ((Method)accessibleObject).getName().startsWith("is")) {
                    prefix = "is";
                } else if (((Method)accessibleObject).getName().startsWith("get")) {
                    prefix = "get";
                }
                if (prefix == null) continue;
                if (((Method)accessibleObject).getTypeParameters().length != 0) {
                    throw new IllegalArgumentException("The getter method \"" + accessibleObject + "\" declared in \"" + ctx.getLocation() + "\" is illegal, it can not have type parameters");
                }
                String name = ((Method)accessibleObject).getName().substring(prefix.length());
                if (name.isEmpty()) continue;
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                Type type = ctx.parseType(((Method)accessibleObject).getAnnotatedReturnType());
                if (ctx.getJetBrainsMetadata(javaType).isNullable((Method)accessibleObject)) {
                    type = NullableTypeImpl.of(type);
                }
                props.put(name, new PropertyImpl(name, type, DocumentImpl.of(accessibleObject)));
            }
        }
        StaticObjectTypeImpl.collectProps(ctx, javaType.getAnnotatedSuperclass(), props);
        for (AnnotatedElement annotatedElement : javaType.getAnnotatedInterfaces()) {
            StaticObjectTypeImpl.collectProps(ctx, (AnnotatedType)annotatedElement, props);
        }
    }

    private static void collectProps(Context ctx, AnnotatedType type, Map<String, Property> props) {
        if (type instanceof AnnotatedParameterizedType) {
            Class rawType = (Class)((ParameterizedType)type.getType()).getRawType();
            StaticObjectTypeImpl.collectProps(new Context(ctx, (AnnotatedParameterizedType)type), rawType, props);
        } else if (type != null) {
            Class rawType = (Class)type.getType();
            StaticObjectTypeImpl.collectProps(ctx, rawType, props);
        }
    }

    private static void collectProps(Context ctx, KClass<?> kotlinType, Map<String, Property> props) {
        for (KProperty1 prop : KClasses.getDeclaredMemberProperties(kotlinType)) {
            Type type = ctx.parseKotlinType(prop.getReturnType());
            if (prop.getReturnType().isMarkedNullable()) {
                type = NullableTypeImpl.of(type);
            }
            Method method = ReflectJvmMapping.getJavaGetter((KProperty)prop);
            props.putIfAbsent(prop.getName(), new PropertyImpl(prop.getName(), type, DocumentImpl.of(method != null ? method : ReflectJvmMapping.getJavaField((KProperty)prop))));
        }
        for (KType superType : kotlinType.getSupertypes()) {
            StaticObjectTypeImpl.collectProps(ctx, superType, props);
        }
    }

    private static void collectProps(Context ctx, KType type, Map<String, Property> props) {
        if (!type.getArguments().isEmpty()) {
            KClass rawClass = (KClass)type.getClassifier();
            StaticObjectTypeImpl.collectProps(new Context(ctx, type), rawClass, props);
        } else {
            KClass rawClass = (KClass)type.getClassifier();
            StaticObjectTypeImpl.collectProps(ctx, rawClass, props);
        }
    }
}

