/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java;

import java.util.List;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.java.JavaCodeWriter;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.MapType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.Type;

public class DtoWriter
extends JavaCodeWriter<JavaContext> {
    private final List<ImmutableObjectType> immutableObjectTypes;

    public DtoWriter(JavaContext ctx, Class<?> rawType) {
        super(ctx, DtoWriter.dtoFile(ctx, rawType));
        this.immutableObjectTypes = ctx.getDtoMap().get(rawType);
    }

    public static File dtoFile(Context ctx, Class<?> rawType) {
        return new File("model/dto", ctx.getDtoPrefix(rawType));
    }

    @Override
    protected void write() {
        this.code("\npublic interface ").code(this.file.getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (ImmutableObjectType immutableObjectType : this.immutableObjectTypes) {
                this.write(immutableObjectType);
            }
        });
    }

    private void write(ImmutableObjectType type) {
        this.code("\nclass ").code(((JavaContext)this.getContext()).getDtoSuffix(type).replace('/', '_')).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            this.writeFields(type);
            this.writeProperties(type);
            this.writeTargetTypeDeclarations(type);
        });
        this.code('\n');
    }

    private void writeFields(ImmutableObjectType type) {
        for (Property prop : type.getProperties().values()) {
            this.handleDtoProp(prop, () -> this.writeField(prop));
        }
    }

    private void writeProperties(ImmutableObjectType type) {
        for (Property prop : type.getProperties().values()) {
            this.handleDtoProp(prop, () -> this.writeProperty(prop));
        }
    }

    private void writeTargetTypeDeclarations(ImmutableObjectType type) {
        for (Property prop : type.getProperties().values()) {
            this.handleDtoProp(prop, () -> this.writeTargetTypeDeclaration(prop.getType()));
        }
    }

    private void writeTargetTypeDeclaration(Type type) {
        if (type instanceof NullableType) {
            this.writeTargetTypeDeclaration(((NullableType)type).getTargetType());
        } else if (type instanceof ArrayType) {
            this.writeTargetTypeDeclaration(((ArrayType)type).getElementType());
        } else if (type instanceof MapType) {
            this.writeTargetTypeDeclaration(((MapType)type).getKeyType());
            this.writeTargetTypeDeclaration(((MapType)type).getValueType());
        } else if (type instanceof ImmutableObjectType) {
            this.code("\npublic static class ").code(this.tempDtoTypeName()).code(' ');
            this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                this.writeFields((ImmutableObjectType)type);
                this.writeProperties((ImmutableObjectType)type);
                this.writeTargetTypeDeclarations((ImmutableObjectType)type);
            });
            this.code('\n');
        }
    }
}

