/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.List;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.ts.TsCodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsContext;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;

public class DtoWriter
extends TsCodeWriter {
    private final List<ImmutableObjectType> immutableObjectTypes;

    public DtoWriter(TsContext ctx, Class<?> rawType) {
        super(ctx, DtoWriter.dtoFile(ctx, rawType));
        this.immutableObjectTypes = ctx.getDtoMap().get(rawType);
    }

    public static File dtoFile(Context ctx, Class<?> rawType) {
        return new File("model/dto", ctx.getDtoPrefix(rawType));
    }

    @Override
    protected void write() {
        this.code("export type ").code(this.getFile().getName()).code(" = ");
        this.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (ImmutableObjectType type : this.immutableObjectTypes) {
                this.separator();
                this.code('\'').code(((TsContext)this.getContext()).getDtoSuffix(type)).code("': ");
                this.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                    for (Property prop : type.getProperties().values()) {
                        this.separator();
                        this.code("readonly ").code(prop.getName()).codeIf(prop.getType() instanceof NullableType, '?').code(": ").typeRef(NullableType.unwrap(prop.getType()));
                    }
                });
            }
        });
    }
}

