/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.client.Doc;
import org.babyfish.jimmer.client.Docs;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.spi.EntityPropImplementor;
import org.jetbrains.annotations.Nullable;

class DocumentImpl
implements Document {
    private final List<Document.Item> items;

    private DocumentImpl(List<Document.Item> items) {
        this.items = items;
    }

    @Nullable
    static Document of(ImmutableProp prop) {
        return DocumentImpl.of(((EntityPropImplementor)prop).getJavaGetter());
    }

    @Nullable
    static Document of(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return null;
        }
        ArrayList<Document.Item> items = new ArrayList<Document.Item>();
        Docs docs = annotatedElement.getAnnotation(Docs.class);
        if (docs != null) {
            for (Doc doc : docs.value()) {
                items.add(DocumentImpl.itemOf(doc));
            }
        } else {
            Doc doc = annotatedElement.getAnnotation(Doc.class);
            if (doc != null) {
                items.add(DocumentImpl.itemOf(doc));
            }
        }
        if (items.isEmpty()) {
            return null;
        }
        return new DocumentImpl(items);
    }

    static Document.Item itemOf(Doc doc) {
        int index;
        String text = doc.value();
        int size = text.length();
        int depth = 0;
        for (index = 0; index < size; ++index) {
            char c = text.charAt(index);
            if (Character.isWhitespace(c)) continue;
            if (c != '-') break;
            ++depth;
        }
        if (index != 0) {
            text = text.substring(index);
        }
        return new ItemImpl(text, depth);
    }

    @Override
    public List<Document.Item> getItems() {
        return this.items;
    }

    public String toString() {
        return "Document{items=" + this.items + '}';
    }

    private static class ItemImpl
    implements Document.Item {
        private final String text;
        private final int depth;

        private ItemImpl(String text, int depth) {
            this.text = text;
            this.depth = depth;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        public String toString() {
            return "DocumentItem{text='" + this.text + '\'' + ", depth='" + this.depth + '\'' + '}';
        }
    }
}

