/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.OperationImpl;
import org.babyfish.jimmer.impl.asm.Type;
import org.jetbrains.annotations.Nullable;

class ServiceImpl
implements Service {
    private final Class<?> rawType;
    private final String uri;
    private final Operation.HttpMethod defaultMethod;
    private final Document document;
    List<Operation> operations;

    ServiceImpl(Class<?> rawType, String uri, Operation.HttpMethod defaultMethod) {
        this.rawType = rawType;
        this.document = DocumentImpl.of(rawType);
        this.uri = uri;
        this.defaultMethod = defaultMethod;
    }

    @Override
    public Class<?> getJavaType() {
        return this.rawType;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Operation.HttpMethod getDefaultMethod() {
        return this.defaultMethod;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitingService(this);
        for (Operation operation : this.operations) {
            operation.accept(visitor);
        }
        visitor.visitedService(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("interface ").append(this.rawType.getSimpleName()).append("{\n");
        for (Operation operation : this.operations) {
            builder.append('\t').append(operation).append('\n');
        }
        builder.append("}");
        return builder.toString();
    }

    public static Service create(Context ctx, Class<?> serviceType, String uri, Operation.HttpMethod defaultMethod) {
        ServiceImpl service = new ServiceImpl(serviceType, uri, defaultMethod);
        ArrayList<Operation> list = new ArrayList<Operation>();
        for (Method method : serviceType.getMethods()) {
            Operation operation = OperationImpl.create(ctx, service, method);
            if (operation == null) continue;
            list.add(operation);
        }
        list.sort(Comparator.comparing(Operation::getName).thenComparing(it -> Type.getMethodDescriptor((Method)it.getRawMethod())));
        service.operations = Collections.unmodifiableList(list);
        return service;
    }
}

