/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.regex.Pattern;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.JetBrainsMetadata;
import org.babyfish.jimmer.client.meta.impl.Location;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.Nullable;

class ParameterImpl
implements Parameter {
    private static final Pattern UNNAMED_PATTERN = Pattern.compile("arg\\d+");
    private final Operation declaringOperation;
    private final java.lang.reflect.Parameter rawParameter;
    private final int originalIndex;
    private final String requestParam;
    private final String pathVariable;
    private final boolean body;
    private final Type type;
    private final Document document;
    private final String name;

    ParameterImpl(Operation declaringOperation, java.lang.reflect.Parameter rawParameter, String parameterName, int originalIndex, String requestParam, String pathVariable, boolean body, Type type) {
        this.declaringOperation = declaringOperation;
        this.rawParameter = rawParameter;
        this.originalIndex = originalIndex;
        this.requestParam = requestParam;
        this.pathVariable = pathVariable;
        this.body = body;
        this.type = type;
        this.document = DocumentImpl.of(rawParameter);
        this.name = this.requestParam != null ? this.requestParam : (this.pathVariable != null ? this.pathVariable : (this.body ? "body" : (parameterName != null ? parameterName : rawParameter.getName())));
    }

    @Override
    public Operation getDeclaringOperation() {
        return this.declaringOperation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getOriginalIndex() {
        return this.originalIndex;
    }

    @Override
    public String getRequestParam() {
        return this.requestParam;
    }

    @Override
    public String getPathVariable() {
        return this.pathVariable;
    }

    @Override
    public boolean isRequestBody() {
        return this.body;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitParameter(this);
        this.type.accept(visitor);
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    @Nullable
    static Parameter create(Context ctx, Operation declaringOperation, java.lang.reflect.Parameter rawParameter, String parameterName, int index) {
        Tuple2<String, Boolean> tuple;
        String requestParam;
        Metadata.ParameterParser parameterParser = ctx.getParameterParser();
        JetBrainsMetadata jetBrainsMetadata = ctx.getJetBrainsMetadata(declaringOperation.getRawMethod().getDeclaringClass());
        boolean isNullable = jetBrainsMetadata.isNullable(declaringOperation.getRawMethod(), index);
        if (parameterName == null) {
            parameterName = rawParameter.getName();
        }
        String string = requestParam = (tuple = parameterParser.requestParamNameAndNullable(rawParameter)) != null ? (String)tuple.get_1() : null;
        if (requestParam != null) {
            if (requestParam.isEmpty()) {
                requestParam = parameterName;
            }
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            if (isNullable) {
                type = NullableTypeImpl.of(type);
            }
            if (((Boolean)tuple.get_2()).booleanValue()) {
                type = NullableTypeImpl.of(type);
            }
            return new ParameterImpl(declaringOperation, rawParameter, parameterName, index, requestParam, null, false, type);
        }
        String pathVariable = parameterParser.pathVariableName(rawParameter);
        if (pathVariable != null) {
            if (pathVariable.isEmpty()) {
                pathVariable = parameterName;
            }
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            return new ParameterImpl(declaringOperation, rawParameter, parameterName, index, null, pathVariable, false, type);
        }
        if (parameterParser.isRequestBody(rawParameter)) {
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            if (isNullable) {
                type = NullableTypeImpl.of(type);
            }
            return new ParameterImpl(declaringOperation, rawParameter, parameterName, index, null, null, true, type);
        }
        if (!parameterParser.shouldBeIgnored(rawParameter)) {
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            if (isNullable) {
                type = NullableTypeImpl.of(type);
            }
            return new ParameterImpl(declaringOperation, rawParameter, parameterName, index, null, null, false, type);
        }
        return null;
    }

    private static class ParameterLocation
    implements Location {
        private final Operation declaringOperation;
        private final int index;
        private final String name;

        private ParameterLocation(Operation declaringOperation, int index, String name) {
            this.declaringOperation = declaringOperation;
            this.index = index;
            this.name = name;
        }

        @Override
        public boolean isQueryResult() {
            return false;
        }

        @Override
        public Class<?> getDeclaringType() {
            return this.declaringOperation.getDeclaringService().getJavaType();
        }

        public String toString() {
            return "The parameter(index = " + this.index + ", name = " + this.name + ") of \"" + this.declaringOperation.getRawMethod() + "\"";
        }
    }
}

