/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.impl.MetadataBuilder;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.Nullable;

public interface Metadata {
    public Map<Class<?>, Service> getServices();

    public Map<Class<?>, StaticObjectType> getGenericTypes();

    public Map<StaticObjectType.Key, StaticObjectType> getStaticTypes();

    public Map<Class<?>, EnumType> getEnumTypes();

    public Map<Fetcher<?>, ImmutableObjectType> getFetchedImmutableObjectTypes();

    public Map<ImmutableType, ImmutableObjectType> getViewImmutableObjectTypes();

    public Map<ImmutableType, ImmutableObjectType> getRawImmutableObjectTypes();

    public static Builder newBuilder() {
        return new MetadataBuilder();
    }

    public static interface ParameterParser {
        @Nullable
        public Tuple2<String, Boolean> requestParamNameAndNullable(Parameter var1);

        @Nullable
        public String pathVariableName(Parameter var1);

        public boolean isRequestBody(Parameter var1);

        public boolean shouldBeIgnored(Parameter var1);
    }

    public static interface OperationParser {
        public Tuple2<String, Operation.HttpMethod> http(AnnotatedElement var1);

        default public String[] getParameterNames(Method method) {
            return null;
        }
    }

    public static interface Builder {
        default public Builder addService(Object service) {
            return this.addServices(Collections.singleton(service));
        }

        default public Builder addServices(Object ... services) {
            return this.addServices(Arrays.asList(services));
        }

        default public Builder addServices(Collection<Object> services) {
            return this.addServiceTypes(services.stream().filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toList()));
        }

        default public Builder addServiceType(Class<?> serviceType) {
            return this.addServiceTypes(Collections.singleton(serviceType));
        }

        default public Builder addServiceTypes(Class<?> ... serviceTypes) {
            return this.addServiceTypes(Arrays.asList(serviceTypes));
        }

        public Builder addServiceTypes(Collection<Class<?>> var1);

        public Builder setOperationParser(OperationParser var1);

        public Builder setParameterParser(ParameterParser var1);

        public Metadata build();
    }
}

