/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.impl.asm.AnnotationVisitor;
import org.babyfish.jimmer.impl.asm.ClassReader;
import org.babyfish.jimmer.impl.asm.ClassVisitor;
import org.babyfish.jimmer.impl.asm.FieldVisitor;
import org.babyfish.jimmer.impl.asm.MethodVisitor;
import org.babyfish.jimmer.impl.asm.Type;

class JetBrainsMetadata {
    private static final Set<Class<?>> BOX_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class));
    private final Class<?> javaClass;
    private final KClass<?> kotlinClass;
    private final Map<AccessibleObject, KCallable<?>> kCallableMap;
    private Nullity nullity;

    JetBrainsMetadata(Class<?> javaClass) {
        this.javaClass = javaClass;
        if (javaClass.isAnnotationPresent(Metadata.class)) {
            this.kotlinClass = JvmClassMappingKt.getKotlinClass(javaClass);
            HashMap callableMap = new HashMap();
            for (KProperty1 prop : KClasses.getDeclaredMemberProperties(this.kotlinClass)) {
                Method getter;
                Field field = ReflectJvmMapping.getJavaField((KProperty)prop);
                if (field != null) {
                    callableMap.put(field, (KCallable<?>)prop);
                }
                if ((getter = ReflectJvmMapping.getJavaGetter((KProperty)prop)) != null) {
                    callableMap.put(getter, (KCallable<?>)prop);
                }
                if (!(prop instanceof KMutableProperty)) continue;
                Method setter = ReflectJvmMapping.getJavaSetter((KMutableProperty)((KMutableProperty)prop));
                if (getter == null) continue;
                callableMap.put(setter, (KCallable<?>)prop);
            }
            for (KFunction func : KClasses.getDeclaredFunctions(this.kotlinClass)) {
                Method method = ReflectJvmMapping.getJavaMethod((KFunction)func);
                callableMap.put(method, (KCallable<?>)func);
            }
            this.kCallableMap = callableMap;
        } else {
            this.kotlinClass = null;
            this.kCallableMap = null;
        }
    }

    public boolean isKotlinClass() {
        return this.kotlinClass != null;
    }

    public KFunction<?> toKFunction(Method method) {
        if (this.kCallableMap == null) {
            throw new IllegalStateException("The current class \"" + this.javaClass.getName() + "\" is not kotlin class");
        }
        return (KFunction)this.kCallableMap.get(method);
    }

    private Nullity getNullity() {
        Nullity nty = this.nullity;
        if (nty == null) {
            if (this.kotlinClass != null) {
                throw new IllegalStateException("It is unnecessary to create nullity for kotlin class");
            }
            this.nullity = nty = new Nullity(this.javaClass);
        }
        return nty;
    }

    public boolean isNullable(Field field) {
        return this.isNullable(field, field.getType());
    }

    public boolean isNullable(Method method) {
        return this.isNullable((AccessibleObject)method, method.getReturnType());
    }

    private boolean isNullable(AccessibleObject member, Class<?> type) {
        if (this.kCallableMap != null) {
            KCallable<?> callable = this.kCallableMap.get(member);
            return callable != null && callable.getReturnType().isMarkedNullable();
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (BOX_TYPES.contains(type)) {
            return true;
        }
        for (Annotation annotation : member.getAnnotations()) {
            String simpleName = annotation.annotationType().getSimpleName();
            if (!simpleName.equals("Null") && !simpleName.equals("Nullable")) continue;
            return true;
        }
        return this.getNullity().nullableMembers.contains(member);
    }

    public boolean isNullable(Method method, int parameterIndex) {
        KCallable<?> callable;
        if (this.kCallableMap != null && (callable = this.kCallableMap.get(method)) != null) {
            int baseIndex = callable.getParameters().size() - method.getParameters().length;
            return ((KParameter)callable.getParameters().get(baseIndex + parameterIndex)).getType().isMarkedNullable();
        }
        Set<Integer> indices = this.getNullity().nullableParameterIndices.get(method);
        return indices != null && indices.contains(parameterIndex);
    }

    private static class Nullity {
        final Set<AccessibleObject> nullableMembers = new HashSet<AccessibleObject>();
        final Map<AccessibleObject, Set<Integer>> nullableParameterIndices = new HashMap<AccessibleObject, Set<Integer>>();

        Nullity(Class<?> clazz) {
            if (clazz.isPrimitive() || BOX_TYPES.contains(clazz)) {
                return;
            }
            final HashMap<Member, AccessibleObject> accessibleObjectMap = new HashMap<Member, AccessibleObject>();
            for (Field field : clazz.getDeclaredFields()) {
                accessibleObjectMap.put(new Member(field.getName(), Type.getDescriptor(field.getType())), field);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                accessibleObjectMap.put(new Member(((Method)accessibleObject).getName(), Type.getMethodDescriptor((Method)accessibleObject)), accessibleObject);
            }
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                try (InputStream inputStream = loader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class");){
                    ClassReader reader = new ClassReader(inputStream);
                    reader.accept(new ClassVisitor(589824, null){

                        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                            if ((access & 8) != 0) {
                                return null;
                            }
                            AccessibleObject field = (AccessibleObject)accessibleObjectMap.get(new Member(name, descriptor));
                            if (field == null) {
                                return null;
                            }
                            return new FieldVisitorImpl(field);
                        }

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            if ((access & 8) != 0) {
                                return null;
                            }
                            AccessibleObject method = (AccessibleObject)accessibleObjectMap.get(new Member(name, descriptor));
                            if (method == null) {
                                return null;
                            }
                            return new MethodVisitorImpl(method);
                        }
                    }, 7);
                }
                catch (IOException ex) {
                    throw new IllegalDocMetaException("Failed to parse the jetbrains nullity for class \"" + clazz.getName() + "\"", ex);
                }
            }
        }

        private class MethodVisitorImpl
        extends MethodVisitor {
            private final AccessibleObject method;

            protected MethodVisitorImpl(AccessibleObject method) {
                super(589824);
                this.method = method;
            }

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (descriptor.endsWith("/Nullable;")) {
                    Nullity.this.nullableMembers.add(this.method);
                }
                return null;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                if (descriptor.endsWith("/Nullable;")) {
                    Nullity.this.nullableParameterIndices.computeIfAbsent(this.method, it -> new HashSet()).add(parameter);
                }
                return null;
            }
        }

        private class FieldVisitorImpl
        extends FieldVisitor {
            private final AccessibleObject field;

            protected FieldVisitorImpl(AccessibleObject field) {
                super(589824);
                this.field = field;
            }

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (descriptor.endsWith("/Nullable;")) {
                    Nullity.this.nullableMembers.add(this.field);
                }
                return null;
            }
        }
    }

    private static class Member {
        final String name;
        final String descriptor;

        public Member(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Member member = (Member)o;
            return this.name.equals(member.name) && this.descriptor.equals(member.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }

        public String toString() {
            return this.name + ':' + this.descriptor;
        }
    }
}

