/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.MetadataImpl;
import org.babyfish.jimmer.client.meta.impl.ServiceImpl;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;

public class MetadataBuilder
implements Metadata.Builder {
    private final Set<Class<?>> serviceTypes = new HashSet();
    private Metadata.OperationParser operationParser;
    private Metadata.ParameterParser parameterParser;

    @Override
    public Metadata.Builder addServiceTypes(Collection<Class<?>> serviceTypes) {
        for (Class<?> serviceType : serviceTypes) {
            if (serviceType == null) continue;
            this.serviceTypes.add(serviceType);
        }
        return this;
    }

    @Override
    public Metadata.Builder setOperationParser(Metadata.OperationParser operationParser) {
        this.operationParser = operationParser;
        return this;
    }

    @Override
    public Metadata.Builder setParameterParser(Metadata.ParameterParser parameterParser) {
        this.parameterParser = parameterParser;
        return this;
    }

    @Override
    public Metadata build() {
        if (this.operationParser == null) {
            throw new IllegalStateException("operationParser has not been set");
        }
        if (this.parameterParser == null) {
            throw new IllegalStateException("parameterParser has not been set");
        }
        Context ctx = new Context(this.operationParser, this.parameterParser);
        LinkedHashMap serviceMap = new LinkedHashMap();
        for (Class<?> serviceType : this.serviceTypes) {
            Tuple2<String, Operation.HttpMethod> tuple = this.operationParser.http(serviceType);
            String uri = null;
            Operation.HttpMethod defaultMethod = Operation.HttpMethod.GET;
            if (tuple != null) {
                if (!((String)tuple.get_1()).isEmpty()) {
                    uri = (String)tuple.get_1();
                }
                if (tuple.get_2() != null) {
                    defaultMethod = (Operation.HttpMethod)((Object)tuple.get_2());
                }
            }
            Service service = ServiceImpl.create(ctx, serviceType, uri, defaultMethod);
            serviceMap.put(serviceType, service);
        }
        return new MetadataImpl(serviceMap, ctx.getGenericTypes(), ctx.staticObjectTypeMap, ctx.enumTypeMap, ctx.fetchedImmutableObjectTypeMap, ctx.viewImmutableObjectTypeMap, ctx.rawImmutableObjectTypeMap);
    }
}

