/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.Visitor;
import org.jetbrains.annotations.Nullable;

class SimpleTypeImpl
implements SimpleType {
    private static final Map<Class<?>, SimpleType> SIMPLE_TYPE_MAP;
    private final Class<?> javaType;

    @Nullable
    public static SimpleType get(Class<?> rawType) {
        return SIMPLE_TYPE_MAP.get(rawType);
    }

    private SimpleTypeImpl(Class<?> javaType) {
        this.javaType = javaType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.isTypeVisitable(this)) {
            visitor.visitSimpleType(this);
        }
    }

    public String toString() {
        return this.javaType.getSimpleName();
    }

    static {
        Class[] arr = new Class[]{Void.TYPE, Object.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class, String.class, UUID.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetDateTime.class, ZonedDateTime.class};
        HashMap map = new HashMap((arr.length * 4 + 2) / 3);
        for (Class clazz : arr) {
            map.put(clazz, new SimpleTypeImpl(clazz));
        }
        SIMPLE_TYPE_MAP = map;
    }
}

