/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.ts.TsCodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsContext;
import org.babyfish.jimmer.client.meta.EnumBasedError;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.impl.util.StringUtil;

public class ModuleErrorsWriter
extends TsCodeWriter {
    private final Map<String, Set<EnumBasedError>> errorMap;

    public ModuleErrorsWriter(TsContext ctx) {
        super(ctx, ctx.getModuleErrorsFile());
        TreeMap<String, Set> errorMap = new TreeMap<String, Set>();
        for (Service service : ctx.getServiceFileMap().keySet()) {
            for (Operation operation : service.getOperations()) {
                for (EnumBasedError error : operation.getErrors()) {
                    String family = CodeBasedException.familyName((String)error.getRawError().getClass().getSimpleName());
                    errorMap.computeIfAbsent(family, f -> new TreeSet<EnumBasedError>(Comparator.comparing(it -> it.getRawError().name()))).add(error);
                }
            }
        }
        this.errorMap = Collections.unmodifiableMap(errorMap);
    }

    @Override
    protected void write() {
        this.writeAllErrors();
        this.writeModuleErrors();
    }

    private void writeAllErrors() {
        if (this.errorMap.isEmpty()) {
            this.code("export type AllErrors = {}");
        } else {
            this.code("export type AllErrors = ");
            this.scope(CodeWriter.ScopeType.BLANK, " | ", true, () -> {
                for (Map.Entry<String, Set<EnumBasedError>> e : this.errorMap.entrySet()) {
                    for (EnumBasedError error : e.getValue()) {
                        this.separator();
                        this.writeError(error);
                    }
                }
            });
        }
        this.code(";\n");
    }

    private void writeError(EnumBasedError error) {
        this.scope(CodeWriter.ScopeType.OBJECT, ",", true, () -> {
            this.separator();
            this.code("readonly family: \"").code(StringUtil.snake((String)error.getRawError().getClass().getSimpleName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)).code('\"');
            this.separator();
            this.code("readonly code: \"").code(error.getRawError().name()).code('\"');
            for (EnumBasedError.Field field : error.getFields().values()) {
                this.separator();
                this.writeField(field);
            }
        });
    }

    private void writeField(EnumBasedError.Field field) {
        this.code("readonly \"").code(field.getName()).code('\"');
        if (field.getType() instanceof NullableType) {
            this.code('?');
        }
        this.code(": ");
        this.typeRef(field.getType());
    }

    private void writeModuleErrors() {
        this.code("\nexport type ").code(((TsContext)this.ctx).getModuleFile().getName()).code("Errors = ");
        this.scope(CodeWriter.ScopeType.OBJECT, ",", true, () -> {
            for (Map.Entry<Service, File> e : ((TsContext)this.ctx).getServiceFileMap().entrySet()) {
                this.separator();
                this.code('\"').code(ModuleErrorsWriter.toFieldName(e.getValue().getName())).code("\": ");
                this.scope(CodeWriter.ScopeType.OBJECT, ",", true, () -> {
                    for (Operation operation : ((Service)e.getKey()).getOperations()) {
                        if (operation.getErrors().isEmpty()) continue;
                        this.separator();
                        this.code('\"').code(((TsContext)this.ctx).getOperationName(operation)).code("\": AllErrors & ");
                        this.scope(CodeWriter.ScopeType.ARGUMENTS, " | ", true, () -> {
                            for (EnumBasedError error : operation.getErrors()) {
                                this.separator();
                                this.scope(CodeWriter.ScopeType.OBJECT, ",", true, () -> {
                                    this.code("readonly family: ").code('\'').code(StringUtil.snake((String)error.getRawError().getClass().getSimpleName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)).code('\'');
                                    this.separator();
                                    this.code("readonly code: ").code('\'').code(error.getRawError().name()).code('\'');
                                    this.separator();
                                    this.code("readonly [key:string]: any");
                                });
                            }
                        });
                    }
                });
            }
        });
        this.code(";\n");
    }

    private static String toFieldName(String serviceName) {
        char[] chs = serviceName.toCharArray();
        for (int i = 0; i < chs.length && Character.isUpperCase(chs[i]); ++i) {
            chs[i] = Character.toLowerCase(chs[i]);
        }
        return new String(chs);
    }
}

