/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.meta.EnumBasedError;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.error.ErrorFamily;
import org.babyfish.jimmer.error.ErrorField;
import org.babyfish.jimmer.error.ErrorFields;
import org.babyfish.jimmer.impl.util.StaticCache;

public class Throws {
    private static StaticCache<Class<?>, Method> ANNOTATION_VALUE_METHOD_CACHE = new StaticCache(Throws::parseAnnotationValueMethod, true);
    private final Context ctx;

    public Throws(Context ctx) {
        this.ctx = ctx;
    }

    public List<EnumBasedError> getErrors(Method operationMethod) {
        ArrayList<EnumBasedError> errors = new ArrayList<EnumBasedError>();
        for (Annotation annotation : operationMethod.getAnnotations()) {
            Object[] arr;
            Method valueMethod = (Method)ANNOTATION_VALUE_METHOD_CACHE.get(annotation.annotationType());
            if (valueMethod == null) continue;
            try {
                arr = (Object[])valueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError("Internal bug, can not get error code from \"" + valueMethod + "\"", ex);
            }
            catch (InvocationTargetException ex) {
                throw new AssertionError("Internal bug, can not get error code from \"" + valueMethod + "\"", ex.getTargetException());
            }
            for (Object o : arr) {
                errors.add(this.parseError((Enum)o));
            }
        }
        return errors;
    }

    private static Method parseAnnotationValueMethod(Class<?> annotationType) {
        Method valueMethod;
        try {
            valueMethod = annotationType.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (!valueMethod.getReturnType().isArray()) {
            return null;
        }
        Class<?> errorType = valueMethod.getReturnType().getComponentType();
        if (!errorType.isEnum() || !errorType.isAnnotationPresent(ErrorFamily.class)) {
            return null;
        }
        return valueMethod;
    }

    private EnumBasedError parseError(Enum<?> error) {
        Field constantField;
        LinkedHashMap<String, EnumBasedError.Field> fieldMap = new LinkedHashMap<String, EnumBasedError.Field>();
        try {
            constantField = error.getClass().getField(error.name());
        }
        catch (NoSuchFieldException ex) {
            throw new AssertionError((Object)("Cannot get field of \"" + error.name() + "\" from \"" + error.getClass() + "\""));
        }
        ErrorFields fields = constantField.getAnnotation(ErrorFields.class);
        if (fields != null) {
            for (ErrorField field : fields.value()) {
                if (fieldMap.put(field.name(), this.parseErrorField(error, field)) == null) continue;
                throw new IllegalArgumentException("Duplicated field name \"" + field.name() + "\" is declared on \"" + error.getClass().getName() + "." + error.name() + "\"");
            }
        } else {
            ErrorField field = constantField.getAnnotation(ErrorField.class);
            if (field != null) {
                fieldMap.put(field.name(), this.parseErrorField(error, field));
            }
        }
        return new EnumBasedError(error, fieldMap);
    }

    private EnumBasedError.Field parseErrorField(Enum<?> error, ErrorField field) {
        Type type;
        try {
            type = this.ctx.parseErrorFieldType(field.type());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalDocMetaException("Cannot parse the field \"" + field.name() + "\" of \"" + error.getClass().getName() + "." + error.name() + "\". " + ex.getMessage());
        }
        return new EnumBasedError.Field(field.name(), type);
    }
}

