/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.lang.reflect.TypeVariable;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsCodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsContext;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;

public class TypeDefinitionWriter
extends TsCodeWriter {
    private final Type type;

    public TypeDefinitionWriter(TsContext ctx, Type type) {
        super(ctx, ctx.getFile(type));
        if (!type.hasDefinition()) {
            throw new IllegalArgumentException("The type does not have definition");
        }
        this.type = type;
    }

    @Override
    protected void write() {
        if (this.type instanceof ObjectType) {
            this.document(((ObjectType)this.type).getDocument());
            this.writeObjectType((ObjectType)this.type, "");
        } else {
            this.writeEnumType();
        }
    }

    private void writeObjectType(ObjectType objectType, String prefix) {
        StaticObjectType staticObjectType;
        TypeVariable[] typeParameters;
        String simpleName = prefix + objectType.getJavaType().getSimpleName();
        this.code("export interface ").code(simpleName);
        if (objectType instanceof StaticObjectType && (typeParameters = (staticObjectType = (StaticObjectType)objectType).getJavaType().getTypeParameters()).length != 0 && staticObjectType.getTypeArguments().isEmpty()) {
            this.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (TypeVariable typeVariable : typeParameters) {
                    this.separator();
                    this.code(typeVariable.getName());
                }
            });
        }
        this.code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : objectType.getProperties().values()) {
                this.separator();
                this.code('\n');
                this.document(property.getDocument());
                this.code("readonly ").code(property.getName()).codeIf(property.getType() instanceof NullableType, "?").code(": ");
                this.typeRef(NullableType.unwrap(property.getType()));
                this.code(';');
            }
        });
        this.code("\n");
        if (objectType instanceof StaticObjectType) {
            staticObjectType = (StaticObjectType)objectType;
            String newPrefix = simpleName + ((TsContext)this.ctx).nestedTypeSeparator();
            for (StaticObjectType nestedObjectType : staticObjectType.getNestedTypes()) {
                this.code("\n");
                this.writeObjectType(nestedObjectType, newPrefix);
            }
        }
    }

    private void writeEnumType() {
        EnumType enumType = (EnumType)this.type;
        this.code("export type ").code(this.getFile().getName()).code(" = ");
        this.scope(CodeWriter.ScopeType.BLANK, " | ", enumType.getItems().size() > 3, () -> {
            for (String item : enumType.getItems()) {
                this.separator();
                this.code('\'').code(item).code('\'');
            }
        });
        this.code(";\n");
    }
}

