/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import org.babyfish.jimmer.client.FetchBy;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.FetchByInfo;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.impl.ArrayTypeImpl;
import org.babyfish.jimmer.client.meta.impl.EnumTypeImpl;
import org.babyfish.jimmer.client.meta.impl.ImmutableObjectTypeImpl;
import org.babyfish.jimmer.client.meta.impl.JetBrainsMetadata;
import org.babyfish.jimmer.client.meta.impl.Location;
import org.babyfish.jimmer.client.meta.impl.MapTypeImpl;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.meta.impl.SimpleTypeImpl;
import org.babyfish.jimmer.client.meta.impl.StaticObjectTypeImpl;
import org.babyfish.jimmer.client.meta.impl.UnresolvedTypeVariableImpl;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.fetcher.Fetcher;

class Context {
    private final Context base;
    private final Metadata.OperationParser operationParser;
    private final Metadata.ParameterParser parameterParser;
    private final Map<Class<?>, JetBrainsMetadata> jetBrainsMetadataMap;
    private final Location location;
    final Map<StaticObjectType.Key, StaticObjectType> staticObjectTypeMap;
    final Map<Class<?>, EnumType> enumTypeMap;
    final Map<Fetcher<?>, ImmutableObjectType> fetchedImmutableObjectTypeMap;
    final Map<ImmutableType, ImmutableObjectType> rawImmutableObjectTypeMap;
    final Map<ImmutableType, ImmutableObjectType> viewImmutableObjectTypeMap;
    private final Map<FetchByInfo, Fetcher<?>> fetcherMap;
    private final Map<UnifiedTypeParameter, Object> typeVariableMap;
    private final boolean ignoreTypeVariableResolving;

    Context(Metadata.OperationParser operationParser, Metadata.ParameterParser parameterParser) {
        this.base = null;
        this.operationParser = operationParser;
        this.parameterParser = parameterParser;
        this.jetBrainsMetadataMap = new HashMap();
        this.location = null;
        this.staticObjectTypeMap = new LinkedHashMap<StaticObjectType.Key, StaticObjectType>();
        this.enumTypeMap = new LinkedHashMap();
        this.rawImmutableObjectTypeMap = new LinkedHashMap<ImmutableType, ImmutableObjectType>();
        this.viewImmutableObjectTypeMap = new LinkedHashMap<ImmutableType, ImmutableObjectType>();
        this.fetchedImmutableObjectTypeMap = new LinkedHashMap();
        this.fetcherMap = new HashMap();
        this.typeVariableMap = Collections.emptyMap();
        this.ignoreTypeVariableResolving = false;
    }

    private Context(Context base, Location location) {
        this.base = base;
        this.operationParser = base.operationParser;
        this.parameterParser = base.parameterParser;
        this.jetBrainsMetadataMap = base.jetBrainsMetadataMap;
        this.location = location;
        this.staticObjectTypeMap = base.staticObjectTypeMap;
        this.enumTypeMap = base.enumTypeMap;
        this.fetchedImmutableObjectTypeMap = base.fetchedImmutableObjectTypeMap;
        this.rawImmutableObjectTypeMap = base.rawImmutableObjectTypeMap;
        this.viewImmutableObjectTypeMap = base.viewImmutableObjectTypeMap;
        this.fetcherMap = base.fetcherMap;
        this.typeVariableMap = Collections.emptyMap();
        this.ignoreTypeVariableResolving = base.ignoreTypeVariableResolving;
    }

    public Context(Context base, AnnotatedParameterizedType parameterizedType) {
        this.base = base;
        this.operationParser = base.operationParser;
        this.parameterParser = base.parameterParser;
        this.jetBrainsMetadataMap = base.jetBrainsMetadataMap;
        this.location = base.location;
        this.staticObjectTypeMap = base.staticObjectTypeMap;
        this.enumTypeMap = base.enumTypeMap;
        this.fetchedImmutableObjectTypeMap = base.fetchedImmutableObjectTypeMap;
        this.rawImmutableObjectTypeMap = base.rawImmutableObjectTypeMap;
        this.viewImmutableObjectTypeMap = base.viewImmutableObjectTypeMap;
        this.fetcherMap = base.fetcherMap;
        TypeVariable<Class<T>>[] typeVariables = ((Class)((ParameterizedType)parameterizedType.getType()).getRawType()).getTypeParameters();
        AnnotatedType[] actualTypes = parameterizedType.getAnnotatedActualTypeArguments();
        HashMap<UnifiedTypeParameter, Object> map = new HashMap<UnifiedTypeParameter, Object>();
        for (int i = typeVariables.length - 1; i >= 0; --i) {
            map.put(new UnifiedTypeParameter(typeVariables[i]), actualTypes[i]);
        }
        this.typeVariableMap = map;
        this.ignoreTypeVariableResolving = base.ignoreTypeVariableResolving;
    }

    public Context(Context base, KType parameterizedType) {
        if (parameterizedType.getArguments().isEmpty()) {
            throw new IllegalArgumentException("parameterizedType must have type arguments");
        }
        this.base = base;
        this.operationParser = base.operationParser;
        this.parameterParser = base.parameterParser;
        this.jetBrainsMetadataMap = base.jetBrainsMetadataMap;
        this.location = base.location;
        this.staticObjectTypeMap = base.staticObjectTypeMap;
        this.enumTypeMap = base.enumTypeMap;
        this.fetchedImmutableObjectTypeMap = base.fetchedImmutableObjectTypeMap;
        this.rawImmutableObjectTypeMap = base.rawImmutableObjectTypeMap;
        this.viewImmutableObjectTypeMap = base.viewImmutableObjectTypeMap;
        this.fetcherMap = base.fetcherMap;
        List typeParameters = ((KClass)parameterizedType.getClassifier()).getTypeParameters();
        List projections = parameterizedType.getArguments();
        HashMap<UnifiedTypeParameter, Object> map = new HashMap<UnifiedTypeParameter, Object>();
        for (int i = typeParameters.size() - 1; i >= 0; --i) {
            map.put(new UnifiedTypeParameter((KTypeParameter)typeParameters.get(i)), UnifiedTypeParameter.wrap(((KTypeProjection)projections.get(i)).getType()));
        }
        this.typeVariableMap = map;
        this.ignoreTypeVariableResolving = base.ignoreTypeVariableResolving;
    }

    private Context(Context base, boolean ignoreTypeVariableResolving) {
        this.base = base;
        this.operationParser = base.operationParser;
        this.parameterParser = base.parameterParser;
        this.jetBrainsMetadataMap = base.jetBrainsMetadataMap;
        this.location = base.location;
        this.staticObjectTypeMap = base.staticObjectTypeMap;
        this.enumTypeMap = base.enumTypeMap;
        this.fetchedImmutableObjectTypeMap = base.fetchedImmutableObjectTypeMap;
        this.rawImmutableObjectTypeMap = base.rawImmutableObjectTypeMap;
        this.viewImmutableObjectTypeMap = base.viewImmutableObjectTypeMap;
        this.fetcherMap = base.fetcherMap;
        this.typeVariableMap = base.typeVariableMap;
        this.ignoreTypeVariableResolving = ignoreTypeVariableResolving;
    }

    public Context locate(Location location) {
        return new Context(this, location);
    }

    public Location getLocation() {
        return this.location;
    }

    public Metadata.OperationParser getOperationParser() {
        return this.operationParser;
    }

    public Metadata.ParameterParser getParameterParser() {
        return this.parameterParser;
    }

    public JetBrainsMetadata getJetBrainsMetadata(Class<?> type) {
        return this.jetBrainsMetadataMap.computeIfAbsent(type, t -> new JetBrainsMetadata(type));
    }

    public Type parseType(AnnotatedType annotatedType) {
        java.lang.reflect.Type javaType = annotatedType.getType();
        FetchBy fetchBy = annotatedType.getAnnotation(FetchBy.class);
        ImmutableType immutableType = null;
        if (javaType instanceof Class) {
            immutableType = ImmutableType.tryGet((Class)((Class)javaType));
        }
        if (!(fetchBy == null || immutableType != null && immutableType.isEntity())) {
            throw new IllegalDocMetaException("Illegal type \"" + annotatedType + "\" declared in " + this.location + ", @" + FetchBy.class.getName() + " can only used to decorate entity type");
        }
        if (javaType instanceof Class) {
            Class javaClass = (Class)javaType;
            if (immutableType != null) {
                Type type = this.objectType(immutableType, fetchBy);
                if (fetchBy != null && fetchBy.nullable()) {
                    type = NullableTypeImpl.of(type);
                }
                return type;
            }
            if (javaClass.isEnum()) {
                EnumType enumType = this.enumTypeMap.get(javaClass);
                if (enumType == null) {
                    enumType = new EnumTypeImpl(javaClass);
                    this.enumTypeMap.put(javaClass, enumType);
                }
                return enumType;
            }
            SimpleType simpleType = SimpleTypeImpl.get(javaClass);
            if (simpleType != null) {
                return simpleType;
            }
            if (Collection.class.isAssignableFrom(javaClass) || Map.class.isAssignableFrom(javaClass)) {
                throw new IllegalDocMetaException("Illegal type \"" + annotatedType + "\" declared in " + this.location + ", collection and map must be parameterized type");
            }
            if (!this.ignoreTypeVariableResolving && javaClass.getTypeParameters().length != 0) {
                throw new IllegalDocMetaException("Illegal type \"" + annotatedType + "\" declared in " + this.location + ", generic type must be parameterized type");
            }
            return this.objectType(javaClass, null);
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            return this.parseType(((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds()[0]);
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            return new ArrayTypeImpl(this.parseType(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType()));
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            if (this.ignoreTypeVariableResolving) {
                return new UnresolvedTypeVariableImpl(((TypeVariable)annotatedType.getType()).getName());
            }
            TypeVariable typeVariable = (TypeVariable)annotatedType.getType();
            Object resolvedType = this.resolve(new UnifiedTypeParameter(typeVariable));
            if (resolvedType instanceof KType) {
                return this.parseKotlinType((KType)resolvedType);
            }
            return this.parseType((AnnotatedType)resolvedType);
        }
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
            ParameterizedType parameterizedType = (ParameterizedType)annotatedParameterizedType.getType();
            java.lang.reflect.Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalDocMetaException("Illegal type \"" + annotatedType + "\" declared in " + this.location + ", the parameterized whose raw type is not class is not supported");
            }
            Class rawClass = (Class)rawType;
            if (Collection.class.isAssignableFrom(rawClass)) {
                return new ArrayTypeImpl(this.parseType(annotatedParameterizedType.getAnnotatedActualTypeArguments()[0]));
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                return new MapTypeImpl(this.parseType(annotatedParameterizedType.getAnnotatedActualTypeArguments()[0]), this.parseType(annotatedParameterizedType.getAnnotatedActualTypeArguments()[1]));
            }
            return new Context(this, annotatedParameterizedType).objectType(rawClass, Arrays.stream(annotatedParameterizedType.getAnnotatedActualTypeArguments()).map(this::parseType).collect(Collectors.toList()));
        }
        throw new AssertionError((Object)("Internal bug: unexpected annotated type " + annotatedType));
    }

    public Map<Class<?>, StaticObjectType> getGenericTypes() {
        Set classes = this.staticObjectTypeMap.values().stream().filter(it -> !it.getTypeArguments().isEmpty()).map(ObjectType::getJavaType).collect(Collectors.toSet());
        HashMap map = new HashMap((classes.size() * 4 + 2) / 3);
        Context tmpContext = new Context(this, true);
        for (Class clazz : classes) {
            map.put(clazz, tmpContext.objectType(clazz, null));
        }
        return map;
    }

    private Object resolve(UnifiedTypeParameter typeParameter) {
        Object resolvedType = this.typeVariableMap.get(typeParameter);
        if (resolvedType != null) {
            Object wrappedResolvedType = UnifiedTypeParameter.wrap(resolvedType);
            if (!(wrappedResolvedType instanceof UnifiedTypeParameter)) {
                return resolvedType;
            }
            typeParameter = (UnifiedTypeParameter)wrappedResolvedType;
        }
        if (this.base != null) {
            return this.base.resolve(typeParameter);
        }
        throw new IllegalDocMetaException("Cannot resolve " + typeParameter + " of " + this.location);
    }

    public Type parseKotlinType(KType type) {
        Type parsed = this.parseKotlinType0(type);
        if (type.isMarkedNullable()) {
            return NullableTypeImpl.of(parsed);
        }
        return parsed;
    }

    public Type parseKotlinType0(KType type) {
        FetchBy fetchBy = null;
        for (Annotation ann : type.getAnnotations()) {
            if (!(ann instanceof FetchBy)) continue;
            fetchBy = (FetchBy)ann;
            break;
        }
        KClass kotlinClass = null;
        Class javaClass = null;
        ImmutableType immutableType = null;
        if (type.getClassifier() instanceof KClass) {
            kotlinClass = (KClass)type.getClassifier();
            javaClass = JvmClassMappingKt.getJavaClass((KClass)kotlinClass);
            immutableType = ImmutableType.tryGet((Class)javaClass);
        }
        if (!(fetchBy == null || immutableType != null && immutableType.isEntity())) {
            throw new IllegalDocMetaException("Illegal type \"" + type + "\" declared in " + this.location + ", @" + FetchBy.class.getName() + " can only used to decorate entity type");
        }
        if (javaClass != null && type.getArguments().isEmpty()) {
            if (immutableType != null) {
                return this.objectType(immutableType, fetchBy);
            }
            if (javaClass.isEnum()) {
                EnumType enumType = this.enumTypeMap.get(javaClass);
                if (enumType == null) {
                    enumType = new EnumTypeImpl(javaClass);
                    this.enumTypeMap.put(javaClass, enumType);
                }
                return enumType;
            }
            SimpleType simpleType = SimpleTypeImpl.get(javaClass);
            if (simpleType != null) {
                return simpleType;
            }
            if (Collection.class.isAssignableFrom(javaClass) || Map.class.isAssignableFrom(javaClass)) {
                throw new IllegalDocMetaException("Illegal type \"" + type + "\" declared in " + this.location + ", collection and map must be parameterized type");
            }
            if (!this.ignoreTypeVariableResolving && javaClass.getTypeParameters().length != 0) {
                throw new IllegalDocMetaException("Illegal type \"" + type + "\" declared in " + this.location + ", generic type must be parameterized type");
            }
            return this.objectType(kotlinClass, null);
        }
        if (javaClass != null && !type.getArguments().isEmpty()) {
            ArrayList<KType> argumentTypes = new ArrayList<KType>();
            for (KTypeProjection projection : type.getArguments()) {
                KType argumentType = projection.getType();
                if (argumentType == null) {
                    throw new IllegalDocMetaException("Illegal type \"" + type + "\" declared in " + this.location + ", generic type argument cannot be star");
                }
                argumentTypes.add(argumentType);
            }
            if (Collection.class.isAssignableFrom(javaClass)) {
                return new ArrayTypeImpl(this.parseKotlinType((KType)argumentTypes.get(0)));
            }
            if (Map.class.isAssignableFrom(javaClass)) {
                return new MapTypeImpl(this.parseKotlinType((KType)argumentTypes.get(0)), this.parseKotlinType((KType)argumentTypes.get(1)));
            }
            return new Context(this, type).objectType(kotlinClass, argumentTypes.stream().map(this::parseKotlinType).collect(Collectors.toList()));
        }
        if (type.getClassifier() instanceof KTypeParameter) {
            if (this.ignoreTypeVariableResolving) {
                return new UnresolvedTypeVariableImpl(((KTypeParameter)type.getClassifier()).getName());
            }
            Object resolved = this.resolve(new UnifiedTypeParameter((KTypeParameter)type.getClassifier()));
            if (resolved instanceof KType) {
                return this.parseKotlinType((KType)resolved);
            }
            return this.parseType((AnnotatedType)resolved);
        }
        throw new AssertionError((Object)("Internal bug: unexpected kotlin type " + type));
    }

    private ImmutableObjectType objectType(ImmutableType type, FetchBy fetchBy) {
        if (fetchBy != null) {
            Class<Object> ownerType;
            try {
                ownerType = fetchBy.ownerType();
            }
            catch (KotlinReflectionInternalError ex) {
                ownerType = Void.TYPE;
            }
            FetchByInfo info = new FetchByInfo(ownerType != Void.TYPE ? ownerType : this.location.getDeclaringType(), fetchBy.value());
            Fetcher<?> fetcher = this.fetcherOf(info);
            return ImmutableObjectTypeImpl.fetch(this, type, fetcher, info);
        }
        if (this.location.isQueryResult() && type.isEntity()) {
            return ImmutableObjectTypeImpl.view(this, type);
        }
        return ImmutableObjectTypeImpl.raw(this, type);
    }

    private StaticObjectType objectType(Class<?> type, List<Type> typeArguments) {
        if (type.isAnnotationPresent(Metadata.class)) {
            return this.objectType(JvmClassMappingKt.getKotlinClass(type), typeArguments);
        }
        StaticObjectType staticType = this.staticObjectTypeMap.get(new StaticObjectType.Key(type, typeArguments));
        if (staticType == null) {
            staticType = StaticObjectTypeImpl.create(this, type, typeArguments);
        }
        return staticType;
    }

    private StaticObjectType objectType(KClass<?> type, List<Type> typeArguments) {
        StaticObjectType staticType = this.staticObjectTypeMap.get(new StaticObjectType.Key(JvmClassMappingKt.getJavaClass(type), typeArguments));
        if (staticType == null) {
            staticType = StaticObjectTypeImpl.create(this, type, typeArguments);
        }
        return staticType;
    }

    private Fetcher<?> fetcherOf(FetchByInfo info) {
        Fetcher<?> fetcher = this.fetcherMap.get(info);
        if (fetcher == null && !this.fetcherMap.containsKey(info)) {
            Ref<Fetcher<?>> fetcherRef = this.staticFetcherOf(info, info.getOwnerType().isAnnotationPresent(Metadata.class));
            fetcher = fetcherRef != null ? (Fetcher<?>)fetcherRef.getValue() : this.companionFetcherOf(info);
            this.fetcherMap.put(info, fetcher);
        }
        return fetcher;
    }

    private Ref<Fetcher<?>> staticFetcherOf(FetchByInfo info, boolean allowReturnNull) {
        Field field;
        try {
            field = info.getOwnerType().getDeclaredField(info.getConstant());
        }
        catch (NoSuchFieldException ex) {
            if (allowReturnNull) {
                return null;
            }
            throw new IllegalDocMetaException("Illegal annotation @" + FetchBy.class.getName() + " in " + this.location + ", there is no field \"" + info.getConstant() + "\" in the type \"" + info.getOwnerType().getName() + "\"");
        }
        if (!(Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && Fetcher.class.isAssignableFrom(field.getType()))) {
            if (allowReturnNull) {
                return null;
            }
            throw new IllegalDocMetaException("Illegal annotation @" + FetchBy.class.getName() + " in " + this.location + ", the field \"" + field + "\" must be static and final and must return fetcher");
        }
        field.setAccessible(true);
        try {
            return Ref.of((Object)((Fetcher)field.get(null)));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalDocMetaException("Cannot get `" + info.getConstant() + "` from \"" + info.getOwnerType().getName() + "\"");
        }
    }

    private Fetcher<?> companionFetcherOf(FetchByInfo info) {
        Field companionField;
        try {
            companionField = info.getOwnerType().getDeclaredField("Companion");
        }
        catch (NoSuchFieldException ex) {
            companionField = null;
        }
        Object companion = null;
        Field field = null;
        if (companionField != null) {
            companionField.setAccessible(true);
            try {
                companion = companionField.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (companion != null) {
                try {
                    field = companionField.getType().getDeclaredField(info.getConstant());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (field == null) {
            throw new IllegalDocMetaException("Illegal annotation @" + FetchBy.class.getName() + " in " + this.location + ", no static of companion fetcher \"" + info.getConstant() + "\"");
        }
        if (!Fetcher.class.isAssignableFrom(field.getType())) {
            throw new IllegalDocMetaException("Illegal annotation @" + FetchBy.class.getName() + " in " + this.location + ", the field \"" + field + "\" must return fetcher");
        }
        field.setAccessible(true);
        try {
            return (Fetcher)field.get(companion);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalDocMetaException("Cannot get `" + info.getConstant() + "` from \"" + info.getOwnerType().getName() + "\"");
        }
    }

    ImmutableObjectType getImmutableObjectType(ImmutableObjectType.Category category, ImmutableType type, Fetcher<?> fetcher) {
        switch (category) {
            case FETCH: {
                return this.fetchedImmutableObjectTypeMap.get(fetcher);
            }
            case VIEW: {
                return this.viewImmutableObjectTypeMap.get(type);
            }
            case RAW: {
                return this.rawImmutableObjectTypeMap.get(type);
            }
        }
        return null;
    }

    StaticObjectType getStaticObjectType(Class<?> rawType, List<Type> typeArguments) {
        return this.staticObjectTypeMap.get(new StaticObjectType.Key(rawType, typeArguments));
    }

    void addStaticObjectType(StaticObjectTypeImpl impl) {
        this.staticObjectTypeMap.put(new StaticObjectType.Key(impl.getJavaType(), impl.getTypeArguments()), impl);
    }

    void addImmutableObjectType(ImmutableObjectTypeImpl impl) {
        switch (impl.getCategory()) {
            case FETCH: {
                this.fetchedImmutableObjectTypeMap.put(impl.getFetcher(), impl);
                break;
            }
            case VIEW: {
                this.viewImmutableObjectTypeMap.put(impl.getImmutableType(), impl);
                break;
            }
            case RAW: {
                this.rawImmutableObjectTypeMap.put(impl.getImmutableType(), impl);
            }
        }
    }

    private static class UnifiedTypeParameter {
        private final String name;

        UnifiedTypeParameter(TypeVariable<?> typeVariable) {
            this.name = typeVariable.getName();
        }

        UnifiedTypeParameter(KTypeParameter typeParameter) {
            this.name = typeParameter.getName();
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnifiedTypeParameter that = (UnifiedTypeParameter)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return '<' + this.name + '>';
        }

        public static Object wrap(Object o) {
            if (o instanceof AnnotatedTypeVariable) {
                TypeVariable typeVariable = (TypeVariable)((AnnotatedTypeVariable)o).getType();
                return new UnifiedTypeParameter(typeVariable);
            }
            if (o instanceof TypeVariable) {
                return new UnifiedTypeParameter((TypeVariable)o);
            }
            if (o instanceof KTypeParameter) {
                return new UnifiedTypeParameter((KTypeParameter)o);
            }
            return o;
        }
    }
}

