/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.generator.ts.DtoWriter;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.MapType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.impl.util.Classes;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeWriter<C extends JavaContext>
extends CodeWriter<C> {
    private static final Set<String> PRIMITIVE_TYPE_NAMES;
    private final Set<String> importedPaths = new TreeSet<String>();
    private Property currentDtoProp;

    protected JavaCodeWriter(C ctx, File file) {
        super(ctx, file);
    }

    @Override
    public void onImport(File file, boolean treatAsData) {
        if (!file.getDir().equals(this.file.getDir())) {
            StringBuilder builder = new StringBuilder();
            if (!((JavaContext)this.ctx).getBasePackage().isEmpty()) {
                builder.append(((JavaContext)this.ctx).getBasePackage());
                builder.append('.');
            }
            builder.append(file.toString().replace('/', '.'));
            this.importedPaths.add(builder.toString());
        }
    }

    @Override
    protected void writePackageHeader(Writer writer) throws IOException {
        writer.write("package ");
        writer.write(((JavaContext)this.getContext()).getBasePackage());
        if (!((JavaContext)this.ctx).getBasePackage().isEmpty() && !this.file.getDir().isEmpty()) {
            writer.write(46);
        }
        if (!this.file.getDir().isEmpty()) {
            writer.write(this.file.getDir().replace('/', '.'));
        }
        writer.write(";\n");
    }

    @Override
    protected void writeImportHeader(Writer writer) throws IOException {
        if (!this.importedPaths.isEmpty()) {
            writer.write(10);
            for (String typeName : this.importedPaths) {
                writer.write("import ");
                writer.write(typeName);
                writer.write(";\n");
            }
        }
    }

    protected final void importType(String typeName) {
        int lastDotIndex;
        if (!(PRIMITIVE_TYPE_NAMES.contains(typeName) || (lastDotIndex = typeName.lastIndexOf(46)) != -1 && typeName.substring(0, lastDotIndex).equals("java.lang"))) {
            this.importedPaths.add(typeName);
        }
    }

    protected final void importType(Class<?> type) {
        this.importType(type.getName());
    }

    @Override
    protected void writeSimpleTypeRef(SimpleType simpleType) {
        Class<?> javaType = simpleType.getJavaType();
        this.code(javaType.getSimpleName());
        this.importType(javaType);
    }

    @Override
    protected void writeNullableTypeRef(NullableType nullableType) {
        this.typeRef(nullableType.getTargetType());
    }

    @Override
    protected void writeArrayTypeRef(ArrayType arrayType) {
        this.code("List<").typeRef(arrayType.getElementType()).code('>');
        this.importType(List.class);
    }

    @Override
    protected void writeMapTypeRef(MapType mapType) {
        this.code("Map<").typeRef(mapType.getKeyType()).code(", ").typeRef(mapType.getValueType()).code('>');
        this.importType(Map.class);
    }

    @Override
    protected void writeDynamicTypeRef(ImmutableObjectType type) {
        this.code("Dynamic_").code(((JavaContext)this.getContext()).getFile(type).getName());
    }

    @Override
    protected void writeDtoTypeRef(ImmutableObjectType type) {
        String tempDtoTypeName = this.tempDtoTypeName();
        if (tempDtoTypeName != null) {
            this.code(tempDtoTypeName);
        } else {
            this.importFile(DtoWriter.dtoFile(this.getContext(), type.getJavaType()));
            this.code(((JavaContext)this.getContext()).getDtoPrefix(type.getJavaType())).code('.').code(((JavaContext)this.getContext()).getDtoSuffix(type).replace('/', '_'));
        }
    }

    protected JavaCodeWriter<C> typeRef(String typeName) {
        int lastDotIndex = typeName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            this.code(typeName);
        } else {
            this.code(typeName.substring(lastDotIndex + 1));
        }
        this.importType(typeName);
        return this;
    }

    protected final void writeField(Property prop) {
        this.writeField(prop, false);
    }

    protected final void writeField(Property prop, boolean forceNullable) {
        this.code('\n');
        this.document(prop.getDocument());
        if (forceNullable || prop.getType() instanceof NullableType) {
            this.code("@Nullable\n");
            this.importType(Nullable.class);
        }
        this.code("private ");
        this.writePropType(prop, forceNullable);
        this.code(' ').code(prop.getName()).code(";\n");
    }

    protected final void writeProperty(Property prop) {
        this.writeProperty(prop, false);
    }

    protected final void writeProperty(Property prop, boolean forceNullable) {
        if (forceNullable || prop.getType() instanceof NullableType) {
            this.code("\n@Nullable");
            this.importType(Nullable.class);
        }
        this.code("\npublic ");
        this.writePropType(prop, forceNullable);
        this.code(' ').code(JavaCodeWriter.getterName(prop)).code("() ");
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.code("return ").code(prop.getName()).code(";\n"));
        this.code('\n');
        this.code("\npublic void ");
        this.code(JavaCodeWriter.setterName(prop)).code('(').codeIf(forceNullable || prop.getType() instanceof NullableType, "@Nullable ");
        this.writePropType(prop, forceNullable);
        this.code(' ').code(prop.getName()).code(") ");
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.code("this.").code(prop.getName()).code(" = ").code(prop.getName()).code(";\n"));
        this.code('\n');
    }

    private void writePropType(Property prop, boolean forceNullable) {
        Class<?> javaType;
        Type type = prop.getType();
        if (forceNullable && type instanceof SimpleType && (javaType = ((SimpleType)type).getJavaType()).isPrimitive()) {
            this.code(Classes.boxTypeOf(javaType).getSimpleName());
            return;
        }
        this.typeRef(prop.getType());
    }

    private static String getterName(Property property) {
        boolean isBoolean;
        String name = property.getName();
        boolean bl = isBoolean = property.getType() instanceof SimpleType && ((SimpleType)property.getType()).getJavaType() == Boolean.TYPE;
        if (isBoolean && name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            return name;
        }
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return isBoolean ? "is" + name : "get" + name;
    }

    private static String setterName(Property property) {
        boolean isBoolean;
        String name = property.getName();
        boolean bl = isBoolean = property.getType() instanceof SimpleType && ((SimpleType)property.getType()).getJavaType() == Boolean.TYPE;
        if (isBoolean && name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            name = name.substring(2);
        }
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return "set" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDtoProp(Property prop, Runnable handler) {
        Property oldProp = this.currentDtoProp;
        this.currentDtoProp = prop;
        try {
            handler.run();
        }
        finally {
            this.currentDtoProp = oldProp;
        }
    }

    protected String tempDtoTypeName() {
        if (this.currentDtoProp == null) {
            return null;
        }
        return "TargetOf_" + this.currentDtoProp.getName();
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(Boolean.TYPE.getSimpleName());
        set.add(Character.TYPE.getSimpleName());
        set.add(Byte.TYPE.getSimpleName());
        set.add(Short.TYPE.getSimpleName());
        set.add(Integer.TYPE.getSimpleName());
        set.add(Long.TYPE.getSimpleName());
        set.add(Float.TYPE.getSimpleName());
        set.add(Double.TYPE.getSimpleName());
        PRIMITIVE_TYPE_NAMES = set;
    }
}

