/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.babyfish.jimmer.client.generator.Generator;
import org.babyfish.jimmer.client.generator.GeneratorException;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.generator.ts.DtoWriter;
import org.babyfish.jimmer.client.generator.ts.File;
import org.babyfish.jimmer.client.generator.ts.ModuleWriter;
import org.babyfish.jimmer.client.generator.ts.ServiceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeDefinitionWriter;
import org.babyfish.jimmer.client.generator.ts.simple.DynamicWriter;
import org.babyfish.jimmer.client.generator.ts.simple.ExecutorWriter;
import org.babyfish.jimmer.client.generator.ts.simple.RequestOfWriter;
import org.babyfish.jimmer.client.generator.ts.simple.ResponseOfWriter;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Node;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.Type;

public class TypeScriptGenerator
implements Generator {
    private final String moduleName;
    private final int indent;
    private final boolean anonymous;

    public TypeScriptGenerator() {
        this.moduleName = "Api";
        this.indent = 4;
        this.anonymous = false;
    }

    public TypeScriptGenerator(String moduleName) {
        this.moduleName = moduleName;
        this.indent = 4;
        this.anonymous = false;
    }

    public TypeScriptGenerator(String moduleName, int indent) {
        this.moduleName = moduleName;
        this.indent = indent;
        this.anonymous = false;
    }

    public TypeScriptGenerator(String moduleName, int indent, boolean anonymous) {
        this.moduleName = moduleName;
        this.indent = indent;
        this.anonymous = anonymous;
    }

    @Override
    public void generate(Metadata metadata, OutputStream out) {
        try {
            ZipOutputStream zipOut = new ZipOutputStream(out);
            this.generate0(new Context(metadata, zipOut, this.moduleName, this.indent), zipOut);
            zipOut.finish();
        }
        catch (IOException | Error | RuntimeException ex) {
            throw new GeneratorException(ex);
        }
    }

    private void generate0(Context ctx, ZipOutputStream zipOut) throws IOException {
        File file;
        zipOut.putNextEntry(new ZipEntry(ctx.getModuleFile().toString()));
        new ModuleWriter(ctx).flush();
        zipOut.closeEntry();
        zipOut.putNextEntry(new ZipEntry(ExecutorWriter.FILE.toString()));
        new ExecutorWriter(ctx).flush();
        zipOut.closeEntry();
        zipOut.putNextEntry(new ZipEntry(DynamicWriter.FILE.toString()));
        new DynamicWriter(ctx).flush();
        zipOut.closeEntry();
        zipOut.putNextEntry(new ZipEntry(RequestOfWriter.FILE.toString()));
        new RequestOfWriter(ctx).flush();
        zipOut.closeEntry();
        zipOut.putNextEntry(new ZipEntry(ResponseOfWriter.FILE.toString()));
        new ResponseOfWriter(ctx).flush();
        zipOut.closeEntry();
        HashMap<String, Index> indexMap = new HashMap<String, Index>();
        for (Map.Entry<Service, File> entry : ctx.getServiceFileMap().entrySet()) {
            Service service = entry.getKey();
            file = entry.getValue();
            indexMap.computeIfAbsent(file.getDir(), Index::new).addObjectFile(file);
            zipOut.putNextEntry(new ZipEntry(file.toString()));
            new ServiceWriter(ctx, service, this.anonymous).flush();
            zipOut.closeEntry();
        }
        for (Map.Entry<Node, File> entry : ctx.getTypeFilePairs()) {
            Type type = (Type)entry.getKey();
            file = entry.getValue();
            indexMap.computeIfAbsent(file.getDir(), Index::new).addTypeFile(file);
            zipOut.putNextEntry(new ZipEntry(file.toString()));
            new TypeDefinitionWriter(ctx, type).flush();
            zipOut.closeEntry();
        }
        if (!this.anonymous) {
            for (Map.Entry<Object, Object> entry : ctx.getDtoMap().entrySet()) {
                Class rawType = (Class)entry.getKey();
                DtoWriter dtoWriter = new DtoWriter(ctx, rawType, (List)entry.getValue());
                indexMap.computeIfAbsent(dtoWriter.getFile().getDir(), Index::new).addTypeFile(dtoWriter.getFile());
                zipOut.putNextEntry(new ZipEntry(dtoWriter.getFile().toString()));
                dtoWriter.flush();
                zipOut.closeEntry();
            }
        }
        indexMap.computeIfAbsent("", Index::new).addObjectFile(ctx.getModuleFile()).addTypeFile(ExecutorWriter.FILE).addTypeFile(DynamicWriter.FILE).addTypeFile(RequestOfWriter.FILE).addTypeFile(ResponseOfWriter.FILE);
        for (Index index : indexMap.values()) {
            this.writeIndex(ctx, index, zipOut);
        }
    }

    private void writeIndex(Context ctx, Index index, ZipOutputStream zipOut) throws IOException {
        zipOut.putNextEntry(new ZipEntry(index.dir + "/index.ts"));
        OutputStreamWriter writer = new OutputStreamWriter(zipOut);
        for (File file : index.objectFiles) {
            writer.write("export { " + file.getName() + " } from './" + file.getName() + "';\n");
            if (this.anonymous || file == ctx.getModuleFile()) continue;
            writer.write("export type { " + file.getName() + "Options } from './" + file.getName() + "';\n");
        }
        for (File file : index.typeFiles) {
            writer.write("export type { " + file.getName() + " } from './" + file.getName() + "';\n");
        }
        writer.flush();
        zipOut.closeEntry();
    }

    private static class Index {
        final String dir;
        final List<File> objectFiles = new ArrayList<File>();
        final List<File> typeFiles = new ArrayList<File>();

        public Index(String dir) {
            this.dir = dir;
        }

        public Index addObjectFile(File file) {
            this.objectFiles.add(file);
            return this;
        }

        public Index addTypeFile(File file) {
            this.typeFiles.add(file);
            return this;
        }
    }
}

