/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.lang.reflect.TypeVariable;
import org.babyfish.jimmer.client.generator.ts.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;

public class TypeDefinitionWriter
extends CodeWriter {
    private final Type type;

    public TypeDefinitionWriter(Context ctx, Type type) {
        super(ctx, ctx.getFile(type));
        if (!type.hasDefinition()) {
            throw new IllegalArgumentException("The type does not have definition");
        }
        this.type = type;
    }

    @Override
    protected void write() {
        if (this.type instanceof ObjectType) {
            this.document(((ObjectType)this.type).getDocument());
            this.writeObjectType();
        } else {
            this.writeEnumType();
        }
    }

    private void writeObjectType() {
        StaticObjectType staticObjectType;
        TypeVariable[] typeParameters;
        ObjectType objectType = (ObjectType)this.type;
        this.code("export interface ").code(this.getFile().getName());
        if (objectType instanceof StaticObjectType && (typeParameters = (staticObjectType = (StaticObjectType)objectType).getJavaType().getTypeParameters()).length != 0 && staticObjectType.getTypeArguments().isEmpty()) {
            this.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (TypeVariable typeVariable : typeParameters) {
                    this.separator();
                    this.code(typeVariable.getName());
                }
            });
        }
        this.code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : objectType.getProperties().values()) {
                this.separator();
                this.code('\n');
                this.document(property.getDocument());
                this.code("readonly ").code(property.getName()).codeIf(property.getType() instanceof NullableType, "?").code(": ");
                this.type(NullableType.unwrap(property.getType()));
                this.code(';');
            }
        });
    }

    private void writeEnumType() {
        EnumType enumType = (EnumType)this.type;
        this.code("export type ").code(this.getFile().getName()).code(" = ");
        this.scope(CodeWriter.ScopeType.BLANK, " | ", enumType.getItems().size() > 3, () -> {
            for (String item : enumType.getItems()) {
                this.separator();
                this.code('\'').code(item).code('\'');
            }
        });
        this.code(";\n");
    }
}

