/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.List;
import org.babyfish.jimmer.client.generator.ts.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.generator.ts.File;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;

public class DtoWriter
extends CodeWriter {
    private final List<ImmutableObjectType> immutableObjectTypes;

    public DtoWriter(Context ctx, Class<?> rawType, List<ImmutableObjectType> immutableObjectTypes) {
        super(ctx, DtoWriter.dtoFile(ctx, rawType));
        this.immutableObjectTypes = immutableObjectTypes;
    }

    public static File dtoFile(Context ctx, Class<?> rawType) {
        return new File("model/dto", ctx.getDtoPrefix(rawType));
    }

    @Override
    protected void write() {
        this.code("export type ").code(this.getFile().getName()).code(" = ");
        this.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (ImmutableObjectType type : this.immutableObjectTypes) {
                this.separator();
                this.code('\'').code(this.getContext().getDtoSuffix(type)).code("': ");
                this.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                    for (Property prop : type.getProperties().values()) {
                        this.separator();
                        this.code("readonly ").code(prop.getName()).codeIf(prop.getType() instanceof NullableType, '?').code(": ").type(NullableType.unwrap(prop.getType()));
                    }
                });
            }
        });
    }
}

