/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.regex.Pattern;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.JetBrainsMetadata;
import org.babyfish.jimmer.client.meta.impl.Location;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.Nullable;

class ParameterImpl
implements Parameter {
    private static final Pattern UNNAMED_PATTERN = Pattern.compile("arg\\d+");
    private final Operation declaringOperation;
    private final java.lang.reflect.Parameter rawParameter;
    private final int originalIndex;
    private final String requestParam;
    private final String pathVariable;
    private final Type type;
    private final Document document;
    private String name;

    ParameterImpl(Operation declaringOperation, java.lang.reflect.Parameter rawParameter, int originalIndex, String requestParam, String pathVariable, Type type) {
        this.declaringOperation = declaringOperation;
        this.rawParameter = rawParameter;
        this.originalIndex = originalIndex;
        this.requestParam = requestParam;
        this.pathVariable = pathVariable;
        this.type = type;
        this.document = DocumentImpl.of(rawParameter);
    }

    @Override
    public Operation getDeclaringOperation() {
        return this.declaringOperation;
    }

    @Override
    public String getName() {
        String name = this.name;
        if (name == null) {
            if (this.requestParam != null) {
                name = this.requestParam;
            } else if (this.pathVariable != null) {
                name = this.pathVariable;
            } else {
                name = this.rawParameter.getName();
                if (UNNAMED_PATTERN.matcher(name).matches()) {
                    boolean bodyIsConflict = false;
                    for (Parameter otherParameter : this.declaringOperation.getParameters()) {
                        if (otherParameter == this || !otherParameter.getName().equals("body")) continue;
                        bodyIsConflict = true;
                        break;
                    }
                    if (!bodyIsConflict) {
                        name = "body";
                    }
                }
            }
            this.name = name;
        }
        return name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getOriginalIndex() {
        return this.originalIndex;
    }

    @Override
    public String getRequestParam() {
        return this.requestParam;
    }

    @Override
    public String getPathVariable() {
        return this.pathVariable;
    }

    @Override
    public boolean isRequestBody() {
        return this.requestParam == null && this.pathVariable == null;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitParameter(this);
        this.type.accept(visitor);
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    @Nullable
    static Parameter create(Context ctx, Operation declaringOperation, java.lang.reflect.Parameter rawParameter, int index) {
        String requestParam;
        Metadata.ParameterParser parameterParser = ctx.getParameterParser();
        JetBrainsMetadata jetBrainsMetadata = ctx.getJetBrainsMetadata(declaringOperation.getRawMethod().getDeclaringClass());
        boolean isNullable = jetBrainsMetadata.isNullable(declaringOperation.getRawMethod(), index);
        Tuple2<String, Boolean> tuple = parameterParser.requestParamNameAndNullable(rawParameter);
        String string = requestParam = tuple != null ? (String)tuple.get_1() : null;
        if (requestParam != null) {
            if (requestParam.isEmpty()) {
                requestParam = rawParameter.getName();
            }
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            if (isNullable) {
                type = NullableTypeImpl.of(type);
            }
            if (((Boolean)tuple.get_2()).booleanValue()) {
                type = NullableTypeImpl.of(type);
            }
            return new ParameterImpl(declaringOperation, rawParameter, index, requestParam, null, type);
        }
        String pathVariable = parameterParser.pathVariableName(rawParameter);
        if (pathVariable != null) {
            if (pathVariable.isEmpty()) {
                pathVariable = rawParameter.getName();
            }
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            return new ParameterImpl(declaringOperation, rawParameter, index, null, pathVariable, type);
        }
        if (parameterParser.isRequestBody(rawParameter)) {
            Type type = ctx.locate(new ParameterLocation(declaringOperation, index, rawParameter.getName())).parseType(rawParameter.getAnnotatedType());
            if (isNullable) {
                type = NullableTypeImpl.of(type);
            }
            return new ParameterImpl(declaringOperation, rawParameter, index, null, null, type);
        }
        return null;
    }

    private static class ParameterLocation
    implements Location {
        private final Operation declaringOperation;
        private final int index;
        private final String name;

        private ParameterLocation(Operation declaringOperation, int index, String name) {
            this.declaringOperation = declaringOperation;
            this.index = index;
            this.name = name;
        }

        @Override
        public boolean isQueryResult() {
            return false;
        }

        @Override
        public Class<?> getDeclaringType() {
            return this.declaringOperation.getDeclaringService().getJavaType();
        }

        public String toString() {
            return "The parameter(index = " + this.index + ", name = " + this.name + ") of \"" + this.declaringOperation.getRawMethod() + "\"";
        }
    }
}

