/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java;

import java.lang.reflect.TypeVariable;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.java.JavaCodeWriter;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;

public class TypeDefinitionWriter
extends JavaCodeWriter<JavaContext> {
    private final Type type;

    public TypeDefinitionWriter(JavaContext ctx, Type type) {
        super(ctx, ctx.getFile(type));
        if (!type.hasDefinition()) {
            throw new IllegalArgumentException("The type does not have definition");
        }
        this.type = type;
    }

    @Override
    protected void write() {
        if (this.type instanceof ObjectType) {
            this.document(((ObjectType)this.type).getDocument());
            this.writeObjectType();
        } else {
            this.writeEnumType();
        }
    }

    private void writeObjectType() {
        StaticObjectType staticObjectType;
        TypeVariable[] typeParameters;
        ObjectType objectType = (ObjectType)this.type;
        this.code("\npublic class ").code(this.getFile().getName());
        if (objectType instanceof StaticObjectType && (typeParameters = (staticObjectType = (StaticObjectType)objectType).getJavaType().getTypeParameters()).length != 0 && staticObjectType.getTypeArguments().isEmpty()) {
            this.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (TypeVariable typeVariable : typeParameters) {
                    this.separator();
                    this.code(typeVariable.getName());
                }
            });
        }
        this.code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property prop : objectType.getProperties().values()) {
                this.writeField(prop, objectType instanceof ImmutableObjectType);
            }
            for (Property prop : objectType.getProperties().values()) {
                this.writeProperty(prop, objectType instanceof ImmutableObjectType);
            }
        });
        this.code('\n');
    }

    private void writeEnumType() {
        EnumType enumType = (EnumType)this.type;
        this.code("\npublic enum ").code(this.getFile().getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (String item : enumType.getItems()) {
                this.separator();
                this.code(item);
            }
        });
        this.code("\n");
    }
}

