/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.MapType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.UnresolvedTypeVariable;

public abstract class CodeWriter<C extends Context> {
    protected final C ctx;
    protected final File file;
    private final StringBuilder codeBuilder = new StringBuilder();
    private int indent;
    private boolean lineDirty;
    private Scope scope;

    protected CodeWriter(C ctx, File file) {
        this.ctx = ctx;
        this.file = file;
    }

    public final C getContext() {
        return this.ctx;
    }

    public final File getFile() {
        return this.file;
    }

    public final CodeWriter<C> codeIf(boolean cond, String ts) {
        if (cond) {
            return this.code(ts);
        }
        return this;
    }

    public final CodeWriter<C> codeIf(boolean cond, char c) {
        if (cond) {
            return this.code(c);
        }
        return this;
    }

    public final CodeWriter<C> code(String ts) {
        if (ts.isEmpty()) {
            return this;
        }
        int size = ts.length();
        for (int i = 0; i < size; ++i) {
            this.doAdd(ts.charAt(i));
        }
        return this;
    }

    public final CodeWriter<C> code(char c) {
        this.doAdd(c);
        return this;
    }

    public final CodeWriter<C> importFile(File file) {
        return this.importFile(file, false);
    }

    public final CodeWriter<C> importFile(File file, boolean treatAsData) {
        if (file != null && !file.equals(this.file)) {
            this.onImport(file, treatAsData);
        }
        return this;
    }

    protected abstract void onImport(File var1, boolean var2);

    public final CodeWriter<C> typeRef(Type type) {
        if (type instanceof UnresolvedTypeVariable) {
            this.code(((UnresolvedTypeVariable)type).getName());
        } else if (type instanceof SimpleType) {
            this.writeSimpleTypeRef((SimpleType)type);
        } else if (type instanceof NullableType) {
            this.writeNullableTypeRef((NullableType)type);
        } else if (type instanceof ArrayType) {
            this.writeArrayTypeRef((ArrayType)type);
        } else if (type instanceof MapType) {
            this.writeMapTypeRef((MapType)type);
        } else {
            File file = ((Context)this.ctx).getFile(type);
            if (file != null) {
                this.importFile(file);
                if (type instanceof ImmutableObjectType && this.rawImmutableAsDynamic() && ((ImmutableObjectType)type).getCategory() == ImmutableObjectType.Category.RAW) {
                    this.writeDynamicTypeRef((ImmutableObjectType)type);
                } else if (type instanceof StaticObjectType) {
                    this.writeStaticTypeRef((StaticObjectType)type);
                } else {
                    this.code(file.getName());
                }
            } else if (type instanceof ImmutableObjectType) {
                this.writeDtoTypeRef((ImmutableObjectType)type);
            }
        }
        return this;
    }

    public CodeWriter<C> separator() {
        Scope scope = this.scope;
        if (scope == null) {
            throw new IllegalStateException("There is no existing scope");
        }
        if (scope.dirty) {
            this.code(scope.separator);
            if (scope.multiLines) {
                this.code('\n');
            }
        }
        return this;
    }

    public CodeWriter<C> document(Document document) {
        if (document == null) {
            return null;
        }
        boolean visitedFirstLine = false;
        this.code("/**\n");
        for (Document.Item item : document.getItems()) {
            this.code(" * ");
            if (item.getDepth() != 0) {
                for (int i = item.getDepth(); i > 1; --i) {
                    this.code(((Context)this.ctx).getIndent());
                }
                this.code('-').code(((Context)this.ctx).getIndent().substring(1));
            } else if (visitedFirstLine) {
                this.code("\n * ");
            }
            this.code(item.getText());
            this.code('\n');
            visitedFirstLine = true;
        }
        this.code(" */\n");
        return this;
    }

    private void doAdd(char c) {
        if (!this.lineDirty) {
            for (int i = this.indent; i > 0; --i) {
                this.codeBuilder.append(((Context)this.ctx).getIndent());
            }
            this.lineDirty = true;
        }
        if (this.scope != null) {
            this.scope.dirty();
        }
        this.codeBuilder.append(c);
        if (c == '\n') {
            this.lineDirty = false;
        }
    }

    public CodeWriter<C> scope(ScopeType type, String separator, boolean multiLines, Runnable runnable) {
        Scope oldScope = this.scope;
        Scope newScope = new Scope(oldScope, separator, multiLines);
        this.code(type.prefix);
        if (multiLines) {
            this.code('\n');
            ++this.indent;
        }
        this.scope = newScope;
        runnable.run();
        if (multiLines) {
            --this.indent;
            if (this.lineDirty) {
                this.code('\n');
            }
        }
        this.code(type.suffix);
        this.scope = oldScope;
        return this;
    }

    protected abstract void write();

    public final void flush() throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(((Context)this.ctx).getOutputStream());
        this.write();
        this.writePackageHeader(writer);
        this.writeImportHeader(writer);
        writer.write(this.codeBuilder.toString());
        writer.flush();
    }

    protected void writePackageHeader(Writer writer) throws IOException {
    }

    protected abstract void writeImportHeader(Writer var1) throws IOException;

    protected boolean rawImmutableAsDynamic() {
        return false;
    }

    protected abstract void writeSimpleTypeRef(SimpleType var1);

    protected abstract void writeNullableTypeRef(NullableType var1);

    protected abstract void writeArrayTypeRef(ArrayType var1);

    protected abstract void writeMapTypeRef(MapType var1);

    protected abstract void writeDynamicTypeRef(ImmutableObjectType var1);

    protected void writeStaticTypeRef(StaticObjectType type) {
        this.code(((Context)this.getContext()).getFile(type).getName());
        List<Type> typeArguments = type.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            this.scope(ScopeType.GENERIC, ", ", false, () -> {
                for (Type typeArgument : typeArguments) {
                    this.separator();
                    this.typeRef(typeArgument);
                }
            });
        }
    }

    protected abstract void writeDtoTypeRef(ImmutableObjectType var1);

    private static class Scope {
        private final Scope parent;
        final String separator;
        final boolean multiLines;
        boolean dirty;

        Scope(Scope parent, String separator, boolean multiLines) {
            this.parent = parent;
            this.separator = separator;
            this.multiLines = multiLines;
        }

        void dirty() {
            if (!this.dirty) {
                this.dirty = true;
                if (this.parent != null) {
                    this.parent.dirty();
                }
            }
        }
    }

    public static enum ScopeType {
        OBJECT("{", "}"),
        LIST("[", "]"),
        ARGUMENTS("(", ")"),
        GENERIC("<", ">"),
        BLANK("", "");

        final String prefix;
        final String suffix;

        private ScopeType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }
}

