/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.generator.ts.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.generator.ts.ExecutorWriter;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Service;

public class ServiceWriter
extends CodeWriter {
    private final Service service;

    public ServiceWriter(Context ctx, Service service) {
        super(ctx, ctx.getFile(service));
        this.service = service;
    }

    @Override
    protected void write() {
        this.importFile(ExecutorWriter.FILE);
        this.document(this.service.getDocument());
        this.code("export class ").code(this.getFile().getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            this.code("\nconstructor(private executor: Executor) {}\n");
            for (Operation operation : this.service.getOperations()) {
                this.write(operation);
            }
        });
    }

    private void write(Operation operation) {
        this.code('\n');
        this.document(operation.getDocument());
        this.code("async ").code(this.getContext().getOperationName(operation)).scope(CodeWriter.ScopeType.ARGUMENTS, "", false, () -> {
            if (!operation.getParameters().isEmpty()) {
                boolean optionsOptional = operation.getParameters().stream().allMatch(it -> it.getType() instanceof NullableType);
                this.code("options");
                this.codeIf(optionsOptional, '?');
                this.code(": ");
                this.scope(CodeWriter.ScopeType.OBJECT, ", ", operation.getParameters().size() > 2, () -> {
                    for (Parameter parameter : operation.getParameters()) {
                        this.separator();
                        if (parameter.getDocument() != null) {
                            this.code('\n');
                            this.document(parameter.getDocument());
                        }
                        this.write(parameter);
                    }
                });
            }
        }).code(": Promise<").type(operation.getType()).code("> ").scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.impl(operation)).code('\n');
    }

    private void write(Parameter parameter) {
        this.code("readonly ").code(parameter.getName()).codeIf(parameter.getType() instanceof NullableType, '?').code(": ").type(NullableType.unwrap(parameter.getType()));
    }

    private void impl(Operation operation) {
        boolean optionsOptional = operation.getParameters().stream().allMatch(it -> it.getType() instanceof NullableType);
        List<UriPart> parts = UriPart.parts(operation.getUri());
        if (parts.get((int)0).variable) {
            Parameter parameter = ServiceWriter.pathVariableParameter(operation, parts.get((int)0).text);
            this.code("let uri = encodeURIComponent(options.").code(parameter.getName()).codeIf(parameter.getType() instanceof ArrayType, "join(',')").code(");\n");
        } else {
            this.code("let uri = '").code(parts.get((int)0).text).code("';\n");
        }
        for (int i = 1; i < parts.size(); ++i) {
            if (parts.get((int)i).variable) {
                Parameter parameter = ServiceWriter.pathVariableParameter(operation, parts.get((int)i).text);
                this.code("uri += encodeURIComponent(options.").code(parameter.getName()).codeIf(parameter.getType() instanceof ArrayType, "join(',')").code(");\n");
                continue;
            }
            this.code("uri += '").code(parts.get((int)i).text).code("';\n");
        }
        List urlParameters = operation.getParameters().stream().filter(it -> it.getRequestParam() != null).collect(Collectors.toList());
        if (!urlParameters.isEmpty()) {
            String sp;
            boolean dynamicSeparator;
            boolean hasParamStart = operation.getUri().indexOf(63) != -1;
            boolean bl = dynamicSeparator = !hasParamStart && ((Parameter)urlParameters.get(0)).getType() instanceof NullableType && urlParameters.size() > 1;
            if (dynamicSeparator) {
                this.code("let separator = '?';\n");
                sp = "separator";
            } else {
                sp = hasParamStart ? "&" : "?";
            }
            for (Parameter parameter : operation.getParameters()) {
                if (parameter.getRequestParam() == null) continue;
                String finalSp = sp;
                boolean finalDynamic = dynamicSeparator;
                Runnable addUrlParameter = () -> {
                    if (finalDynamic) {
                        this.code("uri += ").code(finalSp).code(";\n");
                        this.code("uri += '").code(parameter.getRequestParam()).code("=';\n");
                    } else {
                        this.code("uri += '").code(finalSp).code(parameter.getRequestParam()).code("=';\n");
                    }
                    this.code("uri += encodeURIComponent(options." + parameter.getName() + ");\n");
                    if (finalDynamic && parameter.getType() instanceof NullableType) {
                        this.code("separator = '&';\n");
                    }
                };
                if (parameter.getType() instanceof NullableType) {
                    this.code("if (options").codeIf(optionsOptional, '?').code(".").code(parameter.getName()).code(" !== undefined && options.").code(parameter.getName()).code(" !== null) ");
                    this.scope(CodeWriter.ScopeType.OBJECT, "", true, addUrlParameter);
                    this.code('\n');
                } else {
                    addUrlParameter.run();
                    dynamicSeparator = false;
                }
                if (dynamicSeparator) continue;
                sp = "&";
            }
        }
        this.code("return (await this.executor({uri, method: '").code(operation.getHttpMethod().name()).code("'");
        for (Parameter parameter : operation.getParameters()) {
            if (!parameter.isRequestBody()) continue;
            this.code(", body: options.").code(parameter.getName());
        }
        this.code("})) as ").type(operation.getType());
    }

    private static Parameter pathVariableParameter(Operation operation, String pathVariable) {
        for (Parameter parameter : operation.getParameters()) {
            if (!pathVariable.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalDocMetaException("Illegal operation \"" + operation.getRawMethod() + "\", the path variable {" + pathVariable + "} cannot be resolved any any parameters");
    }

    @Override
    protected boolean rawImmutableAsDynamic() {
        return true;
    }

    private static class UriPart {
        private static final Pattern SLASH_PATTERN = Pattern.compile("\\{[^\\}]+\\}");
        final String text;
        final boolean variable;

        private UriPart(String text, boolean variable) {
            this.text = text;
            this.variable = variable;
        }

        public static List<UriPart> parts(String uri) {
            if (!uri.startsWith("/")) {
                uri = '/' + uri;
            }
            ArrayList<UriPart> uriParts = new ArrayList<UriPart>();
            Matcher matcher = SLASH_PATTERN.matcher(uri);
            int pos = 0;
            while (matcher.find()) {
                if (matcher.start() > pos) {
                    uriParts.add(new UriPart(uri.substring(pos, matcher.start()), false));
                }
                uriParts.add(new UriPart(uri.substring(matcher.start() + 1, matcher.end() - 1), true));
                pos = matcher.end();
            }
            if (pos < uri.length()) {
                uriParts.add(new UriPart(uri.substring(pos, uri.length()), false));
            }
            return uriParts;
        }
    }
}

