/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import org.babyfish.jimmer.client.generator.ts.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.generator.ts.ExecutorWriter;
import org.babyfish.jimmer.client.generator.ts.File;

public class ModuleWriter
extends CodeWriter {
    public ModuleWriter(Context ctx) {
        super(ctx, ctx.getModuleFile());
    }

    @Override
    protected void write() {
        this.importFile(ExecutorWriter.FILE);
        this.code("export class ").code(this.getFile().getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (File file : this.getContext().getServiceFileMap().values()) {
                this.importFile(file, true);
                this.code("\nreadonly ").code(ModuleWriter.toFieldName(file.getName())).code(": ").code(file.getName()).code(";\n");
            }
            this.code("\nconstructor(executor: Executor) ");
            this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                for (File file : this.getContext().getServiceFileMap().values()) {
                    this.code("this.").code(ModuleWriter.toFieldName(file.getName())).code(" = new ").code(file.getName()).code("(executor);\n");
                }
            });
        });
    }

    private static String toFieldName(String serviceName) {
        char[] chs = serviceName.toCharArray();
        for (int i = 0; i < chs.length && Character.isUpperCase(chs[i]); ++i) {
            chs[i] = Character.toLowerCase(chs[i]);
        }
        return new String(chs);
    }
}

