/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.babyfish.jimmer.client.generator.ts.Context;
import org.babyfish.jimmer.client.generator.ts.DtoWriter;
import org.babyfish.jimmer.client.generator.ts.DynamicWriter;
import org.babyfish.jimmer.client.generator.ts.File;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.MapType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.StaticObjectType;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.UnresolvedTypeVariable;

public abstract class CodeWriter {
    static final Map<Class<?>, String> SIMPLE_TYPE_NAMES;
    private static final String[] EMPTY_ARR;
    private static final Pattern SLASH_PATTERN;
    private final Context ctx;
    private final File file;
    private final StringBuilder codeBuilder = new StringBuilder();
    private final Map<String, Set<String>> importMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> importDataMap = new HashMap<String, Set<String>>();
    private int indent;
    private boolean lineDirty;
    private Scope scope;

    protected CodeWriter(Context ctx, File file) {
        this.ctx = ctx;
        this.file = file;
    }

    public Context getContext() {
        return this.ctx;
    }

    public File getFile() {
        return this.file;
    }

    public CodeWriter codeIf(boolean cond, String ts) {
        if (cond) {
            return this.code(ts);
        }
        return this;
    }

    public CodeWriter codeIf(boolean cond, char c) {
        if (cond) {
            return this.code(c);
        }
        return this;
    }

    public CodeWriter code(String ts) {
        if (ts.isEmpty()) {
            return this;
        }
        int size = ts.length();
        for (int i = 0; i < size; ++i) {
            this.doAdd(ts.charAt(i));
        }
        return this;
    }

    public CodeWriter code(char c) {
        this.doAdd(c);
        return this;
    }

    public CodeWriter importFile(File file) {
        return this.importFile(file, false);
    }

    public CodeWriter importFile(File file, boolean treatAsData) {
        if (file != null && !file.equals(this.file)) {
            int i;
            int sameCount;
            String[] currentPaths = this.file.getDir().isEmpty() ? EMPTY_ARR : SLASH_PATTERN.split(this.file.getDir());
            String[] paths = file.getDir().isEmpty() ? EMPTY_ARR : SLASH_PATTERN.split(file.getDir());
            int len = Math.min(currentPaths.length, paths.length);
            for (sameCount = 0; sameCount < len && currentPaths[sameCount].equals(paths[sameCount]); ++sameCount) {
            }
            StringBuilder builder = new StringBuilder();
            if (sameCount < currentPaths.length) {
                for (i = currentPaths.length - sameCount; i > 0; --i) {
                    builder.append("..");
                    if (i == 1) continue;
                    builder.append('/');
                }
            } else {
                builder.append(".");
            }
            if (sameCount == paths.length) {
                builder.append('/');
            }
            for (i = sameCount; i < paths.length; ++i) {
                builder.append('/').append(paths[i]);
            }
            String path = builder.toString();
            (treatAsData ? this.importDataMap : this.importMap).computeIfAbsent(path, it -> new LinkedHashSet()).add(file.getName());
        }
        return this;
    }

    public CodeWriter type(Type type) {
        if (type instanceof UnresolvedTypeVariable) {
            this.code(((UnresolvedTypeVariable)type).getName());
        } else if (type instanceof SimpleType) {
            String name = SIMPLE_TYPE_NAMES.get(((SimpleType)type).getJavaType());
            if (name == null) {
                name = "any";
            }
            this.code(name);
        } else if (type instanceof NullableType) {
            this.type(((NullableType)type).getTargetType());
            this.code(" | undefined");
        } else if (type instanceof ArrayType) {
            this.code("ReadonlyArray<");
            this.type(((ArrayType)type).getElementType());
            this.code(">");
        } else if (type instanceof MapType) {
            this.code("ReadonlyMap<");
            this.type(((MapType)type).getKeyType());
            this.code(", ");
            this.type(((MapType)type).getValueType());
            this.code(">");
        } else {
            File file = this.ctx.getFile(type);
            if (file != null) {
                this.importFile(file);
                if (type instanceof ImmutableObjectType && this.rawImmutableAsDynamic() && ((ImmutableObjectType)type).getCategory() == ImmutableObjectType.Category.RAW) {
                    this.importFile(DynamicWriter.FILE);
                    this.code("Dynamic<").code(file.getName()).code('>');
                } else {
                    List<Type> typeArguments;
                    this.code(file.getName());
                    if (type instanceof StaticObjectType && !(typeArguments = ((StaticObjectType)type).getTypeArguments()).isEmpty()) {
                        this.scope(ScopeType.GENERIC, ", ", false, () -> {
                            for (Type typeArgument : typeArguments) {
                                this.separator();
                                this.type(typeArgument);
                            }
                        });
                    }
                }
            } else if (type instanceof ImmutableObjectType) {
                ImmutableObjectType immutableObjectType = (ImmutableObjectType)type;
                if (immutableObjectType.getFetchByInfo() != null) {
                    this.importFile(DtoWriter.dtoFile(this.ctx, immutableObjectType.getJavaType()));
                    this.code(this.ctx.getDtoPrefix(immutableObjectType.getJavaType())).code("['").code(this.ctx.getDtoSuffix(immutableObjectType)).code("']");
                } else if (immutableObjectType.getCategory() == ImmutableObjectType.Category.VIEW) {
                    this.importFile(DtoWriter.dtoFile(this.ctx, immutableObjectType.getJavaType()));
                    this.code(this.ctx.getDtoPrefix(immutableObjectType.getJavaType())).code("['DEFAULT']");
                } else {
                    this.scope(ScopeType.OBJECT, ", ", immutableObjectType.getProperties().size() > 1, () -> {
                        for (Property property : immutableObjectType.getProperties().values()) {
                            this.separator();
                            if (property.getDocument() != null) {
                                this.code('\n');
                                this.document(property.getDocument());
                            }
                            this.code("readonly ").code(property.getName()).codeIf(property.getType() instanceof NullableType, "?").code(": ");
                            this.type(NullableType.unwrap(property.getType()));
                        }
                    });
                }
            }
        }
        return this;
    }

    public CodeWriter separator() {
        Scope scope = this.scope;
        if (scope == null) {
            throw new IllegalStateException("There is no existing scope");
        }
        if (scope.dirty) {
            this.code(scope.separator);
            if (scope.multiLines) {
                this.code('\n');
            }
        }
        return this;
    }

    public CodeWriter document(Document document) {
        if (document == null) {
            return null;
        }
        boolean visitedFirstLine = false;
        this.code("/**\n");
        for (Document.Item item : document.getItems()) {
            this.code(" * ");
            if (item.getDepth() != 0) {
                for (int i = item.getDepth(); i > 1; --i) {
                    this.code(this.ctx.getIndent());
                }
                this.code('-').code(this.ctx.getIndent().substring(1));
            } else if (visitedFirstLine) {
                this.code("\n * ");
            }
            this.code(item.getText());
            this.code('\n');
            visitedFirstLine = true;
        }
        this.code(" */\n");
        return this;
    }

    private void doAdd(char c) {
        if (!this.lineDirty) {
            for (int i = this.indent; i > 0; --i) {
                this.codeBuilder.append(this.ctx.getIndent());
            }
            this.lineDirty = true;
        }
        if (this.scope != null) {
            this.scope.dirty();
        }
        this.codeBuilder.append(c);
        if (c == '\n') {
            this.lineDirty = false;
        }
    }

    public CodeWriter scope(ScopeType type, String separator, boolean multiLines, Runnable runnable) {
        Scope oldScope = this.scope;
        Scope newScope = new Scope(oldScope, separator, multiLines);
        this.code(type.prefix);
        if (multiLines) {
            this.code('\n');
            ++this.indent;
        }
        this.scope = newScope;
        runnable.run();
        if (multiLines) {
            --this.indent;
            if (this.lineDirty) {
                this.code('\n');
            }
        }
        this.code(type.suffix);
        this.scope = oldScope;
        return this;
    }

    protected abstract void write();

    public void flush() throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.ctx.getOutputStream());
        this.write();
        CodeWriter.applyImportMap(this.importMap, false, writer);
        CodeWriter.applyImportMap(this.importDataMap, true, writer);
        writer.write(this.codeBuilder.toString());
        writer.flush();
    }

    private static void applyImportMap(Map<String, Set<String>> importMap, boolean treatAsData, Writer writer) throws IOException {
        if (!importMap.isEmpty()) {
            for (Map.Entry<String, Set<String>> e : importMap.entrySet()) {
                writer.write(treatAsData ? "import { " : "import type { ");
                boolean addComma = false;
                for (String name : e.getValue()) {
                    if (addComma) {
                        writer.write(", ");
                    } else {
                        addComma = true;
                    }
                    writer.write(name);
                }
                writer.write(" } from '");
                writer.write(e.getKey());
                writer.write("';\n");
            }
            writer.write(10);
        }
    }

    protected boolean rawImmutableAsDynamic() {
        return false;
    }

    static {
        EMPTY_ARR = new String[0];
        SLASH_PATTERN = Pattern.compile("/");
        HashMap map = new HashMap();
        map.put(Void.TYPE, "void");
        map.put(Boolean.TYPE, "boolean");
        map.put(Boolean.class, "boolean");
        map.put(Character.TYPE, "number");
        map.put(Character.class, "number");
        map.put(Byte.TYPE, "number");
        map.put(Byte.class, "number");
        map.put(Short.TYPE, "number");
        map.put(Short.class, "number");
        map.put(Integer.TYPE, "number");
        map.put(Integer.class, "number");
        map.put(Long.TYPE, "number");
        map.put(Long.class, "number");
        map.put(Float.TYPE, "number");
        map.put(Float.class, "number");
        map.put(Double.TYPE, "number");
        map.put(Double.class, "number");
        map.put(BigInteger.class, "number");
        map.put(BigDecimal.class, "number");
        map.put(String.class, "string");
        map.put(UUID.class, "string");
        map.put(java.util.Date.class, "string");
        map.put(Date.class, "string");
        map.put(Time.class, "string");
        map.put(Timestamp.class, "string");
        map.put(LocalDate.class, "string");
        map.put(LocalTime.class, "string");
        map.put(LocalDateTime.class, "string");
        map.put(OffsetDateTime.class, "string");
        map.put(ZonedDateTime.class, "string");
        SIMPLE_TYPE_NAMES = map;
    }

    static enum ScopeType {
        OBJECT("{", "}"),
        LIST("[", "]"),
        ARGUMENTS("(", ")"),
        GENERIC("<", ">"),
        BLANK("", "");

        final String prefix;
        final String suffix;

        private ScopeType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }

    private static class Scope {
        private final Scope parent;
        final String separator;
        final boolean multiLines;
        boolean dirty;

        Scope(Scope parent, String separator, boolean multiLines) {
            this.parent = parent;
            this.separator = separator;
            this.multiLines = multiLines;
        }

        void dirty() {
            if (!this.dirty) {
                this.dirty = true;
                if (this.parent != null) {
                    this.parent.dirty();
                }
            }
        }
    }
}

