/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.error.CodeBasedRuntimeException;
import org.babyfish.jimmer.error.ErrorFamily;
import org.babyfish.jimmer.error.ErrorField;
import org.babyfish.jimmer.error.ErrorFields;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorGenerator {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final String ERROR_FIELDS_NAME = ErrorFields.class.getName();
    private static final String ERROR_FIELD_NAME = ErrorField.class.getName();
    private static final String[] EMPTY_STR_ARR = new String[0];
    private static final Map<String, TypeName> PRIMITIVE_TYPE_MAP;
    private final Context context;
    private final TypeElement typeElement;
    private final boolean checkedException;
    private final Filer filer;
    private final String packageName;
    private final ClassName className;
    private final String family;
    private final String exceptionName;
    private final ClassName exceptionClassName;
    private TypeSpec.Builder typeBuilder;
    private Map<Element, List<Field>> declaredFieldsCache = new HashMap<Element, List<Field>>();
    private Map<Element, List<Field>> fieldsCache = new HashMap<Element, List<Field>>();

    public ErrorGenerator(Context context, TypeElement typeElement, boolean checkedException, Filer filer) {
        this.context = context;
        this.typeElement = typeElement;
        this.checkedException = checkedException;
        this.filer = filer;
        this.packageName = this.packageName();
        CharSequence[] simpleNames = this.simpleNames();
        this.className = ClassName.get((String)this.packageName, (String)simpleNames[0], (String[])Arrays.copyOfRange(simpleNames, 1, simpleNames.length));
        String name = String.join((CharSequence)"_", simpleNames);
        if (name.endsWith("_ErrorCode")) {
            name = name.substring(0, name.length() - 10);
        } else if (name.endsWith("ErrorCode")) {
            name = name.substring(0, name.length() - 9);
        } else if (name.endsWith("_Error")) {
            name = name.substring(0, name.length() - 6);
        } else if (name.endsWith("Error")) {
            name = name.substring(0, name.length() - 5);
        }
        String family = typeElement.getAnnotation(ErrorFamily.class).value();
        if (family.isEmpty()) {
            family = StringUtil.snake((String)name, (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER);
        }
        this.family = family;
        this.exceptionName = name + "Exception";
        this.exceptionClassName = ClassName.get((String)this.packageName, (String)this.exceptionName, (String[])new String[0]);
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)this.exceptionName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).superclass(this.checkedException ? CodeBasedException.class : CodeBasedRuntimeException.class).addAnnotation(AnnotationSpec.builder((ClassName)Constants.GENERATED_BY_CLASS_NAME).addMember("type", "$T.class", new Object[]{this.className}).build()).addAnnotation(this.clientException(this.typeElement));
        String doc = this.context.getElements().getDocComment(this.typeElement);
        if (doc != null && !doc.isEmpty()) {
            this.typeBuilder.addJavadoc(doc, new Object[0]);
        }
        this.addMembers();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate code based exception for enum type '%s'", this.typeElement.getQualifiedName().toString()), ex);
        }
    }

    private String packageName() {
        for (Element element = this.typeElement.getEnclosingElement(); element != null; element = element.getEnclosingElement()) {
            if (!(element instanceof PackageElement)) continue;
            return ((PackageElement)element).getQualifiedName().toString();
        }
        return "";
    }

    private String[] simpleNames() {
        String qualifiedName = this.typeElement.getQualifiedName().toString();
        if (this.packageName.isEmpty()) {
            return DOT_PATTERN.split(qualifiedName);
        }
        return DOT_PATTERN.split(qualifiedName.substring(this.packageName.length() + 1));
    }

    private void addMembers() {
        this.addCommonMembers(this.typeElement, this.typeBuilder);
        this.addGetEnum();
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.addCreator(element, false);
            this.addCreator(element, true);
        }
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.addType(element);
        }
    }

    private void addGetEnum() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + this.typeElement.getSimpleName().toString())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(JsonIgnore.class).returns((TypeName)this.className);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreator(Element element, boolean withCause) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)ErrorGenerator.javaName(element, false)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.exceptionClassName.nestedClass(ErrorGenerator.javaName(element, true))).addParameter(ParameterSpec.builder((TypeName)Constants.STRING_CLASS_NAME, (String)"message", (Modifier[])new Modifier[0]).addAnnotation(NotNull.class).build());
        if (withCause) {
            builder.addParameter(ParameterSpec.builder(Throwable.class, (String)"cause", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        }
        List<Field> fields = this.fieldsOf(element);
        for (Field field : fields) {
            builder.addParameter(ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addAnnotation(field.isNullable ? Nullable.class : NotNull.class).build());
        }
        builder.addCode("return new $L(\n$>", new Object[]{ErrorGenerator.javaName(element, true)});
        builder.addCode("message,\n", new Object[0]).addCode(withCause ? "cause" : "null", new Object[0]);
        for (Field field : fields) {
            builder.addCode(",\n$L", new Object[]{field.name});
        }
        builder.addCode("\n$<);\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addType(Element element) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)ErrorGenerator.javaName(element, true)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)this.exceptionClassName).addAnnotation(this.clientException(element));
        String doc = this.context.getElements().getDocComment(element);
        if (doc != null && !doc.isEmpty()) {
            builder.addJavadoc(doc, new Object[0]);
        }
        this.addCommonMembers(element, builder);
        builder.addMethod(MethodSpec.methodBuilder((String)("get" + this.typeElement.getSimpleName().toString())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(JsonIgnore.class).addAnnotation(Override.class).returns((TypeName)this.className).addStatement("return $T.$L", new Object[]{this.className, element.getSimpleName().toString()}).build());
        MethodSpec.Builder getFieldsBuilder = MethodSpec.methodBuilder((String)"getFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.MAP_CLASS_NAME, (TypeName[])new TypeName[]{Constants.STRING_CLASS_NAME, TypeName.OBJECT}));
        List<Field> fields = this.fieldsOf(element);
        if (fields.isEmpty()) {
            getFieldsBuilder.addStatement("return $T.emptyMap()", new Object[]{Constants.COLLECTIONS_CLASS_NAME});
        } else if (fields.size() == 1) {
            getFieldsBuilder.addStatement("return $T.singletonMap($S, $L)", new Object[]{Constants.COLLECTIONS_CLASS_NAME, fields.get((int)0).name, fields.get((int)0).name});
        } else {
            getFieldsBuilder.addStatement("$T __fields = new $T<>()", new Object[]{Constants.MAP_CLASS_NAME, Constants.LINKED_HASH_MAP_CLASS_NAME});
            for (Field field : fields) {
                getFieldsBuilder.addStatement("__fields.put($S, $L)", new Object[]{field.name, field.name});
            }
            getFieldsBuilder.addStatement("return __fields", new Object[0]);
        }
        builder.addMethod(getFieldsBuilder.build());
        this.typeBuilder.addType(builder.build());
    }

    private void addCommonMembers(Element element, TypeSpec.Builder builder) {
        for (Field field : this.declaredFieldsOf(element)) {
            FieldSpec.Builder builder2 = FieldSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(field.isNullable ? Nullable.class : NotNull.class);
            builder.addField(builder2.build());
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Constants.STRING_CLASS_NAME, "message", new Modifier[0]).addParameter((TypeName)Constants.THROWABLE_CLASS_NAME, "cause", new Modifier[0]);
        for (Field field : this.fieldsOf(element)) {
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addAnnotation(field.isNullable ? Nullable.class : NotNull.class);
            constructorBuilder.addParameter(parameterBuilder.build());
        }
        if (element.getKind() == ElementKind.ENUM) {
            constructorBuilder.addStatement("super(message, cause)", new Object[0]);
        } else {
            CodeBlock.Builder builder3 = CodeBlock.builder();
            builder3.add("super(message, cause", new Object[0]);
            for (Field parentField : this.declaredFieldsOf(element.getEnclosingElement())) {
                builder3.add(", ", new Object[0]).add(parentField.name, new Object[0]);
            }
            builder3.add(")", new Object[0]);
            constructorBuilder.addStatement(builder3.build());
        }
        for (Field field : this.declaredFieldsOf(element)) {
            constructorBuilder.addStatement("this.$L = $L", new Object[]{field.name, field.name});
        }
        builder.addMethod(constructorBuilder.build());
        for (Field field : this.declaredFieldsOf(element)) {
            MethodSpec.Builder mb = MethodSpec.methodBuilder((String)((field.type.equals((Object)TypeName.BOOLEAN) ? "is" : "get") + Character.toUpperCase(field.name.charAt(0)) + field.name.substring(1))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.type).addAnnotation(field.isNullable ? Nullable.class : NotNull.class);
            if (!field.doc.isEmpty()) {
                mb.addJavadoc(field.doc, new Object[0]);
            }
            mb.addStatement("return $L", new Object[]{field.name});
            builder.addMethod(mb.build());
        }
    }

    private static String javaName(Element element, boolean upperHead) {
        String simpleName = element.getSimpleName().toString();
        int size = simpleName.length();
        boolean toUpper = upperHead;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            char c = simpleName.charAt(i);
            if (c == '_') {
                toUpper = true;
                continue;
            }
            if (toUpper) {
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(Character.toLowerCase(c));
            }
            toUpper = false;
        }
        return builder.toString();
    }

    private List<Field> declaredFieldsOf(Element element) {
        List<Field> fields = this.declaredFieldsCache.get(element);
        if (fields != null) {
            return fields;
        }
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (qualifiedName.equals(ERROR_FIELDS_NAME)) {
                Iterator<? extends AnnotationValue> itr = annotationMirror.getElementValues().values().iterator();
                if (!itr.hasNext()) break;
                AnnotationValue annotationValue = itr.next();
                for (AnnotationMirror childMirror : (List)annotationValue.getValue()) {
                    Field field = Field.of(childMirror, element);
                    if (map.put(field.name, field) == null) continue;
                    throw new MetaException(element, "Duplicate field \"" + field.name + "\"");
                }
                break;
            }
            if (!qualifiedName.equals(ERROR_FIELD_NAME)) continue;
            Field field = Field.of(annotationMirror, element);
            map.put(field.name, field);
            break;
        }
        fields = Collections.unmodifiableList(new ArrayList(map.values()));
        this.declaredFieldsCache.put(element, fields);
        return fields;
    }

    private List<Field> fieldsOf(Element element) {
        List<Field> sharedFields;
        List<Field> fields = this.fieldsCache.get(element);
        if (fields != null) {
            return fields;
        }
        List<Field> declaredFields = this.declaredFieldsOf(element);
        if (element.getKind() == ElementKind.ENUM_CONSTANT && !(sharedFields = this.declaredFieldsOf(element.getEnclosingElement())).isEmpty()) {
            Set sharedFieldNames = sharedFields.stream().map(it -> it.name).collect(Collectors.toSet());
            for (Field declaredField : declaredFields) {
                if (!sharedFieldNames.contains(declaredField.name)) continue;
                throw new MetaException(element, "The field \"" + declaredField.name + "\" has been defined in enum");
            }
            List<Field> mergedFields = new ArrayList<Field>(sharedFields.size() + declaredFields.size());
            mergedFields.addAll(sharedFields);
            mergedFields.addAll(declaredFields);
            mergedFields = Collections.unmodifiableList(mergedFields);
            fields = mergedFields;
        }
        if (fields == null) {
            fields = this.declaredFieldsOf(element);
        }
        this.fieldsCache.put(element, fields);
        return fields;
    }

    private AnnotationSpec clientException(Element element) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)Constants.CLIENT_EXCEPTION_CLASS_NAME).addMember("family", "$S", new Object[]{this.family});
        if (element.getKind() == ElementKind.ENUM) {
            CodeBlock.Builder cb = CodeBlock.builder();
            cb.add("{", new Object[0]);
            boolean addComma = false;
            for (Element element2 : element.getEnclosedElements()) {
                if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
                if (addComma) {
                    cb.add(", ", new Object[0]);
                } else {
                    addComma = true;
                }
                ClassName className = this.exceptionClassName.nestedClass(ErrorGenerator.javaName(element2, true));
                cb.add("$T.class", new Object[]{className});
            }
            cb.add("}", new Object[0]);
            builder.addMember("subTypes", cb.build());
        } else {
            builder.addMember("code", "$S", new Object[]{element.getSimpleName().toString()});
        }
        return builder.build();
    }

    private static TypeName typeName(String value) {
        TypeName primitiveTypeName = PRIMITIVE_TYPE_MAP.get(value);
        if (primitiveTypeName != null) {
            return primitiveTypeName;
        }
        StringBuilder packageBuilder = new StringBuilder();
        String simpleName = null;
        ArrayList<String> nestNames = new ArrayList<String>();
        for (String part : DOT_PATTERN.split(value)) {
            if (Character.isUpperCase(part.charAt(0))) {
                if (simpleName == null) {
                    simpleName = part;
                    continue;
                }
                nestNames.add(part);
                continue;
            }
            packageBuilder.append(part).append('.');
        }
        return ClassName.get((String)(packageBuilder.length() == 0 ? "" : packageBuilder.substring(0, packageBuilder.length() - 1)), simpleName, (String[])nestNames.toArray(EMPTY_STR_ARR));
    }

    static {
        HashMap<String, TypeName> map = new HashMap<String, TypeName>();
        map.put("boolean", TypeName.BOOLEAN);
        map.put("char", TypeName.CHAR);
        map.put("byte", TypeName.BYTE);
        map.put("short", TypeName.SHORT);
        map.put("int", TypeName.INT);
        map.put("long", TypeName.LONG);
        map.put("float", TypeName.FLOAT);
        map.put("double", TypeName.DOUBLE);
        PRIMITIVE_TYPE_MAP = map;
    }

    private static class Field {
        final String name;
        final TypeName type;
        final boolean isNullable;
        final boolean isList;
        final String doc;

        private Field(String name, TypeName type, boolean isNullable, boolean isList, String doc) {
            this.name = name;
            this.type = type;
            this.isNullable = isNullable;
            this.isList = isList;
            this.doc = doc;
        }

        public static Field of(AnnotationMirror annotationMirror, Element constantElement) {
            String name = null;
            ParameterizedTypeName typeName = null;
            boolean isNullable = false;
            boolean isList = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                String key = e.getKey().getSimpleName().toString();
                Object value = e.getValue().getValue();
                if (key.equals("name")) {
                    String str = (String)value;
                    if (str.equals("family") || str.equals("code")) {
                        throw new MetaException(constantElement, "The enum constant \"" + constantElement.getEnclosingElement().getSimpleName().toString() + '.' + constantElement.getSimpleName().toString() + "\" is illegal, it cannot be decorated by \"@" + ErrorFamily.class.getName() + "\" with the name \"family\" or \"code\"");
                    }
                    name = str;
                    continue;
                }
                if (key.equals("type")) {
                    typeName = ErrorGenerator.typeName(value.toString());
                    continue;
                }
                if (key.equals("nullable")) {
                    isNullable = (Boolean)value;
                    continue;
                }
                if (!key.equals("list")) continue;
                isList = (Boolean)value;
            }
            assert (typeName != null);
            if (isList) {
                if (typeName.isPrimitive()) {
                    throw new MetaException(constantElement, "The enum constant \"" + constantElement.getEnclosingElement().getSimpleName().toString() + '.' + constantElement.getSimpleName().toString() + "\" is decorated by @" + ErrorField.class.getName() + ", this annotation is illegal because its `type` is primitive but its `list` is true");
                }
                typeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{typeName});
            }
            String doc = Annotations.annotationValue(annotationMirror, "doc", "").trim();
            return new Field(name, (TypeName)typeName, isNullable, isList, doc);
        }
    }
}

