/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class PackageCollector {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private List<String> pathParts;
    private String str;
    private final Map<String, TypeElement> elementMap = new TreeMap<String, TypeElement>();

    public void accept(TypeElement typeElement) {
        this.elementMap.put(typeElement.getQualifiedName().toString(), typeElement);
        if (this.pathParts != null && this.pathParts.isEmpty()) {
            return;
        }
        this.str = null;
        for (Element parent = typeElement.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
            if (!(parent instanceof PackageElement)) continue;
            String packageName = ((PackageElement)parent).getQualifiedName().toString();
            this.accept(packageName);
            break;
        }
    }

    private void accept(String path) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(DOT_PATTERN.split(path)));
        if (this.pathParts == null) {
            this.pathParts = parts;
        } else {
            int index;
            int len = Math.min(this.pathParts.size(), parts.size());
            for (index = 0; index < len && this.pathParts.get(index).equals(parts.get(index)); ++index) {
            }
            if (index < this.pathParts.size()) {
                this.pathParts.subList(index, this.pathParts.size()).clear();
            }
        }
    }

    public Map<String, TypeElement> getElementMap() {
        return Collections.unmodifiableMap(this.elementMap);
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            List<String> ps = this.pathParts;
            s = ps == null || ps.isEmpty() ? "" : String.join((CharSequence)".", ps);
            this.str = s;
        }
        return s;
    }
}

