/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.client.ClientExceptionContext;
import org.babyfish.jimmer.apt.client.ClientExceptionMetadata;
import org.babyfish.jimmer.apt.client.FetchByUnsupportedException;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.util.ConverterMetadata;
import org.babyfish.jimmer.apt.util.GenericParser;
import org.babyfish.jimmer.client.ApiIgnore;
import org.babyfish.jimmer.client.FetchBy;
import org.babyfish.jimmer.client.TNullable;
import org.babyfish.jimmer.client.meta.Api;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.DefaultFetcherOwner;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Schema;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.ApiOperationImpl;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.ApiServiceImpl;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.SchemaBuilder;
import org.babyfish.jimmer.client.meta.impl.SchemaImpl;
import org.babyfish.jimmer.client.meta.impl.Schemas;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionImpl;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.error.CodeBasedRuntimeException;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.internal.ClientException;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.jetbrains.annotations.Nullable;

public class ClientProcessor {
    private static final String JIMMER_CLIENT = "META-INF/jimmer/client";
    private static final TypeName FETCH_BY_NAME = TypeName.of(FetchBy.class);
    private static final TypeName CODE_BASED_EXCEPTION_NAME = TypeName.of(CodeBasedException.class);
    private static final TypeName CODE_BASED_RUNTIME_EXCEPTION_NAME = TypeName.of(CodeBasedRuntimeException.class);
    private final Context context;
    private final ClientExceptionContext clientExceptionContext;
    private final Elements elements;
    private final Collection<String> delayedClientTypeNames;
    private final File jimmerClientFile;
    private final boolean explicitApi;
    private final SchemaBuilder<Element> builder;
    private final Set<TypeName> jsonValueTypeNameStack = new HashSet<TypeName>();

    public ClientProcessor(Context context, final Elements elements, Filer filer, boolean explicitApi, Collection<String> delayedClientTypeNames) {
        FileObject fileObject;
        this.context = context;
        this.clientExceptionContext = new ClientExceptionContext(context);
        this.elements = elements;
        this.explicitApi = explicitApi;
        this.delayedClientTypeNames = delayedClientTypeNames;
        try {
            fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", JIMMER_CLIENT);
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot get file object \"META-INF/jimmer/client\"", ex);
        }
        this.jimmerClientFile = new File(fileObject.getName());
        this.builder = new SchemaBuilder<Element>(this.existingSchema()){

            @Nullable
            protected Element loadSource(String typeName) {
                return elements.getTypeElement(typeName);
            }

            protected void throwException(Element source, String message) {
                throw new MetaException(source, message);
            }

            protected void fillDefinition(Element source) {
                TypeElement typeElement;
                ClientProcessor.this.fillDefinition(typeElement, (typeElement = (TypeElement)source).getAnnotation(Immutable.class) != null || typeElement.getAnnotation(Entity.class) != null || typeElement.getAnnotation(MappedSuperclass.class) != null || typeElement.getAnnotation(Embeddable.class) != null);
            }
        };
    }

    private Schema existingSchema() {
        if (this.jimmerClientFile.exists()) {
            Schema schema;
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.jimmerClientFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            try {
                schema = Schemas.readServicesFrom((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new GeneratorException("Cannot read content of  \"" + this.jimmerClientFile + "\"", ex);
                }
            }
            ((Reader)reader).close();
            return schema;
        }
        return null;
    }

    public void process(RoundEnvironment roundEnv) {
        this.checkJdkVersion(roundEnv);
        for (Element element : roundEnv.getRootElements()) {
            this.handleService(element);
        }
        if (this.delayedClientTypeNames != null) {
            for (String string : this.delayedClientTypeNames) {
                this.handleService(this.context.getElements().getTypeElement(string));
            }
        }
        Schema schema = this.builder.build();
        this.jimmerClientFile.getParentFile().mkdirs();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(this.jimmerClientFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            Schemas.writeTo((Schema)schema, (Writer)outputStreamWriter);
        }
        catch (IOException iOException) {
            throw new GeneratorException("Cannot write \"" + this.jimmerClientFile + "\"", iOException);
        }
    }

    private void checkJdkVersion(RoundEnvironment roundEnv) {
        try {
            String.class.getMethod("isBlank", new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            boolean hasApiService = false;
            for (Element element : roundEnv.getRootElements()) {
                if (!this.isApiService(element)) continue;
                hasApiService = true;
                break;
            }
            if (!hasApiService && this.delayedClientTypeNames != null) {
                for (String string : this.delayedClientTypeNames) {
                    if (!this.isApiService(this.context.getElements().getTypeElement(string))) continue;
                    hasApiService = true;
                    break;
                }
            }
            if (hasApiService) {
                throw new FetchByUnsupportedException();
            }
            return;
        }
    }

    private void handleService(Element element) {
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        if (!this.isApiService(element)) {
            return;
        }
        if (typeElement.getNestingKind().isNested()) {
            throw new MetaException(typeElement, "the API service type must be top-level");
        }
        if (!typeElement.getTypeParameters().isEmpty()) {
            throw new MetaException(typeElement.getTypeParameters().get(0), "API service cannot declare type parameters");
        }
        SchemaImpl schema = (SchemaImpl)this.builder.current();
        this.builder.api((Object)typeElement, ClientProcessor.typeName(typeElement), apiService -> {
            Api api = typeElement.getAnnotation(Api.class);
            if (api != null) {
                apiService.setGroups(Arrays.asList(api.value()));
            }
            apiService.setDoc(Doc.parse((String)this.elements.getDocComment(typeElement)));
            for (Element element : typeElement.getEnclosedElements()) {
                ExecutableElement executableElement;
                if (!(element instanceof ExecutableElement) || element.getAnnotation(ApiIgnore.class) != null || !this.isApiOperation(executableElement = (ExecutableElement)element)) continue;
                this.handleMethod(executableElement);
            }
            schema.addApiService(apiService);
        });
    }

    private void handleMethod(ExecutableElement method) {
        ApiServiceImpl service = (ApiServiceImpl)this.builder.current();
        if (!method.getTypeParameters().isEmpty()) {
            throw new MetaException(method.getTypeParameters().get(0), "API method cannot declare type parameters");
        }
        Api api = method.getAnnotation(Api.class);
        if (api == null) {
            boolean matched = false;
            if (this.explicitApi) {
                for (String autoOperationAnnotation : ApiOperation.AUTO_OPERATION_ANNOTATIONS) {
                    if (Annotations.annotationMirror((Element)method, autoOperationAnnotation) == null) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched) {
                return;
            }
        }
        this.builder.operation((Object)method, method.getSimpleName().toString(), operation -> {
            if (api != null) {
                List parentGroups;
                List<String> groups = Arrays.asList(api.value());
                if (groups.isEmpty()) {
                    groups = null;
                }
                if ((parentGroups = service.getGroups()) != null && groups != null) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(groups);
                    linkedHashSet.retainAll(parentGroups);
                    if (!linkedHashSet.isEmpty()) {
                        throw new MetaException((Element)operation.getSource(), "It cannot be decorated by \"@" + Api.class + "\" with `groups` \"" + linkedHashSet + "\" because they are not declared in declaring type \"" + service.getTypeName() + "\"");
                    }
                }
                operation.setGroups(groups);
            }
            operation.setDoc(Doc.parse((String)this.elements.getDocComment(method)));
            int[] indexRef = new int[1];
            for (VariableElement variableElement : method.getParameters()) {
                this.builder.parameter((Object)variableElement, variableElement.getSimpleName().toString(), parameter -> {
                    int n = indexRef[0];
                    indexRef[0] = n + 1;
                    parameter.setOriginalIndex(n);
                    if (Annotations.annotationMirror((Element)parameterElement, ApiIgnore.class) != null) {
                        operation.addIgnoredParameter(parameter);
                    } else {
                        this.builder.typeRef(type -> {
                            this.fillType(parameterElement.asType());
                            this.setNullityByJetBrainsAnnotation((TypeRefImpl<Element>)type, parameterElement, parameterElement.asType());
                            parameter.setType(type);
                        });
                        operation.addParameter(parameter);
                    }
                });
            }
            if (method.getReturnType().getKind() != TypeKind.VOID) {
                this.builder.typeRef(type -> {
                    this.fillType(method.getReturnType());
                    this.setNullityByJetBrainsAnnotation((TypeRefImpl<Element>)type, method, method.getReturnType());
                    operation.setReturnType(type);
                });
            }
            operation.setExceptionTypeNames(this.getExceptionTypeNames(method));
            service.addOperation(operation);
        });
    }

    private Set<TypeName> getExceptionTypeNames(ExecutableElement method) {
        List<? extends TypeMirror> exceptionTypes = method.getThrownTypes();
        if (exceptionTypes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<TypeName> exceptionTypeNames = new LinkedHashSet<TypeName>();
        for (TypeMirror typeMirror : exceptionTypes) {
            TypeElement typeElement = (TypeElement)this.context.getTypes().asElement(typeMirror);
            if (typeElement.getAnnotation(ClientException.class) == null) continue;
            this.collectExceptionTypeNames(this.clientExceptionContext.get(typeElement), exceptionTypeNames);
        }
        return exceptionTypeNames;
    }

    private void collectExceptionTypeNames(ClientExceptionMetadata metadata, Set<TypeName> exceptionTypeNames) {
        if (metadata.getCode() != null) {
            exceptionTypeNames.add(ClientProcessor.typeName(metadata.getElement()));
        }
        for (ClientExceptionMetadata subMetadata : metadata.getSubMetdatas()) {
            this.collectExceptionTypeNames(subMetadata, exceptionTypeNames);
        }
    }

    private void fillType(TypeMirror type) {
        if (type.getKind() != TypeKind.VOID) {
            TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
            try {
                this.determineTypeAndArguments(type);
                this.determineNullity(type);
                this.determineFetchBy(type);
                ClientProcessor.removeOptional((TypeRefImpl<Element>)typeRef);
            }
            catch (JsonValueTypeChangeException ex) {
                typeRef.replaceBy(ex.typeRef, Boolean.valueOf(typeRef.isNullable() || ex.typeRef.isNullable()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void determineFetchBy(TypeMirror entityType) {
        void var9_13;
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        AnnotationMirror fetchBy = entityType.getAnnotationMirrors().stream().filter(it -> FETCH_BY_NAME.equals((Object)ClientProcessor.typeName(it.getAnnotationType().asElement()))).findFirst().orElse(null);
        if (fetchBy == null) {
            return;
        }
        if (!this.context.isEntity(entityType)) {
            throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Illegal type because \"" + entityType + "\" which is decorated by `@FetchBy` is not entity type");
        }
        String constant = Annotations.annotationValue(fetchBy, "value", null);
        if (constant.isEmpty()) {
            throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "The `value` of `@FetchBy` is required");
        }
        Object owner = Annotations.annotationValue(fetchBy, "ownerType", null);
        if (owner == null || owner.toString().equals("void")) {
            TypeElement element = (TypeElement)this.builder.ancestorSource(new Class[]{ApiServiceImpl.class, TypeDefinitionImpl.class});
            assert (element != null);
            AnnotationMirror defaultFetcherOwner = Annotations.annotationMirror((Element)element, DefaultFetcherOwner.class);
            if (defaultFetcherOwner != null) {
                owner = Annotations.annotationValue(defaultFetcherOwner, "value", null);
            }
            if (owner == null || owner.toString().equals("void")) {
                owner = element.getQualifiedName().toString();
            }
        }
        TypeElement ownerElement = this.elements.getTypeElement(owner.toString());
        VariableElement fetcherElement = null;
        for (Element element : ownerElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getSimpleName().toString().equals(constant)) continue;
            fetcherElement = (VariableElement)element;
            break;
        }
        if (fetcherElement == null) {
            throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Illegal `@FetcherBy`, there is no static field \"" + constant + "\" in entityType \"\"" + owner);
        }
        TypeMirror typeMirror = fetcherElement.asType();
        Object var9_10 = null;
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement element = (TypeElement)declaredType.asElement();
            if (declaredType.getTypeArguments().isEmpty()) {
                String string = new GenericParser((String)"fetcher", (TypeElement)element, (String)"org.babyfish.jimmer.sql.fetcher.Fetcher").parse().argumentTypeNames.get(0).toString();
            } else {
                if (!element.getQualifiedName().toString().equals("org.babyfish.jimmer.sql.fetcher.Fetcher")) {
                    throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Illegal `@FetcherBy`, there is static field \"" + constant + "\" in entityType \"\"" + owner + " but it is not \"org.babyfish.jimmer.sql.fetcher.Fetcher\"");
                }
                String string = declaredType.getTypeArguments().get(0).toString();
            }
        }
        if (!((TypeElement)((DeclaredType)entityType).asElement()).getQualifiedName().toString().equals(var9_13)) {
            throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Illegal `@FetcherBy`, there is static field \"" + constant + "\" in owner type \"\"" + owner + " but it is not fetcher for \"" + ((TypeElement)((DeclaredType)entityType).asElement()).getQualifiedName() + "\"");
        }
        typeRef.setFetchBy(constant);
        typeRef.setFetcherOwner(ClientProcessor.typeName(ownerElement));
        typeRef.setFetcherDoc(Doc.parse((String)this.context.getElements().getDocComment(fetcherElement)));
    }

    private void determineNullity(TypeMirror type) {
        TypeRef parentRef;
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        boolean isRawTypePrimitive = type.getKind().isPrimitive();
        boolean isPrimitive = typeRef.getTypeName().isPrimitive();
        if (type.getAnnotation(TNullable.class) != null) {
            if (isRawTypePrimitive) {
                throw new MetaException((Element)this.builder.ancestorSource(new Class[0]), "Illegal annotation `@" + TNullable.class.getName() + "` which cannot be used to decorate primitive type");
            }
            typeRef.setNullable(true);
        }
        if (isPrimitive && !isRawTypePrimitive && (parentRef = (TypeRef)this.builder.parent(TypeRefImpl.class)) == null) {
            typeRef.setNullable(true);
        }
    }

    private void determineTypeAndArguments(TypeMirror type) {
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        switch (type.getKind()) {
            case BOOLEAN: {
                typeRef.setTypeName(TypeName.BOOLEAN);
                break;
            }
            case CHAR: {
                typeRef.setTypeName(TypeName.CHAR);
                break;
            }
            case BYTE: {
                typeRef.setTypeName(TypeName.BYTE);
                break;
            }
            case SHORT: {
                typeRef.setTypeName(TypeName.SHORT);
                break;
            }
            case INT: {
                typeRef.setTypeName(TypeName.INT);
                break;
            }
            case LONG: {
                typeRef.setTypeName(TypeName.LONG);
                break;
            }
            case FLOAT: {
                typeRef.setTypeName(TypeName.FLOAT);
                break;
            }
            case DOUBLE: {
                typeRef.setTypeName(TypeName.DOUBLE);
                break;
            }
            case TYPEVAR: {
                this.handleTypeVariable((TypeVariable)type);
                break;
            }
            case WILDCARD: {
                this.handleWildcardType((WildcardType)type);
                break;
            }
            case INTERSECTION: {
                this.handleIntersectionType((IntersectionType)type);
                break;
            }
            case ARRAY: {
                this.handleArrayType((ArrayType)type);
                break;
            }
            case DECLARED: {
                this.handleDeclaredType((DeclaredType)type);
            }
        }
    }

    private void handleTypeVariable(TypeVariable typeVariable) {
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        Element element = typeVariable.asElement();
        TypeElement parentElement = (TypeElement)element.getEnclosingElement();
        String name = element.getSimpleName().toString();
        typeRef.setTypeName(ClientProcessor.typeName(parentElement).typeVariable(name));
    }

    private void handleWildcardType(WildcardType wildcardType) {
        TypeMirror typeMirror = wildcardType.getExtendsBound();
        if (typeMirror == null) {
            throw new UnambiguousTypeException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Client API system does not accept wildcard type without extends bound");
        }
        this.fillType(typeMirror);
    }

    private void handleIntersectionType(IntersectionType intersectionType) {
        this.fillType(intersectionType.getBounds().get(0));
    }

    private void handleArrayType(ArrayType arrayType) {
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        typeRef.setTypeName(TypeName.LIST);
        this.builder.typeRef(argument -> {
            this.fillType(arrayType.getComponentType());
            typeRef.addArgument(argument);
        });
    }

    private void handleDeclaredType(DeclaredType declaredType) {
        TypeRefImpl typeRef = (TypeRefImpl)this.builder.current();
        TypeName unboxedTypeName = ClientProcessor.unboxedTypeName(declaredType);
        if (unboxedTypeName != null) {
            typeRef.setTypeName(unboxedTypeName);
            return;
        }
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        if (typeElement.getNestingKind().isNested() && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new UnambiguousTypeException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Client API only accept top-level of static nested type");
        }
        TypeName typeName = ClientProcessor.typeName(typeElement);
        if (TypeName.OBJECT.equals((Object)typeName)) {
            throw new UnambiguousTypeException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Client API system does not accept unambiguous type `java.lang.Object`");
        }
        switch (typeName.toString()) {
            case "java.lang.Boolean": {
                typeName = TypeName.BOOLEAN;
                break;
            }
            case "java.lang.Character": {
                typeName = TypeName.CHAR;
                break;
            }
            case "java.lang.Byte": {
                typeName = TypeName.BYTE;
                break;
            }
            case "java.lang.Short": {
                typeName = TypeName.SHORT;
                break;
            }
            case "java.lang.Integer": {
                typeName = TypeName.INT;
                break;
            }
            case "java.lang.Long": {
                typeName = TypeName.LONG;
                break;
            }
            case "java.lang.Float": {
                typeName = TypeName.FLOAT;
                break;
            }
            case "java.lang.Double": {
                typeName = TypeName.DOUBLE;
            }
        }
        TypeRefImpl<Element> jsonValueTypeRef = this.jsonValueTypeRef(typeName);
        if (jsonValueTypeRef != null) {
            throw new JsonValueTypeChangeException(jsonValueTypeRef);
        }
        typeRef.setTypeName(typeName);
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            this.builder.typeRef(argument -> {
                this.fillType(typeMirror);
                typeRef.addArgument(argument);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeRefImpl<Element> jsonValueTypeRef(TypeName typeName) {
        TypeElement typeElement = this.context.getElements().getTypeElement(typeName.toString());
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement methodElement;
            if (element.getAnnotation(JsonValue.class) == null || element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC) || !(methodElement = (ExecutableElement)element).getParameters().isEmpty() || methodElement.getReturnType().getKind() == TypeKind.VOID) continue;
            if (!this.jsonValueTypeNameStack.add(typeName)) {
                throw new MetaException((Element)this.builder.ancestorSource(new Class[]{ApiOperationImpl.class, ApiParameterImpl.class}), (Element)this.builder.ancestorSource(new Class[0]), "Cannot resolve \"@" + JsonValue.class.getName() + "\" because of dead recursion: " + this.jsonValueTypeNameStack);
            }
            try {
                TypeRefImpl[] jsonValueTypRef = new TypeRefImpl[1];
                this.builder.typeRef(type -> {
                    this.fillType(methodElement.getReturnType());
                    jsonValueTypRef[0] = type;
                });
                TypeRefImpl typeRefImpl = jsonValueTypRef[0];
                return typeRefImpl;
            }
            finally {
                this.jsonValueTypeNameStack.remove(typeName);
            }
        }
        return null;
    }

    private void fillDefinition(TypeElement typeElement, boolean immutable) {
        ClientExceptionMetadata metadata;
        ClientException clientException;
        TypeDefinitionImpl typeDefinition = (TypeDefinitionImpl)this.builder.current();
        typeDefinition.setDoc(Doc.parse((String)this.context.getElements().getDocComment(typeElement)));
        if (typeElement.getKind() == ElementKind.ENUM) {
            this.fillEnumDefinition(typeElement);
            return;
        }
        typeDefinition.setApiIgnore(typeElement.getAnnotation(ApiIgnore.class) != null);
        if (immutable) {
            typeDefinition.setKind(TypeDefinition.Kind.IMMUTABLE);
        } else {
            typeDefinition.setKind(TypeDefinition.Kind.OBJECT);
        }
        if (!immutable || typeElement.getKind() == ElementKind.INTERFACE) {
            boolean isClientException = typeElement.getAnnotation(ClientException.class) != null;
            for (Element element : typeElement.getEnclosedElements()) {
                ConverterMetadata metadata2;
                ExecutableElement executableElement;
                if (!(element instanceof ExecutableElement) || !(executableElement = (ExecutableElement)element).getParameters().isEmpty() || executableElement.getModifiers().contains((Object)Modifier.STATIC) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getReturnType().getKind() == TypeKind.VOID || executableElement.getAnnotation(ApiIgnore.class) != null || executableElement.getAnnotation(JsonIgnore.class) != null) continue;
                String name = executableElement.getSimpleName().toString();
                if (executableElement.getReturnType().getKind() == TypeKind.BOOLEAN && name.length() > 2 && name.startsWith("is") && !Character.isLowerCase(name.charAt(2))) {
                    name = StringUtil.identifier((String[])new String[]{name.substring(2)});
                } else if (name.length() > 3 && name.startsWith("get") && !Character.isLowerCase(name.charAt(3))) {
                    name = StringUtil.identifier((String[])new String[]{name.substring(3)});
                } else if (!immutable) continue;
                if (isClientException && (name.equals("code") || name.equals("fields"))) continue;
                if (immutable) {
                    ConverterMetadata metadata3 = this.context.getImmutableType(typeElement).getProps().get(name).getConverterMetadata();
                } else {
                    metadata2 = null;
                }
                this.builder.prop((Object)executableElement, name, prop -> {
                    try {
                        this.builder.typeRef(type -> {
                            this.fillType(metadata2 != null ? metadata2.getTargetType() : executableElement.getReturnType());
                            this.setNullityByJetBrainsAnnotation((TypeRefImpl<Element>)type, executableElement, executableElement.getReturnType());
                            prop.setType(type);
                        });
                        prop.setDoc(Doc.parse((String)this.elements.getDocComment(executableElement)));
                        typeDefinition.addProp(prop);
                    }
                    catch (UnambiguousTypeException unambiguousTypeException) {
                        // empty catch block
                    }
                });
            }
            for (Element element : typeElement.getEnclosedElements()) {
                PropImpl prop2;
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || (prop2 = (PropImpl)typeDefinition.getPropMap().get(element.getSimpleName().toString())) == null) continue;
                if (element.getAnnotation(JsonIgnore.class) != null) {
                    typeDefinition.getPropMap().remove(element.getSimpleName().toString());
                }
                if (prop2.getDoc() != null) continue;
                prop2.setDoc(Doc.parse((String)this.context.getElements().getDocComment(element)));
            }
        }
        if ((clientException = typeElement.getAnnotation(ClientException.class)) != null && (metadata = this.clientExceptionContext.get(typeElement)).getCode() != null && !metadata.getCode().isEmpty()) {
            typeDefinition.setError(new TypeDefinition.Error(metadata.getFamily(), metadata.getCode()));
        }
        if (typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.INTERFACE) {
            TypeName typeName;
            Element superElement;
            if (typeElement.getSuperclass().getKind() != TypeKind.NONE && Annotations.annotationMirror(superElement = ((DeclaredType)typeElement.getSuperclass()).asElement(), ApiIgnore.class) == null && (typeName = ClientProcessor.typeName(superElement)).isGenerationRequired() && !typeName.equals((Object)CODE_BASED_EXCEPTION_NAME) && !typeName.equals((Object)CODE_BASED_RUNTIME_EXCEPTION_NAME)) {
                this.builder.typeRef(type -> {
                    this.fillType(typeElement.getSuperclass());
                    typeDefinition.addSuperType(type);
                });
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                TypeName superName2;
                Element superElement2 = ((DeclaredType)typeMirror).asElement();
                if (Annotations.annotationMirror(superElement2, ApiIgnore.class) != null || !(superName2 = ClientProcessor.typeName(superElement2)).isGenerationRequired() || superName2.equals((Object)CODE_BASED_EXCEPTION_NAME)) continue;
                this.builder.typeRef(type -> {
                    this.fillType(itf);
                    typeDefinition.addSuperType(type);
                });
            }
        }
    }

    private void fillEnumDefinition(TypeElement typeElement) {
        TypeDefinitionImpl definition = (TypeDefinitionImpl)this.builder.current();
        definition.setApiIgnore(typeElement.getAnnotation(ApiIgnore.class) != null);
        definition.setKind(TypeDefinition.Kind.ENUM);
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.builder.constant((Object)element, element.getSimpleName().toString(), constant -> {
                constant.setDoc(Doc.parse((String)this.context.getElements().getDocComment(constantElement)));
                definition.addEnumConstant(constant);
            });
        }
    }

    public boolean isApiService(Element element) {
        if (!(element instanceof TypeElement) || !this.context.include((TypeElement)element)) {
            return false;
        }
        if (element.getAnnotation(ApiIgnore.class) != null) {
            return false;
        }
        if (element.getAnnotation(Api.class) != null) {
            return true;
        }
        if (!this.explicitApi) {
            return false;
        }
        return Annotations.annotationMirror(element, "org.springframework.web.bind.annotation.RestController") != null;
    }

    public boolean isApiOperation(ExecutableElement element) {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        if (element.getAnnotation(ApiIgnore.class) != null) {
            return false;
        }
        if (element.getAnnotation(Api.class) != null) {
            return true;
        }
        if (!this.explicitApi) {
            return false;
        }
        return ApiOperation.AUTO_OPERATION_ANNOTATIONS.stream().anyMatch(it -> Annotations.annotationMirror((Element)element, it) != null);
    }

    private void setNullityByJetBrainsAnnotation(TypeRefImpl<Element> typeRef, Element element, TypeMirror rawType) {
        if (typeRef.isNullable()) {
            return;
        }
        boolean isPrimitive = typeRef.getTypeName().isPrimitive();
        boolean isRawTypePrimitive = rawType.getKind().isPrimitive();
        String nullableTypeName = null;
        String nonNullTypeName = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annoElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            String annoClassName = annoElement.getSimpleName().toString();
            String annoClassFullName = annoElement.getQualifiedName().toString();
            if (annoClassName.equals("Null") || annoClassName.equals("Nullable")) {
                if (isRawTypePrimitive) {
                    throw new MetaException((Element)this.builder.ancestorSource(new Class[0]), "Illegal annotation `@" + annoClassName + "` which cannot be used to decorate primitive type");
                }
                nullableTypeName = annoClassFullName;
                continue;
            }
            if (!annoClassName.equals("NotNull") && !annoClassName.equals("NonNull") || annoClassFullName.equals("javax.validation.constraints.NotNull") || annoClassFullName.equals("jakarta.validation.constraints.NotNull")) continue;
            if (isPrimitive && !isRawTypePrimitive) {
                throw new MetaException((Element)this.builder.ancestorSource(new Class[0]), "Illegal annotation `@" + annoClassName + "` which cannot be used to decorate boxed type of primitive type, please replace it to unboxed primitive type");
            }
            nonNullTypeName = annoClassFullName;
        }
        if (nullableTypeName != null && nonNullTypeName != null) {
            throw new MetaException(element, "Conflict nullity annotation \"@" + nullableTypeName + "\" and \"@" + nonNullTypeName + "\"");
        }
        if (nullableTypeName != null) {
            typeRef.setNullable(true);
        }
    }

    private static TypeName unboxedTypeName(TypeMirror type) {
        if (!(type instanceof DeclaredType)) {
            return null;
        }
        TypeElement element = (TypeElement)((DeclaredType)type).asElement();
        switch (element.getQualifiedName().toString()) {
            case "java.lang.Boolean": {
                return TypeName.BOOLEAN;
            }
            case "java.lang.Character": {
                return TypeName.CHAR;
            }
            case "java.lang.Byte": {
                return TypeName.BYTE;
            }
            case "java.lang.Short": {
                return TypeName.SHORT;
            }
            case "java.lang.Integer": {
                return TypeName.INT;
            }
            case "java.lang.Long": {
                return TypeName.LONG;
            }
            case "java.lang.Float": {
                return TypeName.FLOAT;
            }
            case "java.lang.Double": {
                return TypeName.DOUBLE;
            }
        }
        return null;
    }

    private static TypeName typeName(Element element) {
        ArrayList<String> simpleNames = new ArrayList<String>();
        String packageName = null;
        for (Element e = element; e != null; e = e.getEnclosingElement()) {
            if (e instanceof TypeElement) {
                simpleNames.add(e.getSimpleName().toString());
                continue;
            }
            if (!(e instanceof PackageElement)) break;
            packageName = ((PackageElement)e).getQualifiedName().toString();
        }
        Collections.reverse(simpleNames);
        return TypeName.of(packageName, simpleNames);
    }

    private static void removeOptional(TypeRefImpl<Element> typeRef) {
        if (typeRef.getTypeName().equals((Object)TypeName.OPTIONAL)) {
            TypeRefImpl target = (TypeRefImpl)typeRef.getArguments().get(0);
            typeRef.replaceBy(target, Boolean.valueOf(true));
        }
    }

    private static class JsonValueTypeChangeException
    extends RuntimeException {
        final TypeRefImpl<Element> typeRef;

        private JsonValueTypeChangeException(TypeRefImpl<Element> typeRef) {
            this.typeRef = typeRef;
        }
    }

    private static class UnambiguousTypeException
    extends MetaException {
        public UnambiguousTypeException(Element element, Element childElement, String reason) {
            super(element, childElement, reason);
        }
    }
}

