/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.client.ClientProcessor;
import org.babyfish.jimmer.apt.client.FetchByUnsupportedException;
import org.babyfish.jimmer.apt.dto.DtoProcessor;
import org.babyfish.jimmer.apt.entry.EntryProcessor;
import org.babyfish.jimmer.apt.error.ErrorProcessor;
import org.babyfish.jimmer.apt.immutable.ImmutableProcessor;
import org.babyfish.jimmer.client.EnableImplicitApi;
import org.babyfish.jimmer.client.FetchBy;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoUtils;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass", "org.babyfish.jimmer.sql.Embeddable", "org.babyfish.jimmer.sql.EnableDtoGeneration", "org.babyfish.jimmer.error.ErrorFamily", "org.babyfish.jimmer.client.Api", "org.springframework.web.bind.annotation.RestController"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JimmerProcessor
extends AbstractProcessor {
    private Context context;
    private Filer filer;
    private Elements elements;
    private Messager messager;
    private Collection<String> dtoDirs;
    private Collection<String> dtoTestDirs;
    private boolean checkedException;
    private boolean serverGenerated;
    private Boolean clientExplicitApi;
    private boolean clientGenerated;
    private List<String> delayedClientTypeNames;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        String[] includeArr = null;
        String[] excludeArr = null;
        if (includes != null && !includes.isEmpty()) {
            includeArr = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            excludeArr = excludes.trim().split("\\s*,\\s*");
        }
        this.dtoDirs = JimmerProcessor.dtoDirs(processingEnv, "jimmer.dto.dirs", "src/main/", Collections.singletonList("src/main/dto"));
        this.dtoTestDirs = JimmerProcessor.dtoDirs(processingEnv, "jimmer.dto.testDirs", "src/test/", Collections.singletonList("src/test/dto"));
        this.checkedException = "true".equals(processingEnv.getOptions().get("jimmer.client.checkedException"));
        this.context = new Context(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), "true".equals(processingEnv.getOptions().get("jimmer.keepIsPrefix")), includeArr, excludeArr);
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (this.clientExplicitApi == null) {
                this.clientExplicitApi = roundEnv.getRootElements().stream().anyMatch(it -> it instanceof TypeElement && this.context.include((TypeElement)it) && it.getAnnotation(EnableImplicitApi.class) != null);
            }
            if (!this.serverGenerated) {
                this.serverGenerated = true;
                Set<TypeElement> immutableTypeElements = new ImmutableProcessor(this.context, this.filer, this.messager).process(roundEnv).keySet();
                new EntryProcessor(this.context, immutableTypeElements, this.filer).process();
                boolean errorGenerated = new ErrorProcessor(this.context, this.checkedException, this.filer).process(roundEnv);
                boolean dtoGenerated = new DtoProcessor(this.context, this.elements, this.filer, this.isTest() ? this.dtoTestDirs : this.dtoDirs).process();
                if (!immutableTypeElements.isEmpty() || errorGenerated || dtoGenerated) {
                    this.delayedClientTypeNames = roundEnv.getRootElements().stream().filter(it -> it instanceof TypeElement).map(it -> ((TypeElement)it).getQualifiedName().toString()).collect(Collectors.toList());
                    return false;
                }
            }
            if (!this.clientGenerated) {
                this.clientGenerated = true;
                new ClientProcessor(this.context, this.elements, this.filer, this.clientExplicitApi, this.delayedClientTypeNames).process(roundEnv);
                this.delayedClientTypeNames = null;
            }
        }
        catch (MetaException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
        }
        catch (DtoAstException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        catch (FetchByUnsupportedException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "In order to parse the `@" + FetchBy.class.getName() + "` annotations that decorate generic type parameters, please make sure the java compiler version is 11 or higher (`source.version` and `target.version` can still remain `1.8`). However, once compilation is complete, you can still use Java 8 to deploy and run the project.");
        }
        return true;
    }

    private boolean isTest() {
        try {
            String path = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", "dummy.txt").toUri().getPath();
            return path.endsWith("/test/dummy.txt");
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot get the class output dir", ex);
        }
    }

    private static Collection<String> dtoDirs(ProcessingEnvironment env, String configurationName, String prefix, Collection<String> defaultDirs) {
        String dtoDirs = env.getOptions().get(configurationName);
        if (dtoDirs != null && !dtoDirs.isEmpty()) {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            for (String path : dtoDirs.trim().split("\\*[,:;]\\s*")) {
                if (path.isEmpty() || path.equals("/")) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty()) continue;
                dirs.add(path);
            }
            for (String dir : dirs) {
                if (dir.startsWith(prefix)) continue;
                throw new GeneratorException("Illegal annotation processor configuration \"" + configurationName + "\", it contains an illegal path \"" + dir + "\" which does not start with \"" + prefix + "\"", null);
            }
            return DtoUtils.standardDtoDirs(dirs);
        }
        return defaultDirs;
    }
}

