/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.entry.AbstractSummaryGenerator;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.util.ClassNames;

public class ObjectsGenerator
extends AbstractSummaryGenerator {
    private final String packageName;
    private final Collection<TypeElement> typeElements;
    private final Filer filer;

    public ObjectsGenerator(String packageName, Collection<TypeElement> typeElements, Filer filer) {
        this.packageName = packageName;
        this.typeElements = typeElements;
        this.filer = filer;
    }

    public void generate() {
        TypeSpec typeSpec = this.typeSpec();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.packageName + ".Objects"), ex);
        }
    }

    private TypeSpec typeSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)this.packageName, (String)"Objects", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeElement typeElement : this.typeElements) {
            String methodName = this.distinctName("create" + typeElement.getSimpleName().toString());
            builder.addMethod(this.creator(typeElement, methodName, false));
            builder.addMethod(this.creator(typeElement, methodName, true));
        }
        return builder.build();
    }

    private MethodSpec creator(TypeElement typeElement, String methodName, boolean withBase) {
        ClassName immutableClassName = ClassName.get((TypeElement)typeElement);
        ClassName draftClassName = ClassNames.of(typeElement, name -> name + "Draft");
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (withBase) {
            builder.addParameter((TypeName)immutableClassName, "base", new Modifier[0]);
        }
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{draftClassName}), "block", new Modifier[0]).returns((TypeName)ClassName.get((TypeElement)typeElement));
        if (withBase) {
            builder.addStatement("return $T.$$.produce(base, block)", new Object[]{draftClassName});
        } else {
            builder.addStatement("return $T.$$.produce(block)", new Object[]{draftClassName});
        }
        return builder.build();
    }
}

