/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.immutable.generator.DraftGenerator;
import org.babyfish.jimmer.apt.immutable.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.immutable.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.immutable.generator.PropsGenerator;
import org.babyfish.jimmer.apt.immutable.generator.TableGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;

public class ImmutableProcessor {
    private final Context context;
    private final Filer filer;
    private final Messager messager;

    public ImmutableProcessor(Context context, Filer filer, Messager messager) {
        this.context = context;
        this.filer = filer;
        this.messager = messager;
    }

    public Map<TypeElement, ImmutableType> process(RoundEnvironment roundEnv) {
        Map<TypeElement, ImmutableType> immutableTypeMap = this.parseImmutableTypes(roundEnv);
        this.generateJimmerTypes(immutableTypeMap);
        return immutableTypeMap;
    }

    private Map<TypeElement, ImmutableType> parseImmutableTypes(RoundEnvironment roundEnv) {
        HashMap<TypeElement, ImmutableType> map = new HashMap<TypeElement, ImmutableType>();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.context.isImmutable(typeElement = (TypeElement)element) || !this.context.include(typeElement)) continue;
            ImmutableType immutableType = this.context.getImmutableType(typeElement);
            map.put(typeElement, immutableType);
        }
        return map;
    }

    private void generateJimmerTypes(Map<TypeElement, ImmutableType> immutableTypeMap) {
        for (ImmutableType immutableType : immutableTypeMap.values()) {
            new DraftGenerator(immutableType, this.filer).generate();
            new PropsGenerator(this.context, immutableType, this.filer).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                new TableGenerator(this.context, immutableType, false, this.filer).generate();
                new TableGenerator(this.context, immutableType, true, this.filer).generate();
                new FetcherGenerator(this.context, immutableType, this.filer).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            new PropExpressionGenerator(this.context, immutableType, this.filer).generate();
        }
    }
}

