/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.entry.AbstractSummaryGenerator;
import org.babyfish.jimmer.apt.util.ClassNames;
import org.babyfish.jimmer.impl.util.StringUtil;

public class TablesGenerator
extends AbstractSummaryGenerator {
    private final String packageName;
    private final Collection<TypeElement> typeElements;
    private final Filer filer;
    private final boolean isEx;

    public TablesGenerator(String packageName, Collection<TypeElement> typeElements, Filer filer, boolean isEx) {
        this.packageName = packageName;
        this.typeElements = typeElements;
        this.filer = filer;
        this.isEx = isEx;
    }

    public void generate() {
        TypeSpec typeSpec = this.typeSpec();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.packageName + (this.isEx ? ".TableExes" : ".Tables")), ex);
        }
    }

    private TypeSpec typeSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)this.packageName, (String)(this.isEx ? "TableExes" : "Tables"), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeElement typeElement : this.typeElements) {
            builder.addField(this.field(typeElement));
        }
        return builder.build();
    }

    private FieldSpec field(TypeElement typeElement) {
        String suffix = this.isEx ? "TableEx" : "Table";
        ClassName tableClassName = ClassNames.of(typeElement, name -> name + suffix);
        return FieldSpec.builder((TypeName)tableClassName, (String)this.distinctName(StringUtil.snake((String)(typeElement.getSimpleName().toString() + suffix), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$$", new Object[]{tableClassName}).build();
    }
}

