/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.meta;

import com.squareup.javapoet.ClassName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ValidationMessages;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Version;

public class ImmutableType
implements BaseType {
    public static final String PROP_EXPRESSION_SUFFIX = "PropExpression";
    private static final String FORMULA_CLASS_NAME = Formula.class.getName();
    private final TypeElement typeElement;
    private final boolean isEntity;
    private final boolean isMappedSuperClass;
    private final boolean isEmbeddable;
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final Set<Modifier> modifiers;
    private final ImmutableType primarySuperType;
    private final Set<ImmutableType> superTypes;
    private final Map<String, ImmutableProp> declaredProps;
    private final Map<String, ImmutableProp> redefinedProps;
    private Map<String, ImmutableProp> props;
    private Map<String, String> idPropNameMap;
    private List<ImmutableProp> propsOrderById;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private ImmutableProp logicalDeletedProp;
    private final ClassName className;
    private final ClassName draftClassName;
    private final ClassName producerClassName;
    private final ClassName implementorClassName;
    private final ClassName implClassName;
    private final ClassName draftImplClassName;
    private final ClassName mapStructClassName;
    private final ClassName tableClassName;
    private final ClassName tableExClassName;
    private final ClassName remoteTableClassName;
    private final ClassName fetcherClassName;
    private final ClassName propsClassName;
    private final ClassName propExpressionClassName;
    private final ClassName dynamicClassName;
    private final Map<ClassName, String> validationMessageMap;
    private final boolean acrossMicroServices;
    private final String microServiceName;

    /*
     * WARNING - void declaration
     */
    public ImmutableType(Context context, TypeElement typeElement) {
        void var7_20;
        this.typeElement = typeElement;
        Class<? extends Annotation> annotationType = context.getImmutableAnnotationType(typeElement);
        this.isEntity = annotationType == Entity.class;
        boolean bl = this.acrossMicroServices = annotationType == MappedSuperclass.class && typeElement.getAnnotation(MappedSuperclass.class).acrossMicroServices();
        String string = this.isEntity ? typeElement.getAnnotation(Entity.class).microServiceName() : (this.microServiceName = annotationType == MappedSuperclass.class ? typeElement.getAnnotation(MappedSuperclass.class).microServiceName() : "");
        if (this.acrossMicroServices && !this.microServiceName.isEmpty()) {
            throw new MetaException(typeElement, "the `acrossMicroServices` of its annotation \"@" + MappedSuperclass.class.getName() + "\" is true so that `microServiceName` cannot be specified");
        }
        this.isMappedSuperClass = annotationType == MappedSuperclass.class;
        this.isEmbeddable = annotationType == Embeddable.class;
        this.packageName = ((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString();
        this.name = typeElement.getSimpleName().toString();
        this.qualifiedName = typeElement.getQualifiedName().toString();
        this.modifiers = typeElement.getModifiers();
        ImmutableType primarySuperType = null;
        LinkedHashSet<ImmutableType> superTypes = new LinkedHashSet<ImmutableType>();
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!context.isImmutable(typeMirror)) continue;
            ImmutableType superType = context.getImmutableType(typeMirror);
            superTypes.add(superType);
            if (superType.isMappedSuperClass) continue;
            if (primarySuperType == null) {
                primarySuperType = superType;
                continue;
            }
            throw new MetaException(typeElement, "there can be at most one primary superclass not decorated by @MappedSuperclass");
        }
        if (!superTypes.isEmpty()) {
            if (this.isEntity || this.isMappedSuperClass) {
                for (ImmutableType immutableType : superTypes) {
                    if (immutableType.isEntity) {
                        if (!this.isMappedSuperClass) continue;
                        throw new MetaException(typeElement, "mapped super class cannot inherit entity type");
                    }
                    if (immutableType.isMappedSuperClass) continue;
                    throw new MetaException(typeElement, "its super type \"" + immutableType + "\"" + (this.isEntity ? "is neither entity nor mapped super class" : "is not mapped super class"));
                }
            } else {
                if (this.isEmbeddable) {
                    throw new MetaException(typeElement, "embedded type does not support inheritance");
                }
                if (superTypes.size() > 1) {
                    throw new MetaException(typeElement, "simple immutable type does not support multiple inheritance");
                }
                for (ImmutableType immutableType : superTypes) {
                    if (!immutableType.isEntity && !immutableType.isMappedSuperClass && !immutableType.isEmbeddable) continue;
                    throw new MetaException(typeElement, "simple immutable type can only inherit simple immutable type");
                }
            }
        }
        for (ImmutableType immutableType : superTypes) {
            if (immutableType.isAcrossMicroServices() || immutableType.microServiceName.equals(this.microServiceName)) continue;
            throw new MetaException(typeElement, "its micro service name is \"" + this.microServiceName + "\" but the micro service name of its super type \"" + immutableType.getQualifiedName() + "\" is \"" + immutableType.microServiceName + "\"");
        }
        this.primarySuperType = primarySuperType;
        this.superTypes = superTypes;
        for (ImmutableType immutableType : superTypes) {
            if (immutableType.isMappedSuperClass) continue;
            primarySuperType = immutableType;
            break;
        }
        LinkedHashMap<String, ImmutableProp> superPropMap = new LinkedHashMap<String, ImmutableProp>();
        for (ImmutableType superType : superTypes) {
            for (ImmutableProp prop : superType.getProps().values()) {
                ImmutableProp conflictProp = superPropMap.put(prop.getName(), prop);
                if (conflictProp == null) continue;
                if (conflictProp.getGetterName().equals(prop.getGetterName())) {
                    throw new MetaException(typeElement, "There are two super properties with the same name: \"" + conflictProp + "\" and \"" + prop + "\", but their java getter name are different");
                }
                if (conflictProp.getReturnType().equals(prop.getReturnType())) continue;
                throw new MetaException(typeElement, "There are two super properties with the same name: \"" + conflictProp + "\" and \"" + prop + "\", but their return type are different");
            }
        }
        if (primarySuperType == null) {
            LinkedHashMap<String, ImmutableProp> linkedHashMap = superPropMap;
        } else {
            LinkedHashMap linkedHashMap = new LinkedHashMap(superPropMap);
            linkedHashMap.keySet().removeAll(primarySuperType.getProps().keySet());
        }
        int propIdSequence = primarySuperType != null ? primarySuperType.getProps().size() : 0;
        LinkedHashMap<String, ImmutableProp> redefinedPropMap = new LinkedHashMap<String, ImmutableProp>((var7_20.size() * 4 + 2) / 3);
        LinkedHashMap<String, ImmutableProp> declaredPropMap = primarySuperType != null ? new LinkedHashMap<String, ImmutableProp>(primarySuperType.getProps()) : new LinkedHashMap();
        ArrayList<ExecutableElement> executableElements = new ArrayList<ExecutableElement>();
        for (ImmutableProp immutableProp : var7_20.values()) {
            executableElements.add(immutableProp.toElement());
            ImmutableProp immutableProp2 = new ImmutableProp(context, this, immutableProp.toElement(), propIdSequence++);
            redefinedPropMap.put(immutableProp2.getName(), immutableProp2);
        }
        for (int i = 0; i < 2; ++i) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                ImmutableProp immutableProp;
                ImmutableProp conflictProp;
                if (executableElement.getAnnotation(Id.class) != null != (i == 0)) continue;
                if (superPropMap.containsKey(executableElement.getSimpleName().toString())) {
                    throw new MetaException(executableElement, "it overrides property of super type, this is not allowed");
                }
                executableElements.add(executableElement);
                if ((conflictProp = declaredPropMap.put((immutableProp = new ImmutableProp(context, this, executableElement, propIdSequence++)).getName(), immutableProp)) == null) continue;
                throw new MetaException(immutableProp.toElement(), "Conflict java methods: " + immutableProp.getGetterName() + " and " + conflictProp.getGetterName());
            }
        }
        for (ExecutableElement executableElement : executableElements) {
            if (!executableElement.isDefault()) continue;
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                if (!qualifiedName.startsWith("org.babyfish.jimmer.") || qualifiedName.equals(FORMULA_CLASS_NAME)) continue;
                throw new MetaException(executableElement, "it is default method so that it cannot be decorated by any jimmer annotations except @" + FORMULA_CLASS_NAME);
            }
        }
        for (ExecutableElement executableElement : executableElements) {
            Formula formula;
            if (executableElement.isDefault()) {
                Formula formula2 = executableElement.getAnnotation(Formula.class);
                if (formula2 == null) continue;
                if (!formula2.sql().isEmpty()) {
                    throw new MetaException(executableElement, "it is non-abstract and decorated by @" + Formula.class.getName() + ", non-abstract modifier means simple calculation property based on java expression so that the `sql` of that annotation cannot be specified");
                }
                if (formula2.dependencies().length != 0) continue;
                throw new MetaException(executableElement, "it is non-abstract and decorated by @" + Formula.class.getName() + ", non-abstract modifier means simple calculation property based on java expression so that the `dependencies` of that annotation must be specified");
            }
            if (executableElement.getAnnotation(Id.class) != null || (formula = executableElement.getAnnotation(Formula.class)) == null) continue;
            if (formula.sql().isEmpty()) {
                throw new MetaException(executableElement, "it is abstract and decorated by @" + Formula.class.getName() + ", abstract modifier means simple calculation property based on SQL expression so that the `sql` of that annotation must be specified");
            }
            if (formula.dependencies().length == 0) continue;
            throw new MetaException(executableElement, "it is abstract and decorated by @" + Formula.class.getName() + ", abstract modifier means simple calculation property based on SQL expression so that the `dependencies` of that annotation cannot be specified");
        }
        this.declaredProps = Collections.unmodifiableMap(declaredPropMap);
        this.redefinedProps = Collections.unmodifiableMap(redefinedPropMap);
        List idProps = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Id.class) != null).collect(Collectors.toList());
        List list = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Version.class) != null).collect(Collectors.toList());
        List list2 = this.declaredProps.values().stream().filter(it -> it.getAnnotation(LogicalDeleted.class) != null).collect(Collectors.toList());
        for (ImmutableType superType : superTypes) {
            if (superType.getIdProp() != null && !idProps.isEmpty()) {
                throw new MetaException(typeElement, idProps.get(0) + "\" cannot be decorated by `@" + Id.class.getName() + "` because id has been declared in super type");
            }
            if (superType.getVersionProp() != null && !list.isEmpty()) {
                throw new MetaException(typeElement, list.get(0) + "\" cannot be decorated by `@" + Version.class.getName() + "` because version has been declared in super type");
            }
            if (superType.getLogicalDeletedProp() != null && !list2.isEmpty()) {
                throw new MetaException(typeElement, list2.get(0) + "\" cannot be decorated by `@" + LogicalDeleted.class.getName() + "` because version has been declared in super type");
            }
            if (this.idProp == null) {
                this.idProp = superType.idProp;
            }
            if (this.versionProp == null) {
                this.versionProp = superType.versionProp;
            }
            if (this.logicalDeletedProp != null) continue;
            this.logicalDeletedProp = superType.logicalDeletedProp;
        }
        if (!this.isEntity && !this.isMappedSuperClass) {
            if (!idProps.isEmpty()) {
                throw new MetaException(typeElement, idProps.get(0) + "\" cannot be decorated by `@" + Id.class.getName() + "` because current type is not entity");
            }
            if (!list.isEmpty()) {
                throw new MetaException(typeElement, list.get(0) + "\" cannot be decorated by `@" + Version.class.getName() + "` because current type is not entity");
            }
            if (!list2.isEmpty()) {
                throw new MetaException(typeElement, list2.get(0) + "\" cannot be decorated by `@" + LogicalDeleted.class.getName() + "` because current type is not entity");
            }
        } else {
            if (idProps.size() > 1) {
                throw new MetaException(typeElement, "multiple id properties are not supported, but both \"" + idProps.get(0) + "\" and \"" + idProps.get(1) + "\" is decorated by `@" + LogicalDeleted.class.getName() + "`");
            }
            if (list.size() > 1) {
                throw new MetaException(typeElement, "multiple version properties are not supported, but both \"" + list.get(0) + "\" and \"" + list.get(1) + "\" is decorated by `@" + Version.class.getName() + "`");
            }
            if (list2.size() > 1) {
                throw new MetaException(typeElement, "multiple logical deleted properties are not supported, but both \"" + list2.get(0) + "\" and \"" + list2.get(1) + "\" is decorated by `@" + LogicalDeleted.class.getName() + "`");
            }
            if (this.idProp == null) {
                if (this.isEntity && idProps.isEmpty()) {
                    throw new MetaException(typeElement, "entity type must have an id property");
                }
                if (!idProps.isEmpty()) {
                    this.idProp = (ImmutableProp)idProps.get(0);
                }
            }
            if (this.idProp != null && this.idProp.isAssociation(true)) {
                throw new MetaException(typeElement, "association cannot be id property");
            }
            if (this.versionProp == null && !list.isEmpty()) {
                this.versionProp = (ImmutableProp)list.get(0);
                if (this.versionProp.isAssociation(false)) {
                    throw new MetaException(typeElement, "association cannot be version property");
                }
            }
            if (this.logicalDeletedProp == null && !list2.isEmpty()) {
                this.logicalDeletedProp = (ImmutableProp)list2.get(0);
                if (this.logicalDeletedProp.isAssociation(false)) {
                    throw new MetaException(typeElement, "it contains illegal property \"" + list2 + "\", association cannot be logical deleted property");
                }
            }
        }
        this.className = this.toClassName(null, new String[0]);
        this.draftClassName = this.toClassName(name -> name + "Draft", new String[0]);
        this.producerClassName = this.toClassName(name -> name + "Draft", "Producer");
        this.implementorClassName = this.toClassName(name -> name + "Draft", "Producer", "Implementor");
        this.implClassName = this.toClassName(name -> name + "Draft", "Producer", "Impl");
        this.draftImplClassName = this.toClassName(name -> name + "Draft", "Producer", "DraftImpl");
        this.mapStructClassName = this.toClassName(name -> name + "Draft", "MapStruct");
        this.tableClassName = this.toClassName(name -> name + "Table", new String[0]);
        this.tableExClassName = this.toClassName(name -> name + "TableEx", new String[0]);
        this.remoteTableClassName = this.toClassName(name -> name + "Table", "Remote");
        this.fetcherClassName = this.toClassName(name -> name + "Fetcher", new String[0]);
        this.propsClassName = this.toClassName(name -> name + "Props", new String[0]);
        this.propExpressionClassName = this.toClassName(name -> name + PROP_EXPRESSION_SUFFIX, new String[0]);
        this.dynamicClassName = this.toClassName(name -> "Dynamic" + name, new String[0]);
        this.validationMessageMap = ValidationMessages.parseMessageMap(typeElement);
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public boolean isMappedSuperClass() {
        return this.isMappedSuperClass;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isAcrossMicroServices() {
        return this.acrossMicroServices;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public Set<ImmutableType> getSuperTypes() {
        return this.superTypes;
    }

    public ImmutableType getPrimarySuperType() {
        return this.primarySuperType;
    }

    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    public Map<String, ImmutableProp> getRedefinedProps() {
        return this.redefinedProps;
    }

    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superTypes.isEmpty()) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>();
                for (ImmutableType superType : this.superTypes) {
                    for (ImmutableProp prop : superType.getProps().values()) {
                        if (prop.getAnnotation(Id.class) == null) continue;
                        props.put(prop.getName(), prop);
                    }
                }
                for (ImmutableProp prop : this.redefinedProps.values()) {
                    if (prop.getAnnotation(Id.class) == null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableProp prop : this.declaredProps.values()) {
                    if (prop.getAnnotation(Id.class) == null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableType superType : this.superTypes) {
                    for (ImmutableProp prop : superType.getProps().values()) {
                        if (prop.getAnnotation(Id.class) != null) continue;
                        props.put(prop.getName(), prop);
                    }
                }
                for (ImmutableProp prop : this.redefinedProps.values()) {
                    if (prop.getAnnotation(Id.class) != null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableProp prop : this.declaredProps.values()) {
                    if (prop.getAnnotation(Id.class) != null) continue;
                    props.put(prop.getName(), prop);
                }
            }
            this.props = Collections.unmodifiableMap(props);
        }
        return props;
    }

    public String getIdPropName(String prop) {
        return this.getIdPropNameMap().get(prop);
    }

    private Map<String, String> getIdPropNameMap() {
        Map<String, String> map = this.idPropNameMap;
        if (map == null) {
            map = new HashMap<String, String>();
            for (ImmutableProp prop : this.props.values()) {
                ImmutableProp baseProp = prop.getIdViewBaseProp();
                if (baseProp == null) continue;
                map.put(baseProp.getName(), prop.getName());
            }
            for (ImmutableProp prop : this.props.values()) {
                if (prop.isReverse() || prop.getAnnotation(OneToOne.class) == null && prop.getAnnotation(ManyToOne.class) == null || map.containsKey(prop.getName())) continue;
                String expectedPropName = prop.getName() + "Id";
                ImmutableProp expectedProp = this.getProps().get(expectedPropName);
                if (expectedProp != null) {
                    throw new MetaException(expectedProp.toElement(), "It looks like @IdView of association \"" + prop + "\", please add the @IdView annotation");
                }
                map.put(prop.getName(), expectedPropName);
            }
            this.idPropNameMap = map;
        }
        return map;
    }

    public List<ImmutableProp> getPropsOrderById() {
        List<ImmutableProp> list = this.propsOrderById;
        if (list == null) {
            this.propsOrderById = list = this.getProps().values().stream().sorted(Comparator.comparing(ImmutableProp::getId)).collect(Collectors.toList());
        }
        return list;
    }

    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    public ImmutableProp getLogicalDeletedProp() {
        return this.logicalDeletedProp;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getDraftClassName() {
        return this.draftClassName;
    }

    public ClassName getProducerClassName() {
        return this.producerClassName;
    }

    public ClassName getImplementorClassName() {
        return this.implementorClassName;
    }

    public ClassName getImplClassName() {
        return this.implClassName;
    }

    public ClassName getDraftImplClassName() {
        return this.draftImplClassName;
    }

    public ClassName getMapStructClassName() {
        return this.mapStructClassName;
    }

    public ClassName getTableClassName() {
        return this.tableClassName;
    }

    public ClassName getTableExClassName() {
        return this.tableExClassName;
    }

    public ClassName getRemoteTableClassName() {
        return this.remoteTableClassName;
    }

    public ClassName getFetcherClassName() {
        return this.fetcherClassName;
    }

    public ClassName getPropsClassName() {
        return this.propsClassName;
    }

    public ClassName getPropExpressionClassName() {
        return this.propExpressionClassName;
    }

    public ClassName getDynamicClassName() {
        return this.dynamicClassName;
    }

    private ClassName toClassName(Function<String, String> transform, String ... moreSimpleNames) {
        return ClassName.get((String)this.packageName, (String)(transform != null ? transform.apply(this.name) : this.name), (String[])moreSimpleNames);
    }

    public Map<ClassName, String> getValidationMessageMap() {
        return this.validationMessageMap;
    }

    public String getMicroServiceName() {
        return this.microServiceName;
    }

    public String toString() {
        return this.typeElement.getQualifiedName().toString();
    }
}

