/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.util;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.babyfish.jimmer.apt.MetaException;

public class GenericParser {
    private final String name;
    private final TypeElement element;
    private final String superName;
    private final Map<TypeVariable, TypeMirror> replaceMap = new HashMap<TypeVariable, TypeMirror>();

    public GenericParser(String name, TypeElement element, String superName) {
        if (!element.getTypeParameters().isEmpty()) {
            throw new IllegalArgumentException("element cannot have type parameters");
        }
        this.name = name.toLowerCase();
        this.element = element;
        this.superName = superName;
    }

    public List<TypeName> parse() {
        try {
            this.parse((DeclaredType)this.element.asType());
        }
        catch (Finished ex) {
            return ex.arguments;
        }
        throw new MetaException(this.element, "it does not specify the arguments for \"" + this.superName + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private void parse(DeclaredType type) throws Finished {
        TypeMirror superType;
        TypeElement typeElement = (TypeElement)type.asElement();
        List<? extends TypeMirror> arguments = type.getTypeArguments();
        if (typeElement.getQualifiedName().toString().equals(this.superName)) {
            if (arguments.isEmpty()) {
                throw new MetaException(this.element, "The " + this.name + " type \"" + typeElement + "\" does not specify type arguments for \"" + this.superName + "\"");
            }
            throw new Finished(arguments.stream().map(this::resolve).collect(Collectors.toList()));
        }
        if (!arguments.isEmpty()) {
            void var6_8;
            List<? extends TypeParameterElement> parameters = typeElement.getTypeParameters();
            int size = arguments.size();
            boolean bl = false;
            while (var6_8 < size) {
                this.replaceMap.put((TypeVariable)parameters.get((int)var6_8).asType(), arguments.get((int)var6_8));
                ++var6_8;
            }
        }
        if ((superType = typeElement.getSuperclass()) instanceof DeclaredType) {
            this.parse((DeclaredType)superType);
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            this.parse((DeclaredType)typeMirror);
        }
    }

    private TypeName resolve(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            ClassName className = ClassName.bestGuess((String)typeElement.getQualifiedName().toString());
            List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
            if (!arguments.isEmpty()) {
                TypeName[] argTypeNames = new TypeName[arguments.size()];
                for (int i = arguments.size() - 1; i >= 0; --i) {
                    argTypeNames[i] = this.resolve(arguments.get(i));
                }
                return ParameterizedTypeName.get((ClassName)className, (TypeName[])argTypeNames);
            }
            return className;
        }
        if (type instanceof TypeVariable) {
            return this.resolve((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getSuperBound() != null) {
                return WildcardTypeName.supertypeOf((TypeName)this.resolve(wildcardType.getSuperBound()));
            }
            return WildcardTypeName.subtypeOf((TypeName)(wildcardType.getExtendsBound() != null ? this.resolve(wildcardType.getExtendsBound()) : TypeName.OBJECT));
        }
        if (type instanceof ArrayType) {
            return ArrayTypeName.of((TypeName)this.resolve(((ArrayType)type).getComponentType()));
        }
        throw new MetaException(this.element, "cannot resolve \"" + type + "\"");
    }

    private TypeName resolve(TypeVariable typeVariable) {
        TypeMirror type = this.replaceMap.get(typeVariable);
        if (type == null) {
            throw new MetaException(this.element, "cannot resolve \"" + typeVariable + "\"");
        }
        return this.resolve(type);
    }

    private static class Finished
    extends Exception {
        final List<TypeName> arguments;

        private Finished(List<TypeName> arguments) {
            this.arguments = arguments;
        }
    }
}

