/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.util;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.util.GenericParser;
import org.babyfish.jimmer.jackson.Converter;

public class ConverterMetadata {
    private final TypeName sourceTypeName;
    private final TypeName targetTypeName;

    public static ConverterMetadata of(TypeElement converterElement) {
        if (!converterElement.getTypeParameters().isEmpty()) {
            throw new MetaException(converterElement, "It should not have type parameters");
        }
        List<TypeName> arguments = new GenericParser("converter", converterElement, Converter.class.getName()).parse();
        return new ConverterMetadata(arguments.get(0), arguments.get(1));
    }

    public ConverterMetadata(TypeName sourceTypeName, TypeName targetTypeName) {
        this.sourceTypeName = sourceTypeName;
        this.targetTypeName = targetTypeName;
    }

    public TypeName getSourceTypeName() {
        return this.sourceTypeName;
    }

    public TypeName getTargetTypeName() {
        return this.targetTypeName;
    }

    public ConverterMetadata toListMetadata() {
        return new ListMetadata();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConverterMetadata metadata = (ConverterMetadata)o;
        if (!this.sourceTypeName.equals((Object)metadata.sourceTypeName)) {
            return false;
        }
        return this.targetTypeName.equals((Object)metadata.targetTypeName);
    }

    public int hashCode() {
        int result = this.sourceTypeName.hashCode();
        result = 31 * result + this.targetTypeName.hashCode();
        return result;
    }

    public String toString() {
        return "ConverterMetadata{sourceTypeName=" + this.sourceTypeName + ", targetTypeName=" + this.targetTypeName + '}';
    }

    private class ListMetadata
    extends ConverterMetadata {
        public ListMetadata() {
            super((TypeName)ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{ConverterMetadata.this.sourceTypeName}), (TypeName)ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{ConverterMetadata.this.targetTypeName}));
        }

        @Override
        public ConverterMetadata toListMetadata() {
            throw new UnsupportedOperationException("The current object is already list metadata");
        }
    }
}

