/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.dto.DtoException;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.jetbrains.annotations.NotNull;

public class DtoContext {
    private final Filer filer;
    private final List<DtoFile> dtoFiles;

    public DtoContext(Filer filer, Collection<String> dtoDirs) {
        this.filer = filer;
        DtoDirInfo dtoDirInfo = this.getDtoDirInfo(dtoDirs);
        ArrayList<DtoFile> dtoFiles = new ArrayList<DtoFile>();
        for (Map.Entry<String, File> e : dtoDirInfo.dtoDirFileMap.entrySet()) {
            File[] subFiles = e.getValue().listFiles();
            if (subFiles == null) continue;
            for (File subFile : subFiles) {
                DtoContext.collectDtoFiles(dtoDirInfo.projectDir, e.getKey(), subFile, new ArrayList<String>(), dtoFiles);
            }
        }
        this.dtoFiles = dtoFiles;
    }

    public List<DtoFile> getDtoFiles() {
        return Collections.unmodifiableList(this.dtoFiles);
    }

    private DtoDirInfo getDtoDirInfo(Collection<String> dtoDirs) {
        File baseFile;
        String basePath;
        try {
            basePath = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", "dummy.txt").toUri().getPath();
        }
        catch (IOException ex) {
            throw new DtoException("Failed to guess base project dir", ex);
        }
        if (basePath.startsWith("file:")) {
            basePath = basePath.substring(5);
        }
        if (File.separatorChar != '\\' && !basePath.startsWith("/")) {
            basePath = '/' + basePath;
        }
        basePath = basePath.substring(0, basePath.lastIndexOf(47));
        try {
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)"UTF-8 is not supported by url decoder");
        }
        if (!baseFile.exists()) {
            throw new AssertionError((Object)("The target directory \"" + basePath + "\" does not exists"));
        }
        LinkedHashMap<String, File> dtoDirFileMap = new LinkedHashMap<String, File>();
        String projectDir = null;
        for (baseFile = new File(URLDecoder.decode(basePath, "utf-8")); baseFile != null; baseFile = baseFile.getParentFile()) {
            String prjDir = DtoContext.collectDtoDirFiles(baseFile, dtoDirs, dtoDirFileMap);
            if (projectDir != null) continue;
            projectDir = prjDir;
        }
        return new DtoDirInfo(projectDir, dtoDirFileMap);
    }

    private static String collectDtoDirFiles(@NotNull File baseFile, Collection<String> dtoDirs, Map<String, File> dtoDirFileMap) {
        String projectDir = null;
        for (String dtoDir : dtoDirs) {
            File subFile = baseFile;
            for (String part : dtoDir.split("/")) {
                if ((subFile = new File(subFile, part)).isDirectory()) continue;
                subFile = null;
                break;
            }
            if (subFile == null) continue;
            dtoDirFileMap.put(dtoDir, subFile);
            projectDir = baseFile.getName();
        }
        return projectDir;
    }

    private static void collectDtoFiles(String projectDir, String dtoDir, File file, List<String> paths, List<DtoFile> dtoFiles) {
        if (file.isFile() && file.getName().endsWith(".dto")) {
            dtoFiles.add(new DtoFile(projectDir, dtoDir, paths, file.getName(), () -> new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)));
        } else {
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                paths.add(file.getName());
                for (File subFile : subFiles) {
                    DtoContext.collectDtoFiles(projectDir, dtoDir, subFile, paths, dtoFiles);
                }
                paths.remove(paths.size() - 1);
            }
        }
    }

    private static class DtoDirInfo {
        final String projectDir;
        final Map<String, File> dtoDirFileMap;

        DtoDirInfo(String projectDir, Map<String, File> dtoDirFileMap) {
            this.projectDir = projectDir;
            this.dtoDirFileMap = dtoDirFileMap;
        }
    }
}

