/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.client.ClientProcessor;
import org.babyfish.jimmer.apt.dto.DtoProcessor;
import org.babyfish.jimmer.apt.entry.EntryProcessor;
import org.babyfish.jimmer.apt.error.ErrorProcessor;
import org.babyfish.jimmer.apt.immutable.ImmutableProcessor;
import org.babyfish.jimmer.client.EnableImplicitApi;
import org.babyfish.jimmer.dto.compiler.DtoUtils;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass", "org.babyfish.jimmer.sql.Embeddable", "org.babyfish.jimmer.sql.EnableDtoGeneration", "org.babyfish.jimmer.error.ErrorFamily", "org.babyfish.jimmer.client.Api", "org.springframework.web.bind.annotation.RestController"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JimmerProcessor
extends AbstractProcessor {
    private Context context;
    private Filer filer;
    private Elements elements;
    private Messager messager;
    private Collection<String> dtoDirs;
    private boolean checkedException;
    private boolean serverGenerated;
    private Boolean clientExplicitApi;
    private boolean clientGenerated;
    private List<String> delayedClientTypeNames;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        String dtoDirs = processingEnv.getOptions().get("jimmer.dto.dirs");
        String[] includeArr = null;
        String[] excludeArr = null;
        if (includes != null && !includes.isEmpty()) {
            includeArr = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            excludeArr = excludes.trim().split("\\s*,\\s*");
        }
        if (dtoDirs != null && !dtoDirs.isEmpty()) {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            for (String path : dtoDirs.trim().split("\\*[,:;]\\s*")) {
                if (path.isEmpty() || path.equals("/")) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty()) continue;
                dirs.add(path);
            }
            this.dtoDirs = DtoUtils.standardDtoDirs(dirs);
        } else {
            this.dtoDirs = Collections.singletonList("src/main/dto");
        }
        this.checkedException = "true".equals(processingEnv.getOptions().get("jimmer.checkedException"));
        this.context = new Context(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), "true".equals(processingEnv.getOptions().get("jimmer.keepIsPrefix")), includeArr, excludeArr);
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (this.clientExplicitApi == null) {
                this.clientExplicitApi = roundEnv.getRootElements().stream().anyMatch(it -> it instanceof TypeElement && this.context.include((TypeElement)it) && it.getAnnotation(EnableImplicitApi.class) != null);
            }
            if (!this.serverGenerated) {
                this.serverGenerated = true;
                Set<TypeElement> immutableTypeElements = new ImmutableProcessor(this.context, this.filer, this.messager).process(roundEnv).keySet();
                new EntryProcessor(this.context, immutableTypeElements, this.filer).process();
                boolean errorGenerated = new ErrorProcessor(this.context, this.checkedException, this.filer).process(roundEnv);
                boolean dtoGenerated = new DtoProcessor(this.context, this.elements, this.filer, this.dtoDirs).process();
                if (errorGenerated || dtoGenerated) {
                    this.delayedClientTypeNames = roundEnv.getRootElements().stream().filter(it -> it instanceof TypeElement).map(it -> ((TypeElement)it).getQualifiedName().toString()).collect(Collectors.toList());
                    return false;
                }
            }
            if (!this.clientGenerated) {
                this.clientGenerated = true;
                new ClientProcessor(this.context, this.elements, this.filer, this.clientExplicitApi, this.delayedClientTypeNames).process(roundEnv);
                this.delayedClientTypeNames = null;
            }
        }
        catch (MetaException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
        }
        return true;
    }
}

