/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.AptDtoCompiler;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.DtoException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.DtoGenerator;
import org.babyfish.jimmer.apt.generator.ErrorGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.JimmerModuleGenerator;
import org.babyfish.jimmer.apt.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.error.ErrorFamily;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass", "org.babyfish.jimmer.error.ErrorFamily"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private Context context;
    private Filer filer;
    private String[] includes = null;
    private String[] excludes = null;
    private Messager messager;
    private final Set<TypeElement> processedTypeElements = new TreeSet<TypeElement>(Comparator.comparing(it -> it.getQualifiedName().toString()));
    private boolean jimmerModuleGenerated;
    private Set<String> dtoDirs;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        String dtoDirs = processingEnv.getOptions().get("jimmer.dto.dirs");
        if (includes != null && !includes.isEmpty()) {
            this.includes = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = excludes.trim().split("\\s*,\\s*");
        }
        if (dtoDirs != null && !dtoDirs.isEmpty()) {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            for (String path : dtoDirs.trim().split("\\*[,:;]\\s*")) {
                if (path.isEmpty() || path.equals("/")) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty()) continue;
                dirs.add(path);
            }
            this.dtoDirs = dirs;
        } else {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            dirs.add("src/main/dto");
            this.dtoDirs = dirs;
        }
        this.context = new Context(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), "true".equals(processingEnv.getOptions().get("jimmer.keepIsPrefix")));
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean go = false;
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.processedTypeElements.add((TypeElement)element)) continue;
            go = true;
        }
        if (!go) {
            return true;
        }
        try {
            Map<TypeElement, ImmutableType> immutableTypeMap = this.parseImmutableTypes(roundEnv);
            Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> map = this.parseDtoTypes(immutableTypeMap.values());
            this.generateJimmerTypes(roundEnv.getRootElements().stream().filter(it -> it instanceof TypeElement).map(immutableTypeMap::get).filter(Objects::nonNull).collect(Collectors.toList()), roundEnv);
            this.generateDtoTypes(map);
            List<TypeElement> errorElements = this.getErrorFamilies(roundEnv);
            this.generateErrorType(errorElements);
        }
        catch (MetaException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
        }
        return true;
    }

    private Map<TypeElement, ImmutableType> parseImmutableTypes(RoundEnvironment roundEnv) {
        HashMap<TypeElement, ImmutableType> map = new HashMap<TypeElement, ImmutableType>();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.context.isImmutable(typeElement = (TypeElement)element) || !this.include(typeElement)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException(typeElement, "immutable type must be interface");
            }
            ImmutableType immutableType = this.context.getImmutableType(typeElement);
            map.put(typeElement, immutableType);
        }
        return map;
    }

    private Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> parseDtoTypes(Collection<ImmutableType> immutableTypes) {
        String basePath;
        try {
            basePath = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", "dummy.txt").toUri().toString();
        }
        catch (IOException ex) {
            throw new DtoException("Failed to guess base project dir", ex);
        }
        if (basePath.startsWith("file://")) {
            basePath = basePath.substring(7);
        } else if (basePath.startsWith("file:/")) {
            basePath = basePath.substring(6);
        }
        basePath = basePath.substring(0, basePath.lastIndexOf(47));
        HashMap<String, String> actualPathMap = new HashMap<String, String>();
        for (File baseFile = new File(basePath); baseFile != null; baseFile = baseFile.getParentFile()) {
            this.collectActualDtoDir(baseFile, actualPathMap);
        }
        HashMap<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> dtoMap = new HashMap<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>>();
        for (ImmutableType immutableType : immutableTypes) {
            if (!immutableType.isEntity()) continue;
            for (Map.Entry e : actualPathMap.entrySet()) {
                List dtoTypes;
                String relativePath = immutableType.getQualifiedName().replace('.', '/') + ".dto";
                File dtoFile = new File((String)e.getKey() + '/' + relativePath);
                if (!dtoFile.exists()) continue;
                try (InputStream in = Files.newInputStream(dtoFile.toPath(), new OpenOption[0]);){
                    dtoTypes = new AptDtoCompiler(immutableType, (String)e.getValue() + '/' + relativePath).compile(in);
                }
                catch (DtoAstException ex) {
                    throw new DtoException("Failed to parse \"" + dtoFile.getAbsolutePath() + "\": " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new DtoException("Failed to read \"" + dtoFile.getAbsolutePath() + "\": " + ex.getMessage(), ex);
                }
                dtoMap.put(immutableType, dtoTypes);
            }
        }
        for (Map.Entry entry : dtoMap.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            for (DtoType dtoType : (List)entry.getValue()) {
                for (Map.Entry otherEntry : dtoMap.entrySet()) {
                    ImmutableType otherType = (ImmutableType)otherEntry.getKey();
                    for (DtoType otherDtoType : (List)otherEntry.getValue()) {
                        if (type == otherType || !Objects.equals(dtoType.getName(), otherDtoType.getName())) continue;
                        throw new DtoException("Conflict dto type name, the \"" + type.getQualifiedName() + "\" and \"" + otherType.getQualifiedName() + "\" are belong to same package, but they have define a dto type named \"" + dtoType.getName() + "\"");
                    }
                }
            }
        }
        return dtoMap;
    }

    private List<TypeElement> getErrorFamilies(RoundEnvironment roundEnv) {
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.include((TypeElement)element) || element.getAnnotation(ErrorFamily.class) == null) continue;
            if (element.getKind() != ElementKind.ENUM) {
                throw new MetaException(element, "only enum can be decorated by @" + ErrorFamily.class.getName());
            }
            typeElements.add((TypeElement)element);
        }
        return typeElements;
    }

    private boolean include(TypeElement typeElement) {
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (this.includes != null) {
            boolean matched = false;
            String[] stringArray = this.includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                if (!qualifiedName.startsWith(include)) continue;
                return true;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!qualifiedName.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    private void generateJimmerTypes(Collection<ImmutableType> immutableTypes, RoundEnvironment roundEnv) {
        for (ImmutableType immutableType : immutableTypes) {
            new DraftGenerator(immutableType, this.filer).generate();
            new PropsGenerator(this.context, immutableType, this.filer).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                new TableGenerator(this.context, immutableType, false, this.filer).generate();
                new TableGenerator(this.context, immutableType, true, this.filer).generate();
                new FetcherGenerator(this.context, immutableType, this.filer).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            new PropExpressionGenerator(this.context, immutableType, this.filer).generate();
        }
        if (!this.jimmerModuleGenerated) {
            new JimmerModuleGenerator(this.processedTypeElements, this.filer).generate();
            this.jimmerModuleGenerated = true;
        }
    }

    private void generateErrorType(List<TypeElement> typeElements) {
        for (TypeElement typeElement : typeElements) {
            new ErrorGenerator(typeElement, this.filer).generate();
        }
    }

    private void generateDtoTypes(Map<?, List<DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap) {
        for (List<DtoType<ImmutableType, ImmutableProp>> dtoTypes : dtoTypeMap.values()) {
            for (DtoType<ImmutableType, ImmutableProp> dtoType : dtoTypes) {
                new DtoGenerator(dtoType, this.filer).generate();
            }
        }
    }

    private void collectActualDtoDir(File baseFile, Map<String, String> actualPathMap) {
        for (String dtoDir : this.dtoDirs) {
            File subFile = baseFile;
            for (String part : dtoDir.split("/")) {
                if ((subFile = new File(subFile, part)).isDirectory()) continue;
                subFile = null;
                break;
            }
            if (subFile == null) continue;
            String path = subFile.getAbsolutePath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            actualPathMap.put(path, dtoDir);
        }
    }
}

