/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.PropsGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;

public class PropExpressionGenerator {
    private final Context context;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public PropExpressionGenerator(Context context, ImmutableType type, Filer filer) {
        this.context = context;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateImpl()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate embedded prop expression class for '%s'", this.type.getName()), ex);
        }
    }

    private TypeSpec generateImpl() {
        TypeSpec.Builder builder;
        this.typeBuilder = builder = TypeSpec.classBuilder((ClassName)this.type.getPropExpressionClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPED_EMBEDDED_PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        try {
            this.addConstructor();
            this.addProps();
        }
        finally {
            this.typeBuilder = null;
        }
        return builder.build();
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.EMBEDDED_PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "raw", new Modifier[0]).addStatement("super(raw)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProps() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.typeBuilder.addMethod(PropsGenerator.property(this.context, false, prop, false, true, true));
        }
    }
}

